/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.BaseOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;

public class EdgeMatchOperation
extends BaseOperation {
    @HopMetadataProperty
    protected String sourceAlias;
    @HopMetadataProperty
    protected String edgeAlias;
    @HopMetadataProperty
    protected String edgeLabel;
    @HopMetadataProperty
    protected String targetAlias;

    public EdgeMatchOperation() {
        super(OperationType.EDGE_MATCH);
    }

    protected EdgeMatchOperation(OperationType operationType) {
        super(operationType);
    }

    public EdgeMatchOperation(String sourceAlias, String edgeAlias, String edgeLabel, String targetAlias) {
        this();
        this.sourceAlias = sourceAlias;
        this.edgeAlias = edgeAlias;
        this.edgeLabel = edgeLabel;
        this.targetAlias = targetAlias;
    }

    public EdgeMatchOperation(EdgeMatchOperation o) {
        super(o.operationType);
        this.sourceAlias = o.sourceAlias;
        this.edgeAlias = o.edgeAlias;
        this.edgeLabel = o.edgeLabel;
        this.targetAlias = o.targetAlias;
    }

    @Override
    public EdgeMatchOperation clone() {
        return new EdgeMatchOperation(this);
    }

    @Override
    public String getCypherClause(String unwindAlias, List<Parameter> parameters) throws HopException {
        StringBuilder cypher = new StringBuilder(this.operationType.keyWord());
        cypher.append("(").append(this.sourceAlias).append(")");
        cypher.append("-[").append(this.edgeAlias).append(":").append(this.edgeLabel).append("]->");
        cypher.append("(").append(this.targetAlias).append(") ");
        return cypher.toString();
    }

    @Override
    public boolean needsWriteTransaction() {
        return false;
    }

    public String getSourceAlias() {
        return this.sourceAlias;
    }

    public void setSourceAlias(String sourceAlias) {
        this.sourceAlias = sourceAlias;
    }

    public String getEdgeAlias() {
        return this.edgeAlias;
    }

    public void setEdgeAlias(String edgeAlias) {
        this.edgeAlias = edgeAlias;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public void setEdgeLabel(String edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    public String getTargetAlias() {
        return this.targetAlias;
    }

    public void setTargetAlias(String targetAlias) {
        this.targetAlias = targetAlias;
    }
}

