/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.SecurityUtil;

public class SecureDataNodeStarter
implements Daemon {
    private String[] args;
    private SecureResources resources;

    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing secure datanode resources");
        HdfsConfiguration conf = new HdfsConfiguration();
        this.args = context.getArguments();
        this.resources = SecureDataNodeStarter.getSecureResources((Configuration)conf);
    }

    public void start() throws Exception {
        System.err.println("Starting regular datanode initialization");
        DataNode.secureMain(this.args, this.resources);
    }

    public void destroy() {
    }

    public void stop() throws Exception {
    }

    @VisibleForTesting
    public static SecureResources getSecureResources(Configuration conf) throws Exception {
        ServerSocketChannel httpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        boolean isSaslEnabled = DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf) != null;
        boolean isHttpPrivileged = false;
        System.err.println("isSaslEnabled:" + isSaslEnabled);
        InetSocketAddress streamingAddr = DataNode.getStreamingAddr(conf);
        int socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        int backlogLength = conf.getInt("ipc.server.listen.queue.size", 128);
        ServerSocket ss = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        try {
            ss.bind(streamingAddr, backlogLength);
        }
        catch (BindException e) {
            BindException newBe = SecureDataNodeStarter.appendMessageToBindException(e, streamingAddr.toString());
            throw newBe;
        }
        if (ss.getLocalPort() != streamingAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified streaming port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
        }
        boolean isRpcPrivileged = SecurityUtil.isPrivilegedPort((int)ss.getLocalPort());
        System.err.println("Opened streaming server at " + streamingAddr);
        if (policy.isHttpEnabled()) {
            httpChannel = ServerSocketChannel.open();
            InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
            try {
                httpChannel.socket().bind(infoSocAddr);
            }
            catch (BindException e) {
                BindException newBe = SecureDataNodeStarter.appendMessageToBindException(e, infoSocAddr.toString());
                throw newBe;
            }
            InetSocketAddress localAddr = (InetSocketAddress)httpChannel.socket().getLocalSocketAddress();
            if (localAddr.getPort() != infoSocAddr.getPort()) {
                throw new RuntimeException("Unable to bind on specified info port in secure context. Needed " + infoSocAddr.getPort() + ", got " + ss.getLocalPort());
            }
            System.err.println("Successfully obtained privileged resources (streaming port = " + ss + " ) (http listener port = " + localAddr.getPort() + ")");
            isHttpPrivileged = SecurityUtil.isPrivilegedPort((int)localAddr.getPort());
            System.err.println("Opened info server at " + infoSocAddr);
        } else {
            httpChannel = null;
        }
        return new SecureResources(ss, httpChannel, isSaslEnabled, isRpcPrivileged, isHttpPrivileged);
    }

    private static BindException appendMessageToBindException(BindException e, String msg) {
        BindException newBe = new BindException(e.getMessage() + " " + msg);
        newBe.initCause(e.getCause());
        newBe.setStackTrace(e.getStackTrace());
        return newBe;
    }

    public static class SecureResources {
        private final boolean isSaslEnabled;
        private final boolean isRpcPortPrivileged;
        private final boolean isHttpPortPrivileged;
        private final ServerSocket streamingSocket;
        private final ServerSocketChannel httpServerSocket;

        public SecureResources(ServerSocket streamingSocket, ServerSocketChannel httpServerSocket, boolean saslEnabled, boolean rpcPortPrivileged, boolean httpPortPrivileged) {
            this.streamingSocket = streamingSocket;
            this.httpServerSocket = httpServerSocket;
            this.isSaslEnabled = saslEnabled;
            this.isRpcPortPrivileged = rpcPortPrivileged;
            this.isHttpPortPrivileged = httpPortPrivileged;
        }

        public ServerSocket getStreamingSocket() {
            return this.streamingSocket;
        }

        public ServerSocketChannel getHttpServerChannel() {
            return this.httpServerSocket;
        }

        public boolean isSaslEnabled() {
            return this.isSaslEnabled;
        }

        public boolean isRpcPortPrivileged() {
            return this.isRpcPortPrivileged;
        }

        public boolean isHttpPortPrivileged() {
            return this.isHttpPortPrivileged;
        }
    }
}

