/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMasterClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;

public class TieredInternalShuffleMaster {
    private final TieredStorageMasterClient tieredStorageMasterClient;

    public TieredInternalShuffleMaster(Configuration conf) {
        TieredStorageConfiguration tieredStorageConfiguration = TieredStorageConfiguration.builder((String)conf.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_REMOTE_STORAGE_BASE_PATH)).build();
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        List<TierMasterAgent> tierFactories = tieredStorageConfiguration.getTierFactories().stream().map(tierFactory -> tierFactory.createMasterAgent(resourceRegistry)).collect(Collectors.toList());
        this.tieredStorageMasterClient = new TieredStorageMasterClient(tierFactories);
    }

    public void addPartition(ResultPartitionID resultPartitionID) {
        this.tieredStorageMasterClient.addPartition(TieredStorageIdMappingUtils.convertId(resultPartitionID));
    }

    public void releasePartition(ResultPartitionID resultPartitionID) {
        this.tieredStorageMasterClient.releasePartition(TieredStorageIdMappingUtils.convertId(resultPartitionID));
    }
}

