/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueueImpl;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DataQueueEvent;
import com.ibm.as400.access.DataQueueListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ObjectEvent;
import com.ibm.as400.access.ObjectListener;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public abstract class BaseDataQueue
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.BaseDataQueue";
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = "";
    private String name_ = "";
    private int ccsid_ = 0;
    private transient Converter dataConverter_ = null;
    int maxEntryLength_ = 0;
    boolean saveSenderInformation_ = false;
    boolean FIFO_ = false;
    boolean forceToAuxiliaryStorage_ = false;
    String description_ = null;
    boolean attributesRetrieved_ = false;
    transient BaseDataQueueImpl impl_ = null;
    transient Vector dataQueueListeners_ = null;
    transient Vector objectListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public BaseDataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BaseDataQueue object.");
        }
    }

    public BaseDataQueue(AS400 system, String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BaseDataQueue object, system: " + system + " path: " + path);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "DTAQ");
        this.library_ = ifs.getLibraryName();
        this.name_ = ifs.getObjectName();
        this.path_ = path;
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataQueueListener(DataQueueListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding data queue listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.dataQueueListeners_ == null) {
                this.dataQueueListeners_ = new Vector();
            }
            this.dataQueueListeners_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectListener(ObjectListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding object listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.objectListeners_ == null) {
                this.objectListeners_ = new Vector();
            }
            this.objectListeners_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    synchronized void open() throws AS400SecurityException, IOException {
        boolean opened = this.impl_ == null;
        this.chooseImpl();
        if (opened) {
            this.fireObjectEvent(3);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to data queue server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                Trace.log(2, "Cannot connect to data queue server before setting path.");
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = (BaseDataQueueImpl)this.system_.loadImpl3("com.ibm.as400.access.BaseDataQueueImplNative", "com.ibm.as400.access.BaseDataQueueImplRemote", "com.ibm.as400.access.BaseDataQueueImplProxy");
            this.impl_.setSystemAndPath(this.system_.getImpl(), this.path_, this.name_, this.library_);
        }
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing data queue.");
        }
        this.open();
        this.impl_.clear(null);
        this.fireDataQueueEvent(0);
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting data queue.");
        }
        this.chooseImpl();
        this.impl_.delete();
        this.attributesRetrieved_ = false;
        this.fireObjectEvent(2);
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking data queue existence.");
        }
        this.attributesRetrieved_ = false;
        try {
            this.getMaxEntryLength();
            return true;
        }
        catch (ObjectDoesNotExistException e) {
            return false;
        }
    }

    void fireDataQueueEvent(int id) {
        if (this.dataQueueListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.dataQueueListeners_.clone();
        DataQueueEvent event = new DataQueueEvent(this, id);
        block6: for (int i = 0; i < targets.size(); ++i) {
            DataQueueListener target = (DataQueueListener)targets.elementAt(i);
            switch (id) {
                case 0: {
                    target.cleared(event);
                    continue block6;
                }
                case 1: {
                    target.peeked(event);
                    continue block6;
                }
                case 2: {
                    target.read(event);
                    continue block6;
                }
                case 3: {
                    target.written(event);
                }
            }
        }
    }

    void fireObjectEvent(int id) {
        if (this.objectListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.objectListeners_.clone();
        ObjectEvent event = new ObjectEvent(this);
        block5: for (int i = 0; i < targets.size(); ++i) {
            ObjectListener target = (ObjectListener)targets.elementAt(i);
            switch (id) {
                case 1: {
                    target.objectCreated(event);
                    continue block5;
                }
                case 2: {
                    target.objectDeleted(event);
                    continue block5;
                }
                case 3: {
                    target.objectOpened(event);
                }
            }
        }
    }

    public int getCcsid() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public String getDescription() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting description.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Description: " + this.description_);
        }
        return this.description_;
    }

    public boolean getForceToAuxiliaryStorage() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting force to auxiliary storage.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Force to auxiliary storage:", this.forceToAuxiliaryStorage_);
        }
        return this.forceToAuxiliaryStorage_;
    }

    public int getMaxEntryLength() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting max entry length.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Max entry length:", this.maxEntryLength_);
        }
        return this.maxEntryLength_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public boolean getSaveSenderInformation() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting save sender information.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Save sender information:", this.saveSenderInformation_);
        }
        return this.saveSenderInformation_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public boolean isFIFO() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if data queue is FIFO.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "FIFO:", this.FIFO_);
        }
        return this.FIFO_;
    }

    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing data queue attributes.");
        }
        this.attributesRetrieved_ = false;
        this.open();
        this.retrieveAttributes();
    }

    public void removeDataQueueListener(DataQueueListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing data queue listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.dataQueueListeners_ != null) {
            this.dataQueueListeners_.removeElement(listener);
        }
    }

    public void removeObjectListener(ObjectListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing object listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.objectListeners_ != null) {
            this.objectListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    abstract void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException;

    public void setCcsid(int ccsid) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting CCSID:", ccsid);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.ccsid_ = ccsid;
            this.dataConverter_ = null;
        } else {
            Integer oldValue = this.ccsid_;
            Integer newValue = ccsid;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("ccsid", oldValue, newValue);
            }
            this.ccsid_ = ccsid;
            this.dataConverter_ = null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("ccsid", oldValue, newValue);
            }
        }
    }

    public void setPath(String path) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + path);
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "DTAQ");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = path;
        } else {
            String oldValue = this.path_;
            String newValue = path;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", oldValue, newValue);
            }
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = path;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", oldValue, newValue);
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public String toString() {
        return "(system: " + this.system_ + " path: " + this.path_ + "):" + super.toString();
    }

    private int getCcsidToUse() {
        if (this.ccsid_ == 0) {
            return this.system_.getCcsid();
        }
        return this.ccsid_;
    }

    byte[] stringToByteArray(String string) throws IOException {
        if (this.dataConverter_ == null) {
            this.dataConverter_ = new Converter(this.getCcsidToUse(), this.system_);
        }
        return this.dataConverter_.stringToByteArray(string);
    }

    String byteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
        if (this.dataConverter_ == null) {
            this.dataConverter_ = new Converter(this.getCcsidToUse(), this.system_);
        }
        return this.dataConverter_.byteArrayToString(bytes);
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

