/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTF;
import com.ibm.as400.access.ProductDirectoryInformation;
import com.ibm.as400.access.ProductLicense;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class Product {
    private static final String USERSPACE_NAME = "JT4PTF    QTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC";
    private boolean loaded_ = false;
    private boolean loadedLoadID_ = false;
    private boolean partiallyLoaded_ = false;
    private boolean loadedOptions_ = false;
    private boolean loadedDescriptionText_ = false;
    private boolean loaded500_ = false;
    private boolean loaded800_ = false;
    private boolean error100_ = false;
    private boolean error500_ = false;
    private boolean error800_ = false;
    private AS400 system_;
    private String productID_;
    private String productOption_;
    private String releaseLevel_;
    private String descriptionID_;
    private String descriptionText_;
    private String messageFile_;
    private boolean installed_ = true;
    private String loadID_;
    private String loadType_;
    private String symbolicLoadState_;
    private boolean loadErrorIndicator_;
    private String loadState_;
    private boolean supported_;
    private String registrationType_;
    private String registrationValue_;
    private String primaryLanguageLoadID_;
    private String minimumTargetRelease_;
    private String minimumBaseVRM_;
    private int requirementsMet_;
    private String level_;
    private boolean allowsMultipleReleases_;
    private Date releaseDate_;
    private String firstCopyright_;
    private String currentCopyright_;
    private boolean allowsDynamicNaming_;
    private String minimumVRM_;
    private boolean allowsMixedReleases_;
    private ProductDirectoryInformation[] directories_;
    private Product[] options_;
    private int chunkSize_ = 8192;
    public static final String LOAD_STATE_DEFINED_NO_OBJECT = "10";
    public static final String LOAD_STATE_DEFINED_OBJECT_EXISTS = "20";
    public static final String LOAD_STATE_PACKAGED_RESTORE_FAILED_EXIT_PROGRAM_FAILED = "3E";
    public static final String LOAD_STATE_PACKAGED_RESTORE_FAILED = "3F";
    public static final String LOAD_STATE_PACKAGED = "30";
    public static final String LOAD_STATE_PACKAGED_RENAMED = "32";
    public static final String LOAD_STATE_PACKAGED_DAMAGED = "33";
    public static final String LOAD_STATE_PACKAGED_DELETED = "34";
    public static final String LOAD_STATE_PACKAGED_RESTORE_IN_PROGRESS = "35";
    public static final String LOAD_STATE_PACKAGED_DELETE_IN_PROGRESS = "38";
    public static final String LOAD_STATE_INSTALLED_RESTORE_IN_PROGRESS = "50";
    public static final String LOAD_STATE_INSTALLED_DELETE_IN_PROGRESS = "53";
    public static final String LOAD_STATE_IBM_SUPPLIED_NOT_COMPATIBLE = "59";
    public static final String LOAD_STATE_INSTALLED_RESTORE_FAILED_EXIT_PROGRAM_FAILED = "6E";
    public static final String LOAD_STATE_INSTALLED_RESTORE_FAILED = "6F";
    public static final String LOAD_STATE_RESTORED = "60";
    public static final String LOAD_STATE_RESTORED_EXIT_PROGRAM_FAILED = "61";
    public static final String LOAD_STATE_RESTORED_RENAMED = "62";
    public static final String LOAD_STATE_RESTORED_DAMAGED = "63";
    public static final String LOAD_STATE_RESTORED_DELETED = "64";
    public static final String LOAD_STATE_CHECK_ERROR = "67";
    public static final String LOAD_STATE_INSTALLED = "90";
    public static final String LOAD_TYPE_CODE = "*CODE";
    public static final String LOAD_TYPE_LANGUAGE = "*LNG";
    public static final String PRODUCT_OPTION_BASE = "*BASE";
    public static final String PRODUCT_FEATURE_CODE = "*CODE";
    public static final String PRODUCT_ID_OPERATING_SYSTEM = "*OPSYS";
    public static final String PRODUCT_RELEASE_CURRENT = "*CUR";
    public static final String PRODUCT_RELEASE_ONLY = "*ONLY";
    public static final String PRODUCT_RELEASE_PREVIOUS = "*PRV";
    public static final String PRODUCT_RELEASE_ANY = "ANY";
    public static final String REGISTRATION_TYPE_PHONE = "02";
    public static final String REGISTRATION_TYPE_SYSTEM = "04";
    public static final String REGISTRATION_TYPE_CUSTOMER = "08";
    public static final int REQUIREMENTS_UNKNOWN = 0;
    public static final int REQUIREMENTS_MET = 1;
    public static final int REQUIREMENTS_OPTION_TOO_OLD = 2;
    public static final int REQUIREMENTS_BASE_TOO_OLD = 3;
    public static final String SYMBOLIC_LOAD_STATE_DEFINED = "*DEFINED";
    public static final String SYMBOLIC_LOAD_STATE_CREATED = "*CREATED";
    public static final String SYMBOLIC_LOAD_STATE_PACKAGED = "*PACKAGED";
    public static final String SYMBOLIC_LOAD_STATE_DAMAGED = "*DAMAGED";
    public static final String SYMBOLIC_LOAD_STATE_LOADED = "*LOADED";
    public static final String SYMBOLIC_LOAD_STATE_INSTALLED = "*INSTALLED";

    public Product(AS400 system, String productID) {
        this(system, productID, PRODUCT_OPTION_BASE, PRODUCT_RELEASE_ANY, "*CODE");
    }

    public Product(AS400 system, String productID, String productOption) {
        this(system, productID, productOption, PRODUCT_RELEASE_ANY, "*CODE");
    }

    public Product(AS400 system, String productID, String productOption, String releaseLevel, String featureID) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (productID == null) {
            throw new NullPointerException("productID");
        }
        if (productOption == null) {
            throw new NullPointerException("productOption");
        }
        if (releaseLevel == null) {
            throw new NullPointerException("releaseLevel");
        }
        if (featureID == null) {
            throw new NullPointerException("featureID");
        }
        String id = productID.toUpperCase().trim();
        if (id.length() != 7 && !id.equals(PRODUCT_ID_OPERATING_SYSTEM)) {
            throw new ExtendedIllegalArgumentException("productID(" + id + ")", 1);
        }
        String option = productOption.toUpperCase().trim();
        if (option.equals(PRODUCT_OPTION_BASE)) {
            option = "0000";
        }
        if (option.length() > 4) {
            throw new ExtendedIllegalArgumentException(id + ".productOption(" + option + ")", 1);
        }
        while (option.length() < 4) {
            option = "0" + option;
        }
        String level = releaseLevel.toUpperCase().trim();
        if (!(level.length() == 6 || level.length() == 0 || level.equals(PRODUCT_RELEASE_CURRENT) || level.equals(PRODUCT_RELEASE_ONLY) || level.equals(PRODUCT_RELEASE_PREVIOUS) || level.equals(PRODUCT_RELEASE_ANY))) {
            throw new ExtendedIllegalArgumentException("releaseLevel", 1);
        }
        String load = featureID.toUpperCase().trim();
        if (load.length() != 4 && !load.equals("*CODE")) {
            throw new ExtendedIllegalArgumentException("featureID", 1);
        }
        this.system_ = system;
        this.productID_ = id;
        this.productOption_ = option;
        this.releaseLevel_ = level;
        this.loadID_ = load;
    }

    public Product(AS400 system, String productID, String productOption, String releaseLevel, String loadType, String languageID) {
        this(system, productID, productOption, releaseLevel, "*CODE");
        if (loadType == null) {
            throw new NullPointerException("loadType");
        }
        if (languageID == null) {
            throw new NullPointerException("languageID");
        }
        this.loadType_ = loadType;
        this.primaryLanguageLoadID_ = languageID;
    }

    Product(AS400 system, String id, String option, String level, String feature, boolean allow, String msgID, String minVRM) {
        this(system, id, option, level, feature);
        this.allowsDynamicNaming_ = allow;
        this.descriptionID_ = msgID;
        this.minimumVRM_ = minVRM;
        this.loadedOptions_ = true;
    }

    Product(AS400 system, String id, String option, String level, String descriptionID, String descriptionText, String messageFile, boolean installed, boolean supported, String regType, String regValue) {
        this.system_ = system;
        this.productID_ = id;
        if (option.equals(PRODUCT_OPTION_BASE)) {
            option = "0000";
        } else if (option.length() > 4) {
            option = option.substring(1, 5);
        }
        this.productOption_ = option;
        this.releaseLevel_ = level;
        this.descriptionID_ = descriptionID;
        this.descriptionText_ = descriptionText;
        this.messageFile_ = messageFile;
        this.installed_ = installed;
        this.supported_ = supported;
        this.registrationType_ = regType;
        this.registrationValue_ = regValue;
        this.partiallyLoaded_ = true;
    }

    public boolean allowsDynamicNaming() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.allowsDynamicNaming_;
    }

    public boolean allowsMixedReleases() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.allowsMixedReleases_;
    }

    public boolean allowsMultipleReleases() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.allowsMultipleReleases_;
    }

    private void fillInOptionInformation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Product[] products = this.getProductOptions();
        for (int i = 0; i < products.length; ++i) {
            if (!products[i].getProductOption().equals(this.productOption_)) continue;
            this.allowsDynamicNaming_ = products[i].allowsDynamicNaming_;
            this.descriptionID_ = products[i].descriptionID_;
            this.minimumVRM_ = products[i].minimumVRM_;
            return;
        }
    }

    public String getCurrentCopyright() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.currentCopyright_;
    }

    public String getDescriptionID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.descriptionID_;
    }

    public String getDescriptionMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.partiallyLoaded_ && !this.loaded500_) {
            this.refresh(500);
        }
        return this.messageFile_;
    }

    public String getDescriptionText() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.partiallyLoaded_ && !this.loadedDescriptionText_) {
            block3: {
                String fileName = this.getDescriptionMessageFile();
                String id = this.getDescriptionID();
                try {
                    MessageFile mf = new MessageFile(this.system_, fileName);
                    AS400Message msg = mf.getMessage(id);
                    this.descriptionText_ = msg.getText();
                }
                catch (Exception e) {
                    if (!Trace.traceOn_) break block3;
                    Trace.log(2, "Unable to retrieve product description text for " + fileName + " and " + id + ": ", (Throwable)e);
                }
            }
            this.loadedDescriptionText_ = true;
        }
        return this.descriptionText_;
    }

    public ProductDirectoryInformation[] getDirectoryInformation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded800_) {
            this.refresh(800);
        }
        return this.directories_;
    }

    public String getFeatureID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.loadID_ == null && !this.loadedLoadID_) {
            this.refresh(100);
        }
        return this.loadID_;
    }

    public String getFirstCopyright() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.firstCopyright_;
    }

    public String getLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.level_;
    }

    public ProductLicense getLicense() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String feature = this.getFeatureID();
        String level = this.getReleaseLevel();
        ProductLicense license = new ProductLicense(this.system_, this.productID_, feature, level);
        return license;
    }

    public String getLoadState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadState_;
    }

    public String getLoadType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadType_;
    }

    public String getMinimumRequiredRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.minimumVRM_;
    }

    public String getMinimumRequiredReleaseForBase() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.minimumBaseVRM_;
    }

    public String getMinimumTargetRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.minimumTargetRelease_;
    }

    public String getPrimaryLanguageFeatureID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.primaryLanguageLoadID_;
    }

    public String getProductID() {
        return this.productID_;
    }

    public String getProductOption() {
        return this.productOption_;
    }

    public Product[] getProductOptions() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.options_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PTF[] getPTFs(boolean includeSupersededPTFs) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object text10;
        ProgramParameter[] parms;
        ConvTable conv;
        block22: {
            if (!this.isInstalled()) {
                return new PTF[0];
            }
            int ccsid = this.system_.getCcsid();
            conv = ConvTable.getTable(ccsid, null);
            parms = new ProgramParameter[4];
            try {
                parms[0] = new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME));
                parms[0].setParameterType(2);
                byte[] prodInfo = new byte[50];
                AS400Text text4 = new AS400Text(4, ccsid, this.system_);
                AS400Text text6 = new AS400Text(6, ccsid, this.system_);
                AS400Text text7 = new AS400Text(7, ccsid, this.system_);
                text10 = new AS400Text(10, ccsid, this.system_);
                text7.toBytes(this.productID_, prodInfo, 0);
                text6.toBytes(this.getReleaseLevel(), prodInfo, 7);
                text4.toBytes(this.productOption_, prodInfo, 13);
                if (this.loadID_ == null) {
                    this.refresh(100);
                }
                ((AS400Text)text10).toBytes(this.loadID_.equals("*CODE") ? "*ALL" : this.loadID_, prodInfo, 17);
                prodInfo[27] = includeSupersededPTFs ? -15 : -16;
                parms[1] = new ProgramParameter(prodInfo);
                parms[1].setParameterType(2);
                parms[2] = new ProgramParameter(conv.stringToByteArray("PTFL0100"));
                parms[2].setParameterType(2);
                parms[3] = new ProgramParameter(new byte[4]);
                parms[3].setParameterType(2);
            }
            catch (PropertyVetoException pve) {
                if (!Trace.traceOn_) break block22;
                Trace.log(2, pve);
            }
        }
        ServiceProgramCall pc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZLSTFX.SRVPGM", "QpzListPTF", 0, parms);
        boolean willRunProgramsOnThread = pc.isStayOnThread();
        Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        byte[] buf = null;
        text10 = lockObject;
        synchronized (text10) {
            UserSpace us = new UserSpace(this.system_, USERSPACE_PATH);
            us.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                us.setMustUseSockets(true);
            }
            try {
                us.create(262144, true, "", (byte)0, "User space for PTF list", "*EXCLUDE");
                if (!pc.run()) {
                    AS400Message[] messages = pc.getMessageList();
                    if (messages.length == 1 && (messages[0].getID().equalsIgnoreCase("CPF6601") || messages[0].getID().equalsIgnoreCase("CPF35BE"))) {
                        PTF[] pTFArray = new PTF[]{};
                        return pTFArray;
                    }
                    throw new AS400Exception(pc.getMessageList());
                }
                int size = us.getLength();
                buf = new byte[size];
                us.read(buf, 0);
            }
            finally {
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
        }
        int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
        int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
        int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
        int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
        conv = ConvTable.getTable(entryCCSID, null);
        int offset = 0;
        PTF[] ptfs = new PTF[numEntries];
        int i = 0;
        while (i < numEntries) {
            offset = startingOffset + i * entrySize;
            String ptfID = conv.byteArrayToString(buf, offset, 7);
            String ptfReleaseLevel = conv.byteArrayToString(buf, offset += 7, 6);
            String ptfProductOption = conv.byteArrayToString(buf, offset += 6, 4);
            String ptfProductLoad = conv.byteArrayToString(buf, offset += 4, 4);
            offset += 4;
            String loadedStatus = conv.byteArrayToString(buf, offset++, 1);
            boolean saveFileExists = buf[offset++] == -15;
            boolean hasCoverLetter = buf[offset++] == -15;
            boolean ptfOnOrder = buf[offset++] == -15;
            int iplAction = buf[offset++] & 0xF;
            boolean actionPending = buf[offset++] == -15;
            String actionRequired = conv.byteArrayToString(buf, offset++, 1);
            String iplRequired = conv.byteArrayToString(buf, offset++, 1);
            boolean isPTFReleased = buf[offset++] == -15;
            String minimumLevel = conv.byteArrayToString(buf, offset, 2);
            String maximumLevel = conv.byteArrayToString(buf, offset += 2, 2);
            String d = conv.byteArrayToString(buf, offset += 2, 13);
            Date statusDate = null;
            if (d.trim().length() == 13) {
                Calendar cal = AS400Calendar.getGregorianInstance();
                cal.clear();
                cal.set(Integer.parseInt(d.substring(0, 3)) + 1900, Integer.parseInt(d.substring(3, 5)) - 1, Integer.parseInt(d.substring(5, 7)), Integer.parseInt(d.substring(7, 9)), Integer.parseInt(d.substring(9, 11)), Integer.parseInt(d.substring(11, 13)));
                statusDate = cal.getTime();
            }
            ptfs[i] = new PTF(this.system_, this.productID_, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad, loadedStatus, saveFileExists, hasCoverLetter, ptfOnOrder, iplAction, actionPending, actionRequired, iplRequired, isPTFReleased, minimumLevel, maximumLevel, statusDate);
            ++i;
        }
        return ptfs;
    }

    public String getRegistrationType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.registrationType_;
    }

    public String getRegistrationValue() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.registrationValue_;
    }

    public Date getReleaseDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.releaseDate_;
    }

    public String getReleaseLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.releaseLevel_.equals(PRODUCT_RELEASE_CURRENT) || this.releaseLevel_.equals(PRODUCT_RELEASE_PREVIOUS) || this.releaseLevel_.equals(PRODUCT_RELEASE_ONLY) || this.releaseLevel_.equals(PRODUCT_RELEASE_ANY)) {
            this.refresh(100);
        }
        return this.releaseLevel_;
    }

    public int getRequirementsMet() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.requirementsMet_;
    }

    public String getSymbolicLoadState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getSymbolicLoadState(true);
    }

    private String getSymbolicLoadState(boolean logErrorsInJobLog) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100, logErrorsInJobLog);
        }
        return this.symbolicLoadState_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public boolean isInstalled() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.partiallyLoaded_) {
            return this.installed_;
        }
        try {
            return this.getSymbolicLoadState(false).equals(SYMBOLIC_LOAD_STATE_INSTALLED);
        }
        catch (AS400Exception e) {
            AS400Message[] messages = e.getAS400MessageList();
            if (messages.length == 1 && messages[0].getID().equalsIgnoreCase("CPF0C1F")) {
                return false;
            }
            throw e;
        }
    }

    public boolean isLoadInError() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadErrorIndicator_;
    }

    public boolean isSupported() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.supported_;
    }

    public boolean refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadedLoadID_ = false;
        if (!this.error500_ && !this.error100_) {
            this.refresh(500);
        }
        if (!this.error800_ && !this.error100_) {
            this.refresh(800);
        }
        if (this.error500_ && this.error800_ && !this.error100_) {
            this.refresh(100);
        }
        if (!this.error500_) {
            this.loadedDescriptionText_ = false;
            this.getDescriptionText();
        }
        this.fillInOptionInformation();
        return !this.error100_;
    }

    private void refresh(int whichFormat) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.refresh(whichFormat, true);
    }

    private void refresh(int whichFormat, boolean logErrorsInJobLog) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int bytesAvailable;
        block38: {
            if (this.releaseLevel_.equals(PRODUCT_RELEASE_ANY)) {
                this.error100_ = false;
                this.releaseLevel_ = PRODUCT_RELEASE_ONLY;
                try {
                    this.refresh(whichFormat);
                    return;
                }
                catch (AS400Exception aS400Exception) {
                    if (!this.error100_) break block38;
                    this.error100_ = false;
                    this.releaseLevel_ = PRODUCT_RELEASE_PREVIOUS;
                    try {
                        this.refresh(whichFormat);
                        return;
                    }
                    catch (AS400Exception aS400Exception2) {
                        if (!this.error100_) break block38;
                        this.error100_ = false;
                        this.releaseLevel_ = PRODUCT_RELEASE_CURRENT;
                        this.refresh(whichFormat);
                        return;
                    }
                }
            }
        }
        String format = null;
        int len = 0;
        switch (whichFormat) {
            case 100: {
                if (this.error100_) {
                    return;
                }
                format = "PRDR0100";
                len = 108;
                break;
            }
            case 500: {
                if (this.error500_) {
                    return;
                }
                format = "PRDR0500";
                len = 157 + this.chunkSize_;
                break;
            }
            case 800: {
                if (this.error800_) {
                    return;
                }
                format = "PRDR0800";
                len = 125 + this.chunkSize_;
                break;
            }
            default: {
                format = "PRDR0100";
                whichFormat = 100;
                len = 108;
            }
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        ProgramParameter[] parms = new ProgramParameter[6];
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(conv.stringToByteArray(format));
        byte[] productInfo = new byte[36];
        AS400Text text4 = new AS400Text(4, ccsid, this.system_);
        AS400Text text6 = new AS400Text(6, ccsid, this.system_);
        AS400Text text7 = new AS400Text(7, ccsid, this.system_);
        AS400Text text10 = new AS400Text(10, ccsid, this.system_);
        text7.toBytes(this.productID_, productInfo, 0);
        text6.toBytes(this.releaseLevel_, productInfo, 7);
        String option = this.productOption_;
        if (option.equals(PRODUCT_OPTION_BASE) || whichFormat == 500) {
            option = "0000";
        }
        text4.toBytes(option, productInfo, 13);
        text10.toBytes(this.loadID_ == null || whichFormat == 500 ? "*CODE" : this.loadID_, productInfo, 17);
        BinaryConverter.intToByteArray(36, productInfo, 28);
        BinaryConverter.intToByteArray(ccsid, productInfo, 32);
        parms[3] = new ProgramParameter(productInfo);
        parms[4] = logErrorsInJobLog ? new ErrorCodeParameter() : new ErrorCodeParameter(true, false);
        parms[5] = new ProgramParameter(conv.stringToByteArray("PRDI0200"));
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSZRTVPR.PGM", parms);
        boolean pcSucceeded = pc.run();
        AS400Message[] messages = null;
        if (logErrorsInJobLog) {
            if (!pcSucceeded) {
                messages = pc.getMessageList();
            }
        } else {
            ErrorCodeParameter errParm = (ErrorCodeParameter)parms[4];
            String msgID = errParm.getMessageID();
            if (msgID != null) {
                pcSucceeded = false;
                try {
                    String substData = errParm.getSubstitutionData();
                    MessageFile mf = new MessageFile(this.system_, "/QSYS.LIB/QCPFMSG.MSGF");
                    AS400Message msg = mf.getMessage(msgID, substData);
                    messages = new AS400Message[]{msg};
                }
                catch (Throwable t) {
                    Trace.log(2, "Error when retrieving error messages.", t);
                }
            }
        }
        if (!pcSucceeded) {
            if (messages.length == 1 && messages[0].getID().equalsIgnoreCase("CPF0C1F")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "No product definition found for " + this.toString() + " using format " + whichFormat + ".");
                }
                this.installed_ = false;
                if (whichFormat != 100) {
                    this.refresh(100);
                    if (whichFormat == 500) {
                        this.releaseDate_ = null;
                        this.firstCopyright_ = null;
                        this.currentCopyright_ = null;
                        this.options_ = new Product[0];
                        this.loaded500_ = true;
                        this.error500_ = true;
                    } else if (whichFormat == 800) {
                        this.directories_ = new ProductDirectoryInformation[0];
                        this.loaded500_ = true;
                        this.error800_ = true;
                    }
                    return;
                }
                this.error100_ = true;
            }
            throw new AS400Exception(messages);
        }
        byte[] outputData = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(outputData, 4))) {
            this.chunkSize_ = bytesAvailable;
            this.refresh(whichFormat);
            return;
        }
        this.releaseLevel_ = conv.byteArrayToString(outputData, 19, 6);
        if (whichFormat != 500) {
            this.loadID_ = conv.byteArrayToString(outputData, 29, 4);
            this.loadedLoadID_ = true;
        }
        this.loadType_ = conv.byteArrayToString(outputData, 33, 10).trim();
        this.symbolicLoadState_ = conv.byteArrayToString(outputData, 43, 10);
        this.loadErrorIndicator_ = !conv.byteArrayToString(outputData, 53, 10).trim().equals("*NONE");
        this.loadState_ = conv.byteArrayToString(outputData, 63, 2);
        this.supported_ = conv.byteArrayToString(outputData, 65, 1).equals("1");
        this.registrationType_ = conv.byteArrayToString(outputData, 66, 2);
        this.registrationValue_ = conv.byteArrayToString(outputData, 68, 14);
        this.primaryLanguageLoadID_ = conv.byteArrayToString(outputData, 88, 4);
        this.minimumTargetRelease_ = conv.byteArrayToString(outputData, 92, 6);
        this.minimumBaseVRM_ = conv.byteArrayToString(outputData, 98, 6);
        this.requirementsMet_ = outputData[104] & 0xF;
        this.level_ = conv.byteArrayToString(outputData, 105, 3);
        this.loaded_ = true;
        if (whichFormat == 500) {
            int offset = BinaryConverter.byteArrayToInt(outputData, 84);
            this.allowsMultipleReleases_ = outputData[offset++] == -15;
            boolean y2k = outputData[offset++] == -15;
            String d = conv.byteArrayToString(outputData, offset, 6);
            Date releaseDate = null;
            if (d.trim().length() == 6) {
                Calendar cal = AS400Calendar.getGregorianInstance();
                cal.clear();
                cal.set(Integer.parseInt(d.substring(0, 2)) + (y2k ? 2000 : 1900), Integer.parseInt(d.substring(2, 4)) - 1, Integer.parseInt(d.substring(4, 6)));
                releaseDate = cal.getTime();
            }
            this.releaseDate_ = releaseDate;
            this.firstCopyright_ = conv.byteArrayToString(outputData, offset += 6, 4);
            this.currentCopyright_ = conv.byteArrayToString(outputData, offset += 4, 4).trim();
            String fileName = conv.byteArrayToString(outputData, offset += 4, 10).trim();
            String fileLibrary = conv.byteArrayToString(outputData, offset += 10, 10).trim();
            this.messageFile_ = fileName.length() > 0 ? QSYSObjectPathName.toPath(fileLibrary, fileName, "MSGF") : "";
            int numOptions = BinaryConverter.byteArrayToInt(outputData, offset += 10);
            int entryLength = BinaryConverter.byteArrayToInt(outputData, offset += 4);
            int offsetToOptions = BinaryConverter.byteArrayToInt(outputData, offset += 4);
            this.allowsMixedReleases_ = outputData[offset += 4] == -15;
            this.options_ = new Product[numOptions];
            for (int i = 0; i < numOptions; ++i) {
                offset = offsetToOptions + entryLength * i;
                String prodOption = conv.byteArrayToString(outputData, offset, 4);
                boolean allow = outputData[offset += 4] == -15;
                String msgID = conv.byteArrayToString(outputData, ++offset, 7);
                String minVRM = conv.byteArrayToString(outputData, offset += 7, 6);
                this.options_[i] = new Product(this.system_, this.productID_, prodOption, this.releaseLevel_, this.getFeatureID(), allow, msgID, minVRM);
            }
            this.loaded500_ = true;
        } else if (whichFormat == 800) {
            boolean ccsidConversionSucceeded;
            int offset = BinaryConverter.byteArrayToInt(outputData, 84);
            int numEntries = BinaryConverter.byteArrayToInt(outputData, offset);
            if (numEntries == 0) {
                this.directories_ = new ProductDirectoryInformation[0];
                return;
            }
            int entryLength = BinaryConverter.byteArrayToInt(outputData, offset += 4);
            int entryOffset = BinaryConverter.byteArrayToInt(outputData, offset += 4);
            int entryCCSID = BinaryConverter.byteArrayToInt(outputData, offset += 4);
            offset += 4;
            boolean bl = ccsidConversionSucceeded = outputData[offset++] == -16;
            if (!ccsidConversionSucceeded) {
                ccsid = entryCCSID;
                conv = ConvTable.getTable(ccsid, null);
            }
            ProductDirectoryInformation[] info = new ProductDirectoryInformation[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                offset = entryOffset + i * entryLength;
                int primaryPathLength = BinaryConverter.byteArrayToInt(outputData, offset);
                int primaryPathOffset = BinaryConverter.byteArrayToInt(outputData, offset += 4);
                int installedPathLength = BinaryConverter.byteArrayToInt(outputData, offset += 12);
                int installedPathOffset = BinaryConverter.byteArrayToInt(outputData, offset += 4);
                int numAuthorities = BinaryConverter.byteArrayToInt(outputData, offset += 12);
                int offsetAuthorities = BinaryConverter.byteArrayToInt(outputData, offset += 4);
                String publicDataAuthority = conv.byteArrayToString(outputData, offset += 4, 10);
                String primaryFullPath = conv.byteArrayToString(outputData, primaryPathOffset, primaryPathLength);
                String installedFullPath = conv.byteArrayToString(outputData, installedPathOffset, installedPathLength);
                String[] authorities = new String[numAuthorities];
                for (int j = 0; j < numAuthorities; ++j) {
                    authorities[j] = conv.byteArrayToString(outputData, offsetAuthorities + j * 10, 10);
                }
                info[i] = new ProductDirectoryInformation(publicDataAuthority, primaryFullPath, installedFullPath, authorities);
            }
            this.directories_ = info;
            this.loaded800_ = true;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.productID_);
        buf.append('/');
        buf.append(this.productOption_);
        buf.append('/');
        buf.append(this.releaseLevel_);
        return buf.toString();
    }
}

