/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.SystemResourceFinder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class XMLErrorHandler
implements ErrorHandler {
    private String m_filename;
    private int m_headerLineCount;
    private boolean m_ignorePCML = false;
    private ParseException m_exc;

    public XMLErrorHandler(String sxml, int headerLineCount) {
        this.m_filename = sxml;
        this.m_headerLineCount = headerLineCount;
    }

    @Override
    public void error(SAXParseException spe) {
        String fname;
        int lineNumber = spe.getLineNumber();
        int columnNumber = spe.getColumnNumber();
        if (lineNumber - this.m_headerLineCount <= 0) {
            fname = "pcml.dtd";
            this.m_ignorePCML = true;
        } else {
            if (this.m_ignorePCML) {
                return;
            }
            fname = this.m_filename;
            lineNumber -= this.m_headerLineCount;
        }
        if (this.m_exc == null) {
            this.m_exc = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{fname}));
        }
        this.m_exc.addMessage("[" + lineNumber + "," + (columnNumber - 1) + "]: " + spe.getMessage());
    }

    @Override
    public void fatalError(SAXParseException spe) {
        this.error(spe);
    }

    @Override
    public void warning(SAXParseException spe) {
        String fname;
        int lineNumber = spe.getLineNumber();
        int columnNumber = spe.getColumnNumber();
        if (lineNumber - this.m_headerLineCount <= 0) {
            fname = "pcml.dtd";
        } else {
            fname = this.m_filename;
            lineNumber -= this.m_headerLineCount;
        }
        System.err.println(fname + "[" + lineNumber + "," + (columnNumber - 1) + "]: " + spe.getMessage());
    }

    public ParseException getException() {
        return this.m_exc;
    }
}

