/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemPool;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VSystemStatus
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static TableColumnModel detailsColumnModel_ = null;
    private static String description_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_STATUS");
    private static final Icon icon16_ = ResourceLoader.getIcon("VSystemStatus16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VSystemStatus32.gif", description_);
    private static String nameColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_NAME");
    private static String descriptionColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_DESCRIPTION");
    private static String identifierColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_IDENTIFIER");
    private static String poolSizeColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_SIZE");
    private static String reservedSizeColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_RESERVED_SIZE");
    private SystemStatus systemStatus_ = null;
    private VNode parent_ = null;
    private boolean allowModifyAllPools_ = false;
    private transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VSystemStatus() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        this.systemStatus_ = new SystemStatus();
        this.initializeTransient();
    }

    public VSystemStatus(AS400 system) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.systemStatus_ = new SystemStatus(system);
        this.initializeTransient();
    }

    public VSystemStatus(SystemStatus systemStatus) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        this.systemStatus_ = systemStatus;
        this.initializeTransient();
    }

    public VSystemStatus(VNode parent, AS400 system) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = parent;
        this.systemStatus_ = new SystemStatus(system);
        this.initializeTransient();
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    @Override
    public VAction[] getActions() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public VAction getDefaultAction() {
        return null;
    }

    @Override
    public VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(index);
        return this.detailsChildren_[index];
    }

    @Override
    public int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    @Override
    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    @Override
    public int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (this.detailsChildren_[i] != detailsChild) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    @Override
    public int getIndex(TreeNode child) {
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent_;
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    @Override
    public Object getPropertyValue(Object object) {
        return null;
    }

    public AS400 getSystem() {
        return this.systemStatus_.getSystem();
    }

    @Override
    public String getText() {
        return description_;
    }

    private synchronized void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.systemStatus_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.systemStatus_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
    }

    public boolean isAllowModifyAllPools() {
        return this.allowModifyAllPools_;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatus: loading");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception error = null;
        VSystemStatus vSystemStatus = this;
        synchronized (vSystemStatus) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            try {
                this.systemStatus_.refreshCache();
                this.enum_ = this.systemStatus_.getSystemPools();
                this.detailsChildren_ = new VSystemPool[this.systemStatus_.getPoolsNumber()];
            }
            catch (Exception e) {
                error = e;
                this.detailsChildren_ = new VSystemPool[0];
            }
        }
        if (error != null) {
            this.errorEventSupport_.fireError(error);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMore(int index) {
        if (index >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception error = null;
            VSystemStatus vSystemStatus = this;
            synchronized (vSystemStatus) {
                for (int i = this.loaded_; i <= index; ++i) {
                    SystemPool systemPool = (SystemPool)this.enum_.nextElement();
                    VSystemPool vSystemPool = new VSystemPool(systemPool);
                    vSystemPool.setAllowModify(this.allowModifyAllPools_);
                    this.detailsChildren_[i] = vSystemPool;
                    this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                    this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                    this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
                }
            }
            this.loaded_ = index + 1;
            if (error != null) {
                this.errorEventSupport_.fireError(error);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        this.systemStatus_.setSystem(system);
    }

    public void setAllowModifyAllPools(boolean allow) {
        this.allowModifyAllPools_ = allow;
    }

    @Override
    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = null;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int i = 0;
        VTableColumn vTable1 = new VTableColumn(i++, VSystemPool.IDENTIFIER_PROPERTY);
        vTable1.setCellRenderer(new VObjectCellRenderer());
        vTable1.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable1.setHeaderValue(identifierColumnHeader_);
        vTable1.setPreferredCharWidth(5);
        detailsColumnModel_.addColumn(vTable1);
        VTableColumn vTable2 = new VTableColumn(i++, VSystemPool.POOL_SIZE_PROPERTY);
        vTable2.setCellRenderer(new VObjectCellRenderer());
        vTable2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable2.setHeaderValue(poolSizeColumnHeader_);
        vTable2.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTable2);
        VTableColumn vTable3 = new VTableColumn(i++, VSystemPool.RESERVED_SIZE_PROPERTY);
        vTable3.setCellRenderer(new VObjectCellRenderer());
        vTable3.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable3.setHeaderValue(reservedSizeColumnHeader_);
        vTable3.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTable3);
        VTableColumn vTable4 = new VTableColumn(i++, NAME_PROPERTY);
        vTable4.setCellRenderer(new VObjectCellRenderer());
        vTable4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable4.setHeaderValue(nameColumnHeader_);
        vTable4.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTable4);
        VTableColumn vTable5 = new VTableColumn(i++, DESCRIPTION_PROPERTY);
        vTable5.setCellRenderer(new VObjectCellRenderer());
        vTable5.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable5.setHeaderValue(descriptionColumnHeader_);
        vTable5.setPreferredCharWidth(50);
        detailsColumnModel_.addColumn(vTable5);
    }
}

