/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.pipeline.transform;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.pipeline.transform.PipelineLogging;
import org.apache.hop.reflection.pipeline.transform.PipelineLoggingData;

@Transform(id="PipelineLogging", name="i18n::PipelineLogging.Transform.Name", description="i18n::PipelineLogging.Transform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", image="pipeline-log.svg", keywords={"i18n::PipelineLoggingMeta.keyword"}, documentationUrl="/pipeline/transforms/pipeline-logging.html")
public class PipelineLoggingMeta
extends BaseTransformMeta<PipelineLogging, PipelineLoggingData> {
    @HopMetadataProperty(key="log_transforms")
    private boolean loggingTransforms;

    public void setDefault() {
        this.loggingTransforms = true;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("loggingDate"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("loggingPhase"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineName", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineFilename", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("pipelineStart"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("pipelineEnd"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineLogChannelId", 36, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("parentLogChannelId", 36, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineLogging", 1000000, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("pipelineErrorCount", 3, 0));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineStatusDescription", 32, -1));
        if (this.loggingTransforms) {
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformName"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformCopyNr"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformStatusDescription", 100, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformLogChannelId", 36, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformLoggingText", 1000000, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesRead", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesWritten", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesInput", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesOutput", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesUpdated", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesRejected", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformErrors", 3, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("transformStart"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("transformEnd"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformDuration", 12, 0));
        }
    }

    public boolean isLoggingTransforms() {
        return this.loggingTransforms;
    }

    public void setLoggingTransforms(boolean loggingTransforms) {
        this.loggingTransforms = loggingTransforms;
    }
}

