/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvariable;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableMeta;
import org.apache.hop.pipeline.transforms.setvariable.VariableItem;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SetVariableDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SetVariableMeta.class;
    public static final String STRING_USAGE_WARNING_PARAMETER = "SetVariableUsageWarning";
    private Text wTransformName;
    private Button wFormat;
    private TableView wFields;
    private final SetVariableMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;

    public SetVariableDialog(Shell parent, IVariables variables, SetVariableMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SetVariableDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"SetVariableDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFormat = new Label((Composite)this.shell, 131072);
        wlFormat.setText(BaseMessages.getString(PKG, (String)"SetVariableDialog.Format.Label", (String[])new String[0]));
        wlFormat.setToolTipText(BaseMessages.getString(PKG, (String)"SetVariableDialog.Format.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFormat);
        FormData fdlFormat = new FormData();
        fdlFormat.left = new FormAttachment(0, 0);
        fdlFormat.right = new FormAttachment(middle, -margin);
        fdlFormat.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFormat.setLayoutData((Object)fdlFormat);
        this.wFormat = new Button((Composite)this.shell, 32);
        this.wFormat.setToolTipText(BaseMessages.getString(PKG, (String)"SetVariableDialog.Format.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFormat);
        FormData fdFormat = new FormData();
        fdFormat.left = new FormAttachment(middle, 0);
        fdFormat.top = new FormAttachment((Control)wlFormat, 0, 0x1000000);
        this.wFormat.setLayoutData((Object)fdFormat);
        this.wFormat.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wFormat, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getVariables().size();
        this.colinf = new ColumnInfo[4];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Column.FieldName", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Column.VariableName", (String[])new String[0]), 1, false);
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Column.VariableType", (String[])new String[0]), 2, VariableItem.getVariableTypeDescriptionsList(), false);
        this.colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Column.DefaultValue", (String[])new String[0]), 1, false);
        this.colinf[3].setUsingVariables(true);
        this.colinf[3].setToolTip(BaseMessages.getString(PKG, (String)"SetVariableDialog.Fields.Column.DefaultValue.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        for (int i = 0; i < this.input.getVariables().size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            VariableItem vi = this.input.getVariables().get(i);
            String src = vi.getFieldName();
            String tgt = vi.getVariableName();
            String typ = VariableItem.getVariableTypeDescription(vi.getVariableType());
            String tvv = vi.getDefaultValue();
            if (src != null) {
                item.setText(1, src);
            }
            if (tgt != null) {
                item.setText(2, tgt);
            }
            if (typ != null) {
                item.setText(3, typ);
            }
            if (tvv == null) continue;
            item.setText(4, tvv);
        }
        this.wFormat.setSelection(this.input.isUsingFormatting());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        int count = this.wFields.nrNonEmpty();
        this.input.getVariables().clear();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getVariables().add(new VariableItem(item.getText(1), item.getText(2), VariableItem.getVariableTypeFromDesc(item.getText(3)), item.getText(4)));
        }
        this.input.setUsingFormatting(this.wFormat.getSelection());
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"SetVariableDialog.UsageWarning.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SetVariableDialog.UsageWarning.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"SetVariableDialog.UsageWarning.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"SetVariableDialog.UsageWarning.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_USAGE_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (tableItem, v) -> {
                    tableItem.setText(2, v.getName().toUpperCase());
                    tableItem.setText(3, VariableItem.getVariableTypeDescription("ROOT_WORKFLOW"));
                    return true;
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SetVariableDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Set.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

