/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.Plan;
import org.apache.flink.util.Preconditions;

@Internal
public class ExecutionPlanUtil {
    private static final String PLAN_GENERATOR_CLASS_NAME = "org.apache.flink.optimizer.plandump.ExecutionPlanJSONGenerator";

    public static String getExecutionPlanAsJSON(Plan plan) {
        Preconditions.checkNotNull((Object)plan);
        ExecutionPlanJSONGenerator jsonGenerator = ExecutionPlanUtil.getJSONGenerator();
        return jsonGenerator.getExecutionPlan(plan);
    }

    private static ExecutionPlanJSONGenerator getJSONGenerator() {
        Class<? extends ExecutionPlanJSONGenerator> planGeneratorClass = ExecutionPlanUtil.loadJSONGeneratorClass(PLAN_GENERATOR_CLASS_NAME);
        try {
            return planGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the plan generator (org.apache.flink.optimizer.plandump.ExecutionPlanJSONGenerator).", t);
        }
    }

    private static Class<? extends ExecutionPlanJSONGenerator> loadJSONGeneratorClass(String className) {
        try {
            Class<?> generatorClass = Class.forName(className);
            return generatorClass.asSubclass(ExecutionPlanJSONGenerator.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load the plan generator class (" + className + "). Do you have the 'flink-optimizer' project in your dependencies?");
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the plan generator (" + className + ").", t);
        }
    }

    @Internal
    public static interface ExecutionPlanJSONGenerator {
        public String getExecutionPlan(Plan var1);
    }
}

