/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth.core.impl;

import org.apache.hop.core.auth.core.AuthenticationConsumptionException;
import org.apache.hop.core.auth.core.IAuthenticationConsumer;
import org.apache.hop.core.auth.core.IAuthenticationConsumerFactory;
import org.apache.hop.core.auth.core.IAuthenticationPerformer;
import org.apache.hop.core.auth.core.IAuthenticationProvider;

public class DefaultAuthenticationPerformer<ReturnType, CreateArgType, T extends IAuthenticationProvider>
implements IAuthenticationPerformer<ReturnType, CreateArgType> {
    private final T provider;
    private final IAuthenticationConsumerFactory<ReturnType, CreateArgType, T> authenticationConsumerFactory;

    public DefaultAuthenticationPerformer(T provider, IAuthenticationConsumerFactory<ReturnType, CreateArgType, T> authenticationConsumerFactory) {
        this.provider = provider;
        this.authenticationConsumerFactory = authenticationConsumerFactory;
    }

    @Override
    public ReturnType perform(CreateArgType consumerCreateArg) throws AuthenticationConsumptionException {
        IAuthenticationConsumer<ReturnType, T> consumer = this.authenticationConsumerFactory.create(consumerCreateArg);
        return consumer.consume(this.provider);
    }

    @Override
    public String getDisplayName() {
        return this.provider.getDisplayName();
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.provider;
    }
}

