/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.VariableRegistry;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineComponentRowsReceived;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.pipeline.engine.PipelineEnginePlugin;
import org.apache.hop.pipeline.engines.remote.RemotePipelineEngineCapabilities;
import org.apache.hop.pipeline.engines.remote.RemotePipelineRunConfiguration;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.resource.ResourceUtil;
import org.apache.hop.resource.TopLevelResource;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.WebResult;
import org.w3c.dom.Node;

@PipelineEnginePlugin(id="Remote", name="Hop remote pipeline engine", description="Executes your pipeline on a remote Hop server")
public class RemotePipelineEngine
extends Variables
implements IPipelineEngine<PipelineMeta> {
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__pipeline_execution_configuration__.xml";
    private final PipelineEngineCapabilities engineCapabilities;
    protected PipelineMeta subject;
    protected String pluginId;
    protected PipelineRunConfiguration pipelineRunConfiguration;
    protected RemotePipelineRunConfiguration remotePipelineRunConfiguration;
    protected boolean preparing;
    protected boolean readyToStart;
    protected boolean running;
    protected boolean finished;
    protected boolean stopped;
    protected boolean paused;
    protected boolean hasHaltedComponents;
    protected boolean preview;
    protected int errors;
    protected IHopMetadataProvider metadataProvider;
    protected ILogChannel logChannel;
    protected ILoggingObject loggingObject;
    protected EngineMetrics engineMetrics;
    protected Result previousResult;
    protected HopServerMeta hopServer;
    protected ILoggingObject parent;
    protected IPipelineEngine<PipelineMeta> parentPipeline;
    protected IWorkflowEngine<WorkflowMeta> parentWorkflow;
    protected LogLevel logLevel;
    protected boolean feedbackShown;
    protected int feedbackSize;
    protected String containerId;
    protected List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> executionStartedListeners;
    protected List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> executionFinishedListeners;
    protected List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners;
    protected Map<String, IPipelineEngine> activeSubPipelines;
    protected Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows;
    protected Map<String, Object> extensionDataMap;
    protected int lastLogLineNr;
    protected Timer refreshTimer;
    protected INamedParameters namedParams = new NamedParameters();
    private String statusDescription;
    private EngineComponent.ComponentExecutionStatus status;
    protected long serverPollDelay;
    protected long serverPollInterval;

    public RemotePipelineEngine() {
        this.logChannel = LogChannel.GENERAL;
        this.engineMetrics = new EngineMetrics();
        this.executionStartedListeners = Collections.synchronizedList(new ArrayList());
        this.executionFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.executionStoppedListeners = Collections.synchronizedList(new ArrayList());
        this.activeSubPipelines = new HashMap<String, IPipelineEngine>();
        this.activeSubWorkflows = new HashMap<String, IWorkflowEngine<WorkflowMeta>>();
        this.engineCapabilities = new RemotePipelineEngineCapabilities();
        this.extensionDataMap = Collections.synchronizedMap(new HashMap());
    }

    public RemotePipelineEngine(PipelineMeta subject) {
        this();
        this.subject = subject;
    }

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        return new RemotePipelineRunConfiguration();
    }

    @Override
    public void prepareExecution() throws HopException {
        try {
            IPipelineEngineRunConfiguration engineRunConfiguration = this.pipelineRunConfiguration.getEngineRunConfiguration();
            if (!(engineRunConfiguration instanceof RemotePipelineRunConfiguration)) {
                throw new HopException("The remote pipeline engine expects a remote pipeline configuration");
            }
            this.remotePipelineRunConfiguration = (RemotePipelineRunConfiguration)this.pipelineRunConfiguration.getEngineRunConfiguration();
            String hopServerName = this.resolve(this.remotePipelineRunConfiguration.getHopServerName());
            if (StringUtils.isEmpty((String)hopServerName)) {
                throw new HopException("No remote Hop server was specified to run the pipeline on");
            }
            String remoteRunConfigurationName = this.remotePipelineRunConfiguration.getRunConfigurationName();
            if (StringUtils.isEmpty((String)remoteRunConfigurationName)) {
                throw new HopException("No run configuration was specified to the remote pipeline with");
            }
            if (this.pipelineRunConfiguration.getName().equals(remoteRunConfigurationName)) {
                throw new HopException("The remote pipeline run configuration refers to itself '" + remoteRunConfigurationName + "'");
            }
            if (this.metadataProvider == null) {
                throw new HopException("The remote pipeline engine didn't receive a metadata to load hop server '" + hopServerName + "'");
            }
            this.logChannel = new LogChannel((Object)this, this.getParent());
            this.loggingObject = new LoggingObject((Object)this);
            this.logChannel.setLogLevel(this.logLevel);
            this.logChannel.logBasic("Executing this pipeline using the Remote Pipeline Engine with run configuration '" + this.pipelineRunConfiguration.getName() + "'");
            this.serverPollDelay = Const.toLong((String)this.resolve(this.remotePipelineRunConfiguration.getServerPollDelay()), (long)1000L);
            this.serverPollInterval = Const.toLong((String)this.resolve(this.remotePipelineRunConfiguration.getServerPollInterval()), (long)2000L);
            this.hopServer = (HopServerMeta)this.metadataProvider.getSerializer(HopServerMeta.class).load(hopServerName);
            if (this.hopServer == null) {
                throw new HopException("Hop server '" + hopServerName + "' could not be found");
            }
            PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
            pipelineExecutionConfiguration.setRunConfiguration(remoteRunConfigurationName);
            if (this.logLevel != null) {
                pipelineExecutionConfiguration.setLogLevel(this.logLevel);
            }
            if (this.previousResult != null) {
                pipelineExecutionConfiguration.setPreviousResult(this.previousResult);
            }
            this.sendToHopServer(this.subject, pipelineExecutionConfiguration, this.metadataProvider);
            this.setReadyToStart(true);
        }
        catch (Exception e) {
            throw new HopException("Error preparing remote pipeline", (Throwable)e);
        }
    }

    private void sendToHopServer(PipelineMeta pipelineMeta, PipelineExecutionConfiguration executionConfiguration, IHopMetadataProvider metadataProvider) throws HopException {
        if (this.hopServer == null) {
            throw new HopException("No remote server specified");
        }
        if (Utils.isEmpty((CharSequence)pipelineMeta.getName())) {
            throw new HopException("The pipeline needs a name to uniquely identify it by on the remote server.");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String var : this.getVariableNames()) {
            if (!RemotePipelineEngine.isVariablePassedToRemoteServer(var)) continue;
            vars.put(var, this.getVariable(var));
        }
        executionConfiguration.getVariablesMap().putAll(vars);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : this.listParameters()) {
            params.put(param, this.getVariable(param));
        }
        executionConfiguration.getParametersMap().putAll(params);
        this.hopServer.getLogChannel().setLogLevel(executionConfiguration.getLogLevel());
        try {
            if (this.remotePipelineRunConfiguration.isExportingResources()) {
                FileObject tempFile = HopVfs.createTempFile((String)"pipelineExport", (HopVfs.Suffix)HopVfs.Suffix.ZIP);
                PipelineExecutionConfiguration clonedConfiguration = (PipelineExecutionConfiguration)executionConfiguration.clone();
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), pipelineMeta, this, metadataProvider, clonedConfiguration, CONFIGURATION_IN_EXPORT_FILENAME, this.remotePipelineRunConfiguration.getNamedResourcesSourceFolder(), this.remotePipelineRunConfiguration.getNamedResourcesTargetFolder(), executionConfiguration.getVariablesMap());
                String result = this.hopServer.sendExport(this, topLevelResource.getArchiveName(), "pipeline", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXmlString(result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    String message = this.cleanupMessage(webResult.getMessage());
                    throw new HopException("There was an error passing the exported pipeline to the remote server: " + Const.CR + message);
                }
                this.containerId = webResult.getId();
            } else {
                SerializableMetadataProvider serializableMetadataProvider = new SerializableMetadataProvider(metadataProvider);
                String xml = new PipelineConfiguration(pipelineMeta, executionConfiguration, serializableMetadataProvider).getXml(this);
                String reply = this.hopServer.sendXml(this, xml, "/hop/registerPipeline/?xml=Y");
                WebResult webResult = WebResult.fromXmlString(reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    String message = this.cleanupMessage(webResult.getMessage());
                    throw new HopException("There was an error posting the pipeline on the remote server: " + Const.CR + message);
                }
                this.containerId = webResult.getId();
            }
            String reply = this.hopServer.execService(this, "/hop/prepareExec/?name=" + URLEncoder.encode(pipelineMeta.getName(), StandardCharsets.UTF_8) + "&xml=Y&id=" + this.containerId);
            WebResult webResult = WebResult.fromXmlString(reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                String message = this.cleanupMessage(webResult.getMessage());
                throw new HopException("There was an error preparing the pipeline for execution on the remote server: " + Const.CR + message);
            }
            this.getPipelineStatus();
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public static boolean isVariablePassedToRemoteServer(String variableName) {
        if (StringUtils.isEmpty((String)variableName)) {
            return false;
        }
        if (variableName.startsWith("java.") || variableName.startsWith("file.") || variableName.startsWith("awt.") || variableName.startsWith("line.") || variableName.startsWith("org.eclipse.") || variableName.startsWith("sun.") || variableName.startsWith("user.") || variableName.startsWith("os.") || variableName.startsWith("path.separator") || variableName.startsWith("javax.")) {
            return false;
        }
        if (Const.INTERNAL_WORKFLOW_VARIABLES.contains(variableName)) {
            return false;
        }
        if (Const.INTERNAL_PIPELINE_VARIABLES.contains(variableName)) {
            return false;
        }
        if (VariableRegistry.getInstance().getVariableNames(new VariableScope[]{VariableScope.SYSTEM, VariableScope.APPLICATION}).contains(variableName)) {
            return false;
        }
        return !variableName.equals("LOG_PATH");
    }

    private String cleanupMessage(String message) {
        return message.replace("\t", Const.CR);
    }

    @Override
    public void startThreads() throws HopException {
        try {
            String reply = this.hopServer.execService(this, "/hop/startExec/?name=" + URLEncoder.encode(this.subject.getName(), StandardCharsets.UTF_8) + "&xml=Y&id=" + this.containerId);
            WebResult webResult = WebResult.fromXmlString(reply);
            if (!"OK".equals(webResult.getResult())) {
                String message = this.cleanupMessage(webResult.getMessage());
                throw new HopException("Error starting pipeline on hop server '" + this.hopServer.getName() + "' with object ID '" + this.containerId + "' : " + message);
            }
            this.fireExecutionStartedListeners();
            TimerTask refreshTask = new TimerTask(){

                @Override
                public void run() {
                    RemotePipelineEngine.this.getPipelineStatus();
                }
            };
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(refreshTask, this.serverPollDelay, this.serverPollInterval);
            this.readyToStart = false;
            this.running = true;
        }
        catch (Exception e) {
            throw new HopException("Unable to start pipeline on server '" + this.hopServer.getName() + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getPipelineStatus() throws RuntimeException {
        try {
            HopServerPipelineStatus pipelineStatus = this.hopServer.getPipelineStatus(this, this.subject.getName(), this.containerId, this.lastLogLineNr);
            EngineMetrics engineMetrics = this.engineMetrics;
            synchronized (engineMetrics) {
                this.hasHaltedComponents = false;
                this.engineMetrics.setStartDate(pipelineStatus.getExecutionStartDate());
                this.engineMetrics.setEndDate(pipelineStatus.getExecutionEndDate());
                this.engineMetrics.getComponents().clear();
                this.engineMetrics.getComponentRunningMap().clear();
                this.engineMetrics.getComponentSpeedMap().clear();
                this.engineMetrics.getComponentMetricsMap().clear();
                for (TransformStatus transformStatus : pipelineStatus.getTransformStatusList()) {
                    boolean halted;
                    EngineComponent component = new EngineComponent(transformStatus.getTransformName(), transformStatus.getCopy());
                    component.setErrors(transformStatus.getErrors());
                    this.status = EngineComponent.ComponentExecutionStatus.getStatusFromDescription(transformStatus.getStatusDescription());
                    this.statusDescription = this.status.getDescription();
                    boolean running = this.status == EngineComponent.ComponentExecutionStatus.STATUS_RUNNING;
                    component.setRunning(running);
                    boolean bl = halted = this.status == EngineComponent.ComponentExecutionStatus.STATUS_HALTED || this.status == EngineComponent.ComponentExecutionStatus.STATUS_HALTING;
                    if (halted) {
                        this.hasHaltedComponents = true;
                    }
                    this.engineMetrics.setComponentStatus(component, transformStatus.getStatusDescription());
                    this.engineMetrics.setComponentRunning(component, running);
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_READ, transformStatus.getLinesRead());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_WRITTEN, transformStatus.getLinesWritten());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_INPUT, transformStatus.getLinesInput());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_OUTPUT, transformStatus.getLinesOutput());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_REJECTED, transformStatus.getLinesRejected());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_UPDATED, transformStatus.getLinesUpdated());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_ERROR, transformStatus.getErrors());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_BUFFER_IN, transformStatus.getInputBufferSize());
                    this.engineMetrics.setComponentMetric(component, Pipeline.METRIC_BUFFER_OUT, transformStatus.getOutputBufferSize());
                    this.engineMetrics.setComponentSpeed(component, transformStatus.getSpeed());
                    this.engineMetrics.getComponents().add(component);
                }
                this.running = pipelineStatus.isRunning();
                this.finished = pipelineStatus.isFinished();
                this.stopped = pipelineStatus.isStopped();
                this.paused = pipelineStatus.isPaused();
                this.errors = (int)pipelineStatus.getNrTransformErrors();
                this.lastLogLineNr = pipelineStatus.getLastLoggingLineNr();
                if (StringUtils.isNotEmpty((String)pipelineStatus.getLoggingString())) {
                    this.logChannel.logBasic(pipelineStatus.getLoggingString());
                }
                if (this.finished) {
                    this.firePipelineExecutionFinishedListeners();
                    this.refreshTimer.cancel();
                    this.logChannel.logBasic("Execution finished on a remote pipeline engine with run configuration '" + this.pipelineRunConfiguration.getName() + "'");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting the status of pipeline '" + this.subject.getName() + "' on hop server '" + this.hopServer.getName() + "' with object ID '" + this.containerId + "'", e);
        }
    }

    @Override
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Override
    public void execute() throws HopException {
        this.prepareExecution();
        this.startThreads();
    }

    @Override
    public EngineMetrics getEngineMetrics(String componentName, int copyNr) {
        EngineMetrics em = new EngineMetrics();
        em.setStartDate(this.engineMetrics.getStartDate());
        em.setEndDate(this.engineMetrics.getEndDate());
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            String speed;
            String status;
            if (!component.getName().equalsIgnoreCase(componentName) || component.getCopyNr() != copyNr) continue;
            Boolean running = this.engineMetrics.getComponentRunningMap().get(component);
            if (running != null) {
                em.setComponentRunning(component, running);
            }
            if ((status = this.engineMetrics.getComponentStatusMap().get(component)) != null) {
                em.setComponentStatus(component, status);
            }
            if ((speed = this.engineMetrics.getComponentSpeedMap().get(component)) == null) continue;
            em.setComponentSpeed(component, speed);
        }
        return em;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void waitUntilFinished() {
        while ((this.running || this.paused || this.readyToStart) && !this.stopped && !this.finished) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void stopAll() {
        try {
            this.hopServer.stopPipeline(this, this.subject.getName(), this.containerId);
            this.getPipelineStatus();
        }
        catch (Exception e) {
            throw new RuntimeException("Stopping of pipeline '" + this.subject.getName() + "' with ID " + this.containerId + " failed", e);
        }
    }

    @Override
    public boolean hasHaltedComponents() {
        return this.hasHaltedComponents;
    }

    @Override
    public void pauseExecution() {
        try {
            this.hopServer.pauseResumePipeline(this, this.subject.getName(), this.containerId);
            this.getPipelineStatus();
        }
        catch (Exception e) {
            throw new RuntimeException("Pause/Resume of pipeline '" + this.subject.getName() + "' with ID " + this.containerId + " failed", e);
        }
    }

    @Override
    public void resumeExecution() {
        this.pauseExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStartedListener(IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStartedListener(IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionFinishedListener(IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionFinishedListener(IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.remove(listener);
        }
    }

    @Override
    public void pipelineCompleted() throws HopException {
    }

    @Override
    public String getComponentLogText(String componentName, int copyNr) {
        return "";
    }

    @Override
    public List<IEngineComponent> getComponents() {
        return this.engineMetrics.getComponents();
    }

    @Override
    public List<IEngineComponent> getComponentCopies(String name) {
        ArrayList<IEngineComponent> copies = new ArrayList<IEngineComponent>();
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            if (!component.getName().equalsIgnoreCase(name)) continue;
            copies.add(component);
        }
        return copies;
    }

    @Override
    public IEngineComponent findComponent(String name, int copyNr) {
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            if (!component.getName().equalsIgnoreCase(name) || component.getCopyNr() != copyNr) continue;
            return component;
        }
        return null;
    }

    @Override
    public Result getResult() {
        Result result = new Result();
        result.setNrErrors((long)this.errors);
        result.setResult(this.errors == 0);
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            result.setNrErrors(result.getNrErrors() + component.getErrors());
            Long read = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_READ);
            result.setNrLinesRead(Math.max(result.getNrLinesRead(), read == null ? 0L : read));
            Long written = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_WRITTEN);
            result.setNrLinesWritten(Math.max(result.getNrLinesWritten(), written == null ? 0L : written));
            Long input = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_INPUT);
            result.setNrLinesInput(Math.max(result.getNrLinesInput(), input == null ? 0L : input));
            Long output = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_OUTPUT);
            result.setNrLinesOutput(Math.max(result.getNrLinesOutput(), output == null ? 0L : output));
            Long updated = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_UPDATED);
            result.setNrLinesUpdated(Math.max(result.getNrLinesUpdated(), updated == null ? 0L : updated));
            Long rejected = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_REJECTED);
            result.setNrLinesRejected(Math.max(result.getNrLinesRejected(), rejected == null ? 0L : rejected));
        }
        result.setStopped(this.isStopped());
        result.setLogChannelId(this.getLogChannelId());
        return result;
    }

    @Override
    public void retrieveComponentOutput(IVariables variables, String componentName, int copyNr, int nrRows, IPipelineComponentRowsReceived rowsReceived) throws HopException {
        try {
            Runnable runnable = () -> {
                try {
                    String rowBufferXml = this.hopServer.sniffTransform(this, this.subject.getName(), componentName, this.containerId, "" + copyNr, nrRows, "output");
                    Node rowBufferNode = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)rowBufferXml), (String)"row-buffer");
                    if (rowBufferNode != null) {
                        RowBuffer rowBuffer = new RowBuffer(rowBufferNode);
                        rowsReceived.rowsReceived(this, rowBuffer);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to get output rows from transform '" + componentName + "' in pipeline '" + this.subject.getName() + "' on server '" + this.hopServer.getName(), e);
                }
            };
            new Thread(runnable).start();
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    @Override
    public Date getExecutionStartDate() {
        return this.engineMetrics.getStartDate();
    }

    @Override
    public Date getExecutionEndDate() {
        return this.engineMetrics.getEndDate();
    }

    @Override
    public boolean isSafeModeEnabled() {
        return false;
    }

    @Override
    public IRowSet findRowSet(String fromTransformName, int fromTransformCopy, String toTransformName, int toTransformCopy) {
        return null;
    }

    public String getObjectName() {
        return this.subject.getName();
    }

    public String getFilename() {
        return this.subject.getFilename();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.PIPELINE;
    }

    public String getObjectCopy() {
        return null;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public boolean isGatheringMetrics() {
        return this.logChannel != null && this.logChannel.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.logChannel != null) {
            this.logChannel.setGatheringMetrics(gatheringMetrics);
        }
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.logChannel != null) {
            this.logChannel.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.logChannel == null ? false : this.logChannel.isForcingSeparateLogging();
    }

    @Override
    public String getLogChannelId() {
        return this.logChannel.getLogChannelId();
    }

    @Override
    public void addActiveSubPipeline(String subPipelineName, IPipelineEngine subPipeline) {
        this.activeSubPipelines.put(subPipelineName, subPipeline);
    }

    @Override
    public IPipelineEngine getActiveSubPipeline(String subPipelineName) {
        return this.activeSubPipelines.get(subPipelineName);
    }

    @Override
    public void addActiveSubWorkflow(String subWorkflowName, IWorkflowEngine<WorkflowMeta> subWorkflow) {
        this.activeSubWorkflows.put(subWorkflowName, subWorkflow);
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getActiveSubWorkflow(String subWorkflowName) {
        return this.activeSubWorkflows.get(subWorkflowName);
    }

    @Override
    public void setInternalHopVariables(IVariables var) {
    }

    @Override
    public IPipelineEngine getParentPipeline() {
        return this.parentPipeline;
    }

    @Override
    public void setParentPipeline(IPipelineEngine parentPipeline) {
        this.parentPipeline = parentPipeline;
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    @Override
    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> getExecutionStartedListeners() {
        return this.executionStartedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionStartedListeners(List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> listener) {
        this.executionStartedListeners = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStartedListeners) {
                listener.started(this);
            }
        }
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> getExecutionFinishedListeners() {
        return this.executionFinishedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionFinishedListeners(List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> listener) {
        this.executionFinishedListeners = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStartedListeners) {
                listener.started(this);
            }
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionFinishedListeners() throws HopException {
        this.fireExecutionFinishedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionFinishedListeners() throws HopException {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            for (IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener : this.executionFinishedListeners) {
                listener.finished(this);
            }
        }
        this.pipelineCompleted();
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.logChannel, (IVariables)this, (String)HopExtensionPoint.PipelineCompleted.id, (Object)this);
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionStoppedListeners() throws HopException {
        this.fireExecutionStoppedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStoppedListeners() throws HopException {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            for (IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStoppedListeners) {
                listener.stopped(this);
            }
        }
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> getExecutionStoppedListeners() {
        return this.executionStoppedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionStoppedListeners(List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners) {
        this.executionStoppedListeners = executionStoppedListeners;
    }

    @Override
    public <Store extends IExecutionDataSamplerStore, Sampler extends IExecutionDataSampler<Store>> void addExecutionDataSampler(Sampler sampler) throws HopException {
        try {
            ObjectMapper mapper = HopJson.newMapper();
            String json = mapper.writeValueAsString(sampler);
            throw new HopException("Adding execution data sampler to remote pipeline is not yet implemented");
        }
        catch (Exception e) {
            throw new HopException("Error adding execution data sampler to remote pipeline", (Throwable)e);
        }
    }

    @Override
    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    @Override
    public PipelineRunConfiguration getPipelineRunConfiguration() {
        return this.pipelineRunConfiguration;
    }

    @Override
    public void setPipelineRunConfiguration(PipelineRunConfiguration pipelineRunConfiguration) {
        this.pipelineRunConfiguration = pipelineRunConfiguration;
    }

    @Override
    public PipelineMeta getPipelineMeta() {
        return this.subject;
    }

    @Override
    public void setPipelineMeta(PipelineMeta subject) {
        this.subject = subject;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public boolean isPreparing() {
        return this.preparing;
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    @Override
    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    public void setReadyToStart(boolean readyToStart) {
        this.readyToStart = readyToStart;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.logChannel;
    }

    @Override
    public void setLogChannel(ILogChannel log) {
        this.logChannel = log;
    }

    public HopServerMeta getHopServer() {
        return this.hopServer;
    }

    public void setHopServer(HopServerMeta hopServer) {
        this.hopServer = hopServer;
    }

    @Override
    public EngineMetrics getEngineMetrics() {
        return this.engineMetrics;
    }

    public void setEngineMetrics(EngineMetrics engineMetrics) {
        this.engineMetrics = engineMetrics;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public ILoggingObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ILoggingObject parent) {
        this.parent = parent;
        this.logChannel = new LogChannel((Object)this, parent);
        this.logLevel = this.logChannel.getLogLevel();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isHasHaltedComponents() {
        return this.hasHaltedComponents;
    }

    public void setHasHaltedComponents(boolean hasHaltedComponents) {
        this.hasHaltedComponents = hasHaltedComponents;
    }

    @Override
    public boolean isFeedbackShown() {
        return this.feedbackShown;
    }

    public void setFeedbackShown(boolean feedbackShown) {
        this.feedbackShown = feedbackShown;
    }

    @Override
    public int getFeedbackSize() {
        return this.feedbackSize;
    }

    public void setFeedbackSize(int feedbackSize) {
        this.feedbackSize = feedbackSize;
    }

    public int getLastLogLineNr() {
        return this.lastLogLineNr;
    }

    public void setLastLogLineNr(int lastLogLineNr) {
        this.lastLogLineNr = lastLogLineNr;
    }

    public ILoggingObject getLoggingObject() {
        return this.loggingObject;
    }

    public void setLoggingObject(ILoggingObject loggingObject) {
        this.loggingObject = loggingObject;
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    public Map<String, IPipelineEngine> getActiveSubPipelines() {
        return this.activeSubPipelines;
    }

    public void setActiveSubPipelines(Map<String, IPipelineEngine> activeSubPipelines) {
        this.activeSubPipelines = activeSubPipelines;
    }

    public Map<String, IWorkflowEngine<WorkflowMeta>> getActiveSubWorkflows() {
        return this.activeSubWorkflows;
    }

    public void setActiveSubWorkflows(Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows) {
        this.activeSubWorkflows = activeSubWorkflows;
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public void clearParameterValues() {
        this.namedParams.clearParameterValues();
    }

    public void activateParameters(IVariables variables) {
        this.namedParams.activateParameters(variables);
    }

    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        this.namedParams.copyParametersFromDefinitions(definitions);
    }

    @Override
    public PipelineEngineCapabilities getEngineCapabilities() {
        return this.engineCapabilities;
    }

    public INamedParameters getNamedParams() {
        return this.namedParams;
    }

    public void setNamedParams(INamedParameters namedParams) {
        this.namedParams = namedParams;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public EngineComponent.ComponentExecutionStatus getStatus() {
        return this.status;
    }

    @Override
    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public void setStatus(EngineComponent.ComponentExecutionStatus status) {
        this.status = status;
    }

    public long getServerPollDelay() {
        return this.serverPollDelay;
    }

    public void setServerPollDelay(long serverPollDelay) {
        this.serverPollDelay = serverPollDelay;
    }

    public long getServerPollInterval() {
        return this.serverPollInterval;
    }

    public void setServerPollInterval(long serverPollInterval) {
        this.serverPollInterval = serverPollInterval;
    }

    public void setExtensionDataMap(Map<String, Object> extensionDataMap) {
        this.extensionDataMap = extensionDataMap;
    }
}

