/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StreamResponse
extends SimpleResponse<Flux<ByteBuffer>>
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(StreamResponse.class);
    private volatile boolean consumed;
    private final HttpResponse response;

    @Deprecated
    public StreamResponse(HttpRequest request, int statusCode, HttpHeaders headers, Flux<ByteBuffer> value) {
        super(request, statusCode, headers, value);
        this.response = null;
    }

    public StreamResponse(HttpResponse response) {
        super(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        this.response = response;
    }

    @Override
    public Flux<ByteBuffer> getValue() {
        if (this.response == null) {
            return ((Flux)super.getValue()).doFinally(t -> {
                this.consumed = true;
            });
        }
        return this.response.getBody().doFinally(t -> {
            this.consumed = true;
            this.response.close();
        });
    }

    public Mono<Void> writeValueToAsync(AsynchronousByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.response == null) {
            return FluxUtil.writeToAsynchronousByteChannel(this.getValue(), channel);
        }
        return this.response.writeBodyToAsync(channel);
    }

    public void writeValueTo(WritableByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.response == null) {
            FluxUtil.writeToWritableByteChannel(this.getValue(), channel).block();
        } else {
            try {
                this.response.writeBodyTo(channel);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
            }
        }
    }

    @Override
    public void close() {
        if (this.consumed) {
            return;
        }
        this.consumed = true;
        if (this.response == null) {
            Flux<ByteBuffer> value = this.getValue();
            value.subscribe().dispose();
        } else {
            this.response.close();
        }
    }
}

