/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MapTypeInfo<K, V>
extends TypeInformation<Map<K, V>> {
    private final TypeInformation<K> keyTypeInfo;
    private final TypeInformation<V> valueTypeInfo;

    public MapTypeInfo(TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) {
        this.keyTypeInfo = Preconditions.checkNotNull(keyTypeInfo, "The key type information cannot be null.");
        this.valueTypeInfo = Preconditions.checkNotNull(valueTypeInfo, "The value type information cannot be null.");
    }

    public MapTypeInfo(Class<K> keyClass, Class<V> valueClass) {
        this.keyTypeInfo = MapTypeInfo.of(Preconditions.checkNotNull(keyClass, "The key class cannot be null."));
        this.valueTypeInfo = MapTypeInfo.of(Preconditions.checkNotNull(valueClass, "The value class cannot be null."));
    }

    public TypeInformation<K> getKeyTypeInfo() {
        return this.keyTypeInfo;
    }

    public TypeInformation<V> getValueTypeInfo() {
        return this.valueTypeInfo;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<Map<K, V>> getTypeClass() {
        return Map.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<Map<K, V>> createSerializer(SerializerConfig config) {
        TypeSerializer<K> keyTypeSerializer = this.keyTypeInfo.createSerializer(config);
        TypeSerializer<V> valueTypeSerializer = this.valueTypeInfo.createSerializer(config);
        return new MapSerializer<K, V>(keyTypeSerializer, valueTypeSerializer);
    }

    @Override
    public TypeSerializer<Map<K, V>> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    @Override
    public String toString() {
        return "Map<" + this.keyTypeInfo + ", " + this.valueTypeInfo + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MapTypeInfo) {
            MapTypeInfo other = (MapTypeInfo)obj;
            return other.canEqual(this) && this.keyTypeInfo.equals(other.keyTypeInfo) && this.valueTypeInfo.equals(other.valueTypeInfo);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.keyTypeInfo.hashCode() + this.valueTypeInfo.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

