/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.googledrive.config.GoogleDriveConfig;

public class GoogleDriveConfigSingleton {
    private static GoogleDriveConfigSingleton configSingleton;
    private GoogleDriveConfig googleDriveConfig;

    private GoogleDriveConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("googleDrive");
        if (configObject == null) {
            this.googleDriveConfig = new GoogleDriveConfig();
        } else {
            try {
                ObjectMapper mapper = HopJson.newMapper();
                this.googleDriveConfig = (GoogleDriveConfig)mapper.readValue(new Gson().toJson(configObject), GoogleDriveConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading Google Drive configuration, check property 'googleDrive' in the Hop config json file", (Throwable)e);
                this.googleDriveConfig = new GoogleDriveConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("googleDrive", this.googleDriveConfig);
    }

    public static GoogleDriveConfigSingleton getInstance() {
        return configSingleton;
    }

    public static GoogleDriveConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new GoogleDriveConfigSingleton();
        }
        return GoogleDriveConfigSingleton.configSingleton.googleDriveConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("googleDrive", (Object)GoogleDriveConfigSingleton.configSingleton.googleDriveConfig);
        HopConfig.getInstance().saveToFile();
    }
}

