/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class PathsSetAccessControlRecursiveHeaders {
    private String xMsVersion;
    private String xMsContinuation;
    private String xMsRequestId;
    private DateTimeRfc1123 date;
    private String xMsClientRequestId;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_CONTINUATION = HttpHeaderName.fromString((String)"x-ms-continuation");

    public PathsSetAccessControlRecursiveHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsContinuation = rawHeaders.getValue(X_MS_CONTINUATION);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsSetAccessControlRecursiveHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsContinuation() {
        return this.xMsContinuation;
    }

    public PathsSetAccessControlRecursiveHeaders setXMsContinuation(String xMsContinuation) {
        this.xMsContinuation = xMsContinuation;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsSetAccessControlRecursiveHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsSetAccessControlRecursiveHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public PathsSetAccessControlRecursiveHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }
}

