/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinMeta;
import org.apache.hop.pipeline.transforms.databasejoin.ParameterField;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.SQLStyledTextComp;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextComposite;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatabaseJoinDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = DatabaseJoinMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextComposite wSql;
    private Text wLimit;
    private Button wOuter;
    private TableView wParam;
    private Button wUseVars;
    private final DatabaseJoinMeta input;
    private Label wlPosition;
    private ColumnInfo[] ciKey;
    private final List<String> inputFields = new ArrayList<String>();
    private Button wCache;
    private Label wlCacheSize;
    private Text wCacheSize;

    public DatabaseJoinDialog(Shell parent, IVariables variables, DatabaseJoinMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addListener(13, e -> this.getSqlReservedWords());
        Label wlCache = new Label((Composite)this.shell, 131072);
        wlCache.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Cache.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCache);
        FormData fdlCache = new FormData();
        fdlCache.left = new FormAttachment(0, 0);
        fdlCache.right = new FormAttachment(middle, -margin);
        fdlCache.top = new FormAttachment(this.wConnection, margin);
        wlCache.setLayoutData((Object)fdlCache);
        this.wCache = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wCache);
        FormData fdCache = new FormData();
        fdCache.left = new FormAttachment(middle, 0);
        fdCache.top = new FormAttachment((Control)wlCache, 0, 0x1000000);
        this.wCache.setLayoutData((Object)fdCache);
        this.wCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
                DatabaseJoinDialog.this.enableFields();
            }
        });
        this.wlCacheSize = new Label((Composite)this.shell, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.CacheSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCacheSize);
        this.wlCacheSize.setEnabled(this.input.isCached());
        FormData fdlCacheSize = new FormData();
        fdlCacheSize.left = new FormAttachment(0, 0);
        fdlCacheSize.right = new FormAttachment(middle, -margin);
        fdlCacheSize.top = new FormAttachment((Control)this.wCache, margin);
        this.wlCacheSize.setLayoutData((Object)fdlCacheSize);
        this.wCacheSize = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCacheSize);
        this.wCacheSize.setEnabled(this.input.isCached());
        this.wCacheSize.addModifyListener(lsMod);
        FormData fdCacheSize = new FormData();
        fdCacheSize.left = new FormAttachment(middle, 0);
        fdCacheSize.right = new FormAttachment(100, 0);
        fdCacheSize.top = new FormAttachment((Control)this.wCache, margin);
        this.wCacheSize.setLayoutData((Object)fdCacheSize);
        Label wlSql = new Label((Composite)this.shell, 0);
        wlSql.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.SQL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment((Control)this.wCacheSize, margin * 2);
        wlSql.setLayoutData((Object)fdlSql);
        this.wSql = EnvironmentUtils.getInstance().isWeb() ? new StyledTextComp(this.variables, (Composite)this.shell, 19202) : new SQLStyledTextComp(this.variables, (Composite)this.shell, 19202);
        this.wSql.addLineStyleListener(this.getSqlReservedWords());
        PropsUi.setLook((Widget)this.wSql, (int)1);
        this.wSql.addModifyListener(lsMod);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)wlSql, margin);
        fdSql.right = new FormAttachment(100, -2 * margin);
        fdSql.bottom = new FormAttachment(60, 0);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addModifyListener(arg0 -> this.setPosition());
        this.wSql.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.top = new FormAttachment((Control)this.wSql, margin);
        fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Label wlLimit = new Label((Composite)this.shell, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment((Control)this.wlPosition, margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        fdLimit.top = new FormAttachment((Control)this.wlPosition, margin);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlOuter = new Label((Composite)this.shell, 131072);
        wlOuter.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Outerjoin.Label", (String[])new String[0]));
        wlOuter.setToolTipText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Outerjoin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOuter);
        FormData fdlOuter = new FormData();
        fdlOuter.left = new FormAttachment(0, 0);
        fdlOuter.right = new FormAttachment(middle, -margin);
        fdlOuter.top = new FormAttachment((Control)this.wLimit, margin);
        wlOuter.setLayoutData((Object)fdlOuter);
        this.wOuter = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wOuter);
        this.wOuter.setToolTipText(wlOuter.getToolTipText());
        FormData fdOuter = new FormData();
        fdOuter.left = new FormAttachment(middle, 0);
        fdOuter.top = new FormAttachment((Control)wlOuter, 0, 0x1000000);
        this.wOuter.setLayoutData((Object)fdOuter);
        this.wOuter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
            }
        });
        Label wluseVars = new Label((Composite)this.shell, 131072);
        wluseVars.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.useVarsjoin.Label", (String[])new String[0]));
        wluseVars.setToolTipText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.useVarsjoin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wluseVars);
        FormData fdluseVars = new FormData();
        fdluseVars.left = new FormAttachment(0, 0);
        fdluseVars.right = new FormAttachment(middle, -margin);
        fdluseVars.top = new FormAttachment((Control)this.wOuter, margin);
        wluseVars.setLayoutData((Object)fdluseVars);
        this.wUseVars = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wUseVars);
        this.wUseVars.setToolTipText(wluseVars.getToolTipText());
        FormData fduseVars = new FormData();
        fduseVars.left = new FormAttachment(middle, 0);
        fduseVars.top = new FormAttachment((Control)wluseVars, 0, 0x1000000);
        this.wUseVars.setLayoutData((Object)fduseVars);
        this.wUseVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, wGet, this.wCancel}, margin, null);
        Label wlParam = new Label((Composite)this.shell, 0);
        wlParam.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Param.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParam);
        FormData fdlParam = new FormData();
        fdlParam.left = new FormAttachment(0, 0);
        fdlParam.top = new FormAttachment((Control)this.wUseVars, margin);
        wlParam.setLayoutData((Object)fdlParam);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getParameters() != null ? this.input.getParameters().size() : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.ColumnInfo.ParameterFieldname", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.ColumnInfo.ParameterType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        this.wParam = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        FormData fdParam = new FormData();
        fdParam.left = new FormAttachment(0, 0);
        fdParam.top = new FormAttachment((Control)wlParam, margin);
        fdParam.right = new FormAttachment(100, 0);
        fdParam.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wParam.setLayoutData((Object)fdParam);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private List<String> getSqlReservedWords() {
        if (this.input.getConnection() == null || this.input.getConnection().isEmpty()) {
            return List.of();
        }
        if (this.variables.resolve(this.input.getConnection()).startsWith("${")) {
            return List.of();
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        return Arrays.stream(databaseMeta.getReservedWords()).toList();
    }

    private void enableFields() {
        this.wCacheSize.setEnabled(this.wCache.getSelection());
        this.wlCacheSize.setEnabled(this.wCache.getSelection());
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKey[0].setComboValues(fieldNames);
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wConnection.setText(Const.NVL((String)this.input.getConnection(), (String)""));
        this.wCache.setSelection(this.input.isCached());
        this.wCacheSize.setText("" + this.input.getCacheSize());
        this.wSql.setText(Const.NVL((String)this.input.getSql(), (String)""));
        this.wLimit.setText("" + this.input.getRowLimit());
        this.wOuter.setSelection(this.input.isOuterJoin());
        this.wUseVars.setSelection(this.input.isReplaceVariables());
        if (this.input.getParameters() != null) {
            int i = 0;
            for (ParameterField field : this.input.getParameters()) {
                TableItem item = this.wParam.table.getItem(i++);
                if (field == null) continue;
                item.setText(1, field.getName());
                item.setText(2, field.getType());
            }
        }
        this.wParam.setRowNums();
        this.wParam.optWidth(true);
        this.enableFields();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrparam = this.wParam.nrNonEmpty();
        this.input.setConnection(this.wConnection.getText());
        this.input.setCached(this.wCache.getSelection());
        this.input.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)0));
        this.input.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        this.input.setSql(this.wSql.getText());
        this.input.setOuterJoin(this.wOuter.getSelection());
        this.input.setReplaceVariables(this.wUseVars.getSelection());
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Log.ParametersFound", (String[])new String[0]) + nrparam + " parameters");
        ArrayList<ParameterField> parameters = new ArrayList<ParameterField>();
        for (int i = 0; i < nrparam; ++i) {
            TableItem item = this.wParam.getNonEmpty(i);
            ParameterField field = new ParameterField();
            field.setName(item.getText(1));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(2)));
            parameters.add(field);
        }
        this.input.setParameters(parameters);
        this.transformName = this.wTransformName.getText();
        if (this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wParam, (int)1, (int[])new int[]{1}, (int[])new int[]{2}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

