/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.parser.html.charsetdetector.CharsetDetectionResult;
import org.apache.tika.parser.html.charsetdetector.MetaProcessor;

class PreScanner {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([\"']?)([^\"'\\s;]+)\\1");
    private static final byte[] COMMENT_START = new byte[]{60, 33, 45, 45};
    private static final byte[] COMMENT_END = new byte[]{45, 45, 62};
    private static final byte[] META_TAG_START = new byte[]{60, 109, 101, 116, 97};
    private static final byte SLASH = 47;
    private static final byte EQUAL = 61;
    private static final byte TAG_START = 60;
    private static final byte TAG_END = 62;
    private static final BitSet QUOTE = PreScanner.bitSet(34, 39);
    private static final BitSet WHITESPACE = PreScanner.bitSet(9, 10, 12, 13, 13, 32);
    private static final BitSet SPACE_OR_TAG_END = PreScanner.bitSet(WHITESPACE, 62);
    private static final BitSet SPACE_OR_SLASH = PreScanner.bitSet(WHITESPACE, 47);
    private static final BitSet SPECIAL_TAGS = PreScanner.bitSet(33, 47, 63);
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF16_LE_BOM = new byte[]{-1, -2};
    private static final byte LOWER_A = 97;
    private static final byte LOWER_Z = 122;
    private static final byte UPPER_A = 65;
    private static final byte UPPER_Z = 90;
    private BufferedInputStream stream;
    private CharsetDetectionResult detectedCharset = CharsetDetectionResult.notFound();

    PreScanner(InputStream inputStream) {
        this.stream = new BufferedInputStream(inputStream);
    }

    private static BitSet bitSet(int ... bs) {
        BitSet bitSet = new BitSet(255);
        for (int b : bs) {
            bitSet.set(b);
        }
        return bitSet;
    }

    private static BitSet bitSet(BitSet base, int ... bs) {
        BitSet bitSet = (BitSet)base.clone();
        for (int b : bs) {
            bitSet.set(b);
        }
        return bitSet;
    }

    static String getEncodingFromMeta(String attributeValue) {
        Matcher matcher = CHARSET_PATTERN.matcher(attributeValue);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(2);
    }

    private static boolean contains(BitSet bitSet, byte b) {
        return bitSet.get(b & 0xFF);
    }

    Charset scan() {
        while (this.processAtLeastOneByte()) {
            if (!this.detectedCharset.isFound()) continue;
            return this.detectedCharset.getCharset();
        }
        return null;
    }

    Charset detectBOM() {
        try {
            if (this.expect(UTF8_BOM)) {
                return StandardCharsets.UTF_8;
            }
            if (this.expect(UTF16_BE_BOM)) {
                return StandardCharsets.UTF_16BE;
            }
            if (this.expect(UTF16_LE_BOM)) {
                return StandardCharsets.UTF_16LE;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean processAtLeastOneByte() {
        try {
            return this.processComment() || this.processMeta() || this.processTag() || this.processSpecialTag() || this.processAny();
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean processAny() throws IOException {
        int read = this.stream.read();
        return read != -1;
    }

    private boolean processTag() throws IOException {
        this.stream.mark(3);
        if (this.read() == 60) {
            int read = this.stream.read();
            if (read == 47) {
                read = this.stream.read();
            }
            if (97 <= read && read <= 122 || 65 <= read && read <= 90) {
                do {
                    this.stream.mark(1);
                } while (!PreScanner.contains(SPACE_OR_TAG_END, this.read()));
                this.stream.reset();
                while (this.getAttribute() != null) {
                }
                return true;
            }
        }
        this.stream.reset();
        return false;
    }

    private boolean processSpecialTag() throws IOException {
        this.stream.mark(2);
        if (this.read() == 60 && PreScanner.contains(SPECIAL_TAGS, this.read())) {
            this.skipUntil(62);
            return true;
        }
        this.stream.reset();
        return false;
    }

    private boolean processMeta() throws IOException {
        this.stream.mark(6);
        if (this.readCaseInsensitive(META_TAG_START) && PreScanner.contains(SPACE_OR_SLASH, this.read())) {
            MetaProcessor metaProcessor = new MetaProcessor();
            Map.Entry<String, String> attribute = this.getAttribute();
            while (attribute != null) {
                metaProcessor.processAttribute(attribute);
                attribute = this.getAttribute();
            }
            metaProcessor.updateDetectedCharset(this.detectedCharset);
            return true;
        }
        this.stream.reset();
        return false;
    }

    private Map.Entry<String, String> getAttribute() throws IOException {
        String name = this.getAttributeName();
        if (name == null) {
            return null;
        }
        if (!this.expect(61)) {
            return new AbstractMap.SimpleEntry<String, String>(name, "");
        }
        this.skipAll(WHITESPACE);
        String value = this.getAttributeValue();
        return new AbstractMap.SimpleEntry<String, String>(name, value);
    }

    private String getAttributeName() throws IOException {
        this.skipAll(SPACE_OR_SLASH);
        if (this.expect(62)) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        while (!(this.peek() == 61 && name.length() > 0 || this.peek() == 62 || this.peek() == 47 || this.skipAll(WHITESPACE))) {
            name.append((char)this.getLowerCaseChar());
        }
        return name.toString();
    }

    private String getAttributeValue() throws IOException {
        StringBuilder value = new StringBuilder();
        this.stream.mark(1);
        byte quote = this.read();
        if (PreScanner.contains(QUOTE, quote)) {
            byte b = this.getLowerCaseChar();
            while (b != quote) {
                value.append((char)b);
                b = this.getLowerCaseChar();
            }
        } else {
            this.stream.reset();
            byte b = this.getLowerCaseChar();
            while (!PreScanner.contains(SPACE_OR_TAG_END, b)) {
                value.append((char)b);
                this.stream.mark(1);
                b = this.getLowerCaseChar();
            }
            this.stream.reset();
        }
        return value.toString();
    }

    private boolean skipAll(BitSet bitSet) throws IOException {
        boolean skipped = false;
        this.stream.mark(1);
        byte read = this.read();
        while (PreScanner.contains(bitSet, read)) {
            skipped = true;
            this.stream.mark(1);
            read = this.read();
        }
        this.stream.reset();
        return skipped;
    }

    private byte getLowerCaseChar() throws IOException {
        byte nextPoint = this.read();
        if (nextPoint >= 65 && nextPoint <= 90) {
            nextPoint = (byte)(nextPoint + 32);
        }
        return nextPoint;
    }

    private boolean processComment() throws IOException {
        if (!this.expect(COMMENT_START)) {
            return false;
        }
        if (!this.expect(62)) {
            this.skipUntil(COMMENT_END);
        }
        return true;
    }

    private boolean expect(byte ... expected) throws IOException {
        this.stream.mark(expected.length);
        for (byte b : expected) {
            byte read = this.read();
            if (read == b) continue;
            this.stream.reset();
            return false;
        }
        return true;
    }

    private void skipUntil(byte ... expected) throws IOException {
        while (!this.expect(expected)) {
            if (this.stream.read() != -1) continue;
            return;
        }
    }

    private boolean readCaseInsensitive(byte ... bs) throws IOException {
        for (byte b : bs) {
            if (this.getLowerCaseChar() == b) continue;
            return false;
        }
        return true;
    }

    private byte read() throws IOException {
        int r = this.stream.read();
        if (r == -1) {
            throw new IOException();
        }
        return (byte)r;
    }

    private byte peek() throws IOException {
        this.stream.mark(1);
        byte b = this.read();
        this.stream.reset();
        return b;
    }
}

