/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public interface OperatorStateHandle
extends StreamStateHandle {
    public Map<String, StateMetaInfo> getStateNameToPartitionOffsets();

    @Override
    public FSDataInputStream openInputStream() throws IOException;

    public StreamStateHandle getDelegateStateHandle();

    public static class StateMetaInfo
    implements Serializable {
        private static final long serialVersionUID = 3593817615858941166L;
        private final long[] offsets;
        private final Mode distributionMode;

        public StateMetaInfo(long[] offsets, Mode distributionMode) {
            this.offsets = (long[])Preconditions.checkNotNull((Object)offsets);
            this.distributionMode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)distributionMode)));
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public Mode getDistributionMode() {
            return this.distributionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateMetaInfo that = (StateMetaInfo)o;
            return Arrays.equals(this.getOffsets(), that.getOffsets()) && this.getDistributionMode() == that.getDistributionMode();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.getOffsets());
            result = 31 * result + this.getDistributionMode().hashCode();
            return result;
        }

        public String toString() {
            return "StateMetaInfo{offsets=" + Arrays.toString(this.offsets) + ", distributionMode=" + (Object)((Object)this.distributionMode) + '}';
        }
    }

    public static enum Mode {
        SPLIT_DISTRIBUTE,
        UNION,
        BROADCAST;

    }
}

