/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.state.changelog.StateChange;

@Internal
public class InMemoryChangelogStateHandle
implements ChangelogStateHandle {
    private static final long serialVersionUID = 1L;
    private final List<StateChange> changes;
    private final SequenceNumber from;
    private final SequenceNumber to;
    private final KeyGroupRange keyGroupRange;
    private final StateHandleID stateHandleID;

    public InMemoryChangelogStateHandle(List<StateChange> changes, SequenceNumber from, SequenceNumber to, KeyGroupRange keyGroupRange) {
        this(changes, from, to, keyGroupRange, new StateHandleID(UUID.randomUUID().toString()));
    }

    private InMemoryChangelogStateHandle(List<StateChange> changes, SequenceNumber from, SequenceNumber to, KeyGroupRange keyGroupRange, StateHandleID stateHandleId) {
        this.changes = changes;
        this.from = from;
        this.to = to;
        this.keyGroupRange = keyGroupRange;
        this.stateHandleID = stateHandleId;
    }

    public static InMemoryChangelogStateHandle restore(List<StateChange> changes, SequenceNumber from, SequenceNumber to, KeyGroupRange keyGroupRange, StateHandleID stateHandleId) {
        return new InMemoryChangelogStateHandle(changes, from, to, keyGroupRange, stateHandleId);
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.changes.stream().mapToLong(change -> change.getChange().length).sum();
    }

    @Override
    public long getCheckpointedSize() {
        return this.getStateSize();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        collector.add(StateObject.StateObjectLocation.LOCAL_MEMORY, this.getStateSize());
    }

    public List<StateChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return this.changes.stream().mapToInt(StateChange::getKeyGroup).anyMatch(keyGroupRange::contains) ? this : null;
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.stateHandleID;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
    }

    public String toString() {
        return String.format("from %s to %s: %s", this.from, this.to, this.changes);
    }

    public long getFrom() {
        return ((SequenceNumber.GenericSequenceNumber)this.from).number;
    }

    public long getTo() {
        return ((SequenceNumber.GenericSequenceNumber)this.to).number;
    }

    @Override
    public String getStorageIdentifier() {
        return "memory";
    }
}

