/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.simpleeval;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.simpleeval.ActionSimpleEval;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionSimpleEvalDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionSimpleEval.class;
    private Text wName;
    private ActionSimpleEval action;
    private boolean changed;
    private Label wlSuccessWhenSet;
    private Button wSuccessWhenSet;
    private Label wlSuccessStringCondition;
    private Label wlFieldType;
    private Label wlMask;
    private Combo wSuccessStringCondition;
    private Combo wValueType;
    private Combo wFieldType;
    private ComboVar wMask;
    private Label wlSuccessNumberCondition;
    private Combo wSuccessNumberCondition;
    private Label wlSuccessBooleanCondition;
    private Combo wSuccessBooleanCondition;
    private Label wlCompareValue;
    private TextVar wCompareValue;
    private Label wlMinValue;
    private TextVar wMinValue;
    private Label wlMaxValue;
    private TextVar wMaxValue;
    private Label wlVariableName;
    private TextVar wVariableName;
    private Label wlFieldName;
    private TextVar wFieldName;

    public ActionSimpleEvalDialog(Shell parent, ActionSimpleEval action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wName.addListener(24, e -> this.action.setChanged());
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wSource = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSource);
        wSource.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Source.Group.Label", (String[])new String[0]));
        FormLayout sourcegroupLayout = new FormLayout();
        sourcegroupLayout.marginWidth = 10;
        sourcegroupLayout.marginHeight = 10;
        wSource.setLayout((Layout)sourcegroupLayout);
        Label wlValueType = new Label((Composite)wSource, 131072);
        wlValueType.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.ValueType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValueType);
        FormData fdlValueType = new FormData();
        fdlValueType.left = new FormAttachment(0, -margin);
        fdlValueType.right = new FormAttachment(middle, -margin);
        fdlValueType.top = new FormAttachment(0, margin);
        wlValueType.setLayoutData((Object)fdlValueType);
        this.wValueType = new Combo((Composite)wSource, 2060);
        this.wValueType.setItems(ActionSimpleEval.ValueType.getDescriptions());
        PropsUi.setLook((Widget)this.wValueType);
        FormData fdValueType = new FormData();
        fdValueType.left = new FormAttachment(middle, 0);
        fdValueType.top = new FormAttachment(0, margin);
        fdValueType.right = new FormAttachment(100, 0);
        this.wValueType.setLayoutData((Object)fdValueType);
        this.wValueType.addListener(13, e -> this.refresh());
        this.wlFieldName = new Label((Composite)wSource, 131072);
        this.wlFieldName.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.top = new FormAttachment((Control)this.wValueType, margin);
        fdlFieldName.right = new FormAttachment(middle, -margin);
        this.wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new TextVar(this.variables, (Composite)wSource, 18436, BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldName);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(middle, 0);
        fdFieldName.top = new FormAttachment((Control)this.wValueType, margin);
        fdFieldName.right = new FormAttachment(100, -margin);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        this.wFieldName.addListener(24, e -> this.action.setChanged());
        this.wlVariableName = new Label((Composite)wSource, 131072);
        this.wlVariableName.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Variable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlVariableName);
        FormData fdlVariableName = new FormData();
        fdlVariableName.left = new FormAttachment(0, 0);
        fdlVariableName.top = new FormAttachment((Control)this.wValueType, margin);
        fdlVariableName.right = new FormAttachment(middle, -margin);
        this.wlVariableName.setLayoutData((Object)fdlVariableName);
        this.wVariableName = new TextVar(this.variables, (Composite)wSource, 18436, BaseMessages.getString(PKG, (String)"ActionSimpleEval.Variable.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wVariableName);
        FormData fdVariableName = new FormData();
        fdVariableName.left = new FormAttachment(middle, 0);
        fdVariableName.top = new FormAttachment((Control)this.wValueType, margin);
        fdVariableName.right = new FormAttachment(100, -margin);
        this.wVariableName.setLayoutData((Object)fdVariableName);
        this.wVariableName.addListener(24, e -> this.action.setChanged());
        this.wlFieldType = new Label((Composite)wSource, 131072);
        this.wlFieldType.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldType);
        FormData fdlFieldType = new FormData();
        fdlFieldType.left = new FormAttachment(0, 0);
        fdlFieldType.right = new FormAttachment(middle, -margin);
        fdlFieldType.top = new FormAttachment((Control)this.wVariableName, margin);
        this.wlFieldType.setLayoutData((Object)fdlFieldType);
        this.wFieldType = new Combo((Composite)wSource, 2060);
        this.wFieldType.setItems(ActionSimpleEval.FieldType.getDescriptions());
        PropsUi.setLook((Widget)this.wFieldType);
        FormData fdFieldType = new FormData();
        fdFieldType.left = new FormAttachment(middle, 0);
        fdFieldType.top = new FormAttachment((Control)this.wVariableName, margin);
        fdFieldType.right = new FormAttachment(100, 0);
        this.wFieldType.setLayoutData((Object)fdFieldType);
        this.wFieldType.addListener(13, e -> {
            this.refresh();
            this.action.setChanged();
        });
        this.wlMask = new Label((Composite)wSource, 131072);
        this.wlMask.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Mask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMask);
        FormData fdlMask = new FormData();
        fdlMask.left = new FormAttachment(0, 0);
        fdlMask.right = new FormAttachment(middle, -margin);
        fdlMask.top = new FormAttachment((Control)this.wFieldType, margin);
        this.wlMask.setLayoutData((Object)fdlMask);
        this.wMask = new ComboVar(this.variables, (Composite)wSource, 2056);
        this.wMask.setItems(Const.getDateFormats());
        this.wMask.setEditable(true);
        PropsUi.setLook((Widget)this.wMask);
        FormData fdMask = new FormData();
        fdMask.left = new FormAttachment(middle, 0);
        fdMask.top = new FormAttachment((Control)this.wFieldType, margin);
        fdMask.right = new FormAttachment(100, 0);
        this.wMask.setLayoutData((Object)fdMask);
        this.wMask.addListener(13, e -> this.action.setChanged());
        FormData fdSource = new FormData();
        fdSource.left = new FormAttachment(0, margin);
        fdSource.top = new FormAttachment((Control)this.wName, margin);
        fdSource.right = new FormAttachment(100, -margin);
        wSource.setLayoutData((Object)fdSource);
        Group wSuccessOn = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSuccessOn);
        wSuccessOn.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessOn.Group.Label", (String[])new String[0]));
        FormLayout successongroupLayout = new FormLayout();
        successongroupLayout.marginWidth = 10;
        successongroupLayout.marginHeight = 10;
        wSuccessOn.setLayout((Layout)successongroupLayout);
        this.wlSuccessWhenSet = new Label((Composite)wSuccessOn, 131072);
        this.wlSuccessWhenSet.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSet.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSuccessWhenSet);
        FormData fdlSuccessWhenSet = new FormData();
        fdlSuccessWhenSet.left = new FormAttachment(0, 0);
        fdlSuccessWhenSet.top = new FormAttachment((Control)this.wVariableName, margin);
        fdlSuccessWhenSet.right = new FormAttachment(middle, -margin);
        this.wlSuccessWhenSet.setLayoutData((Object)fdlSuccessWhenSet);
        this.wSuccessWhenSet = new Button((Composite)wSuccessOn, 32);
        this.wSuccessWhenSet.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSet.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSuccessWhenSet);
        FormData fdSuccessWhenSet = new FormData();
        fdSuccessWhenSet.left = new FormAttachment(middle, 0);
        fdSuccessWhenSet.top = new FormAttachment((Control)this.wlSuccessWhenSet, 0, 0x1000000);
        fdSuccessWhenSet.right = new FormAttachment(100, 0);
        this.wSuccessWhenSet.setLayoutData((Object)fdSuccessWhenSet);
        this.wSuccessWhenSet.addListener(13, e -> {
            this.refresh();
            this.action.setChanged();
        });
        this.wlSuccessStringCondition = new Label((Composite)wSuccessOn, 131072);
        this.wlSuccessStringCondition.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessCondition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSuccessStringCondition);
        FormData fdlSuccessStringCondition = new FormData();
        fdlSuccessStringCondition.left = new FormAttachment(0, 0);
        fdlSuccessStringCondition.right = new FormAttachment(middle, -margin);
        fdlSuccessStringCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        this.wlSuccessStringCondition.setLayoutData((Object)fdlSuccessStringCondition);
        this.wSuccessStringCondition = new Combo((Composite)wSuccessOn, 2060);
        this.wSuccessStringCondition.setItems(ActionSimpleEval.SuccessStringCondition.getDescriptions());
        this.wSuccessStringCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessStringCondition);
        FormData fdSuccessStringCondition = new FormData();
        fdSuccessStringCondition.left = new FormAttachment(middle, 0);
        fdSuccessStringCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        fdSuccessStringCondition.right = new FormAttachment(100, 0);
        this.wSuccessStringCondition.setLayoutData((Object)fdSuccessStringCondition);
        this.wSuccessStringCondition.addListener(13, e -> {
            this.refresh();
            this.action.setChanged();
        });
        this.wlSuccessNumberCondition = new Label((Composite)wSuccessOn, 131072);
        this.wlSuccessNumberCondition.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessNumberCondition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSuccessNumberCondition);
        FormData fdlSuccessNumberCondition = new FormData();
        fdlSuccessNumberCondition.left = new FormAttachment(0, 0);
        fdlSuccessNumberCondition.right = new FormAttachment(middle, -margin);
        fdlSuccessNumberCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        this.wlSuccessNumberCondition.setLayoutData((Object)fdlSuccessNumberCondition);
        this.wSuccessNumberCondition = new Combo((Composite)wSuccessOn, 2060);
        this.wSuccessNumberCondition.setItems(ActionSimpleEval.SuccessNumberCondition.getDescriptions());
        this.wSuccessNumberCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessNumberCondition);
        FormData fdSuccessNumberCondition = new FormData();
        fdSuccessNumberCondition.left = new FormAttachment(middle, 0);
        fdSuccessNumberCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        fdSuccessNumberCondition.right = new FormAttachment(100, 0);
        this.wSuccessNumberCondition.setLayoutData((Object)fdSuccessNumberCondition);
        this.wSuccessNumberCondition.addListener(13, e -> {
            this.refresh();
            this.action.setChanged();
        });
        this.wlSuccessBooleanCondition = new Label((Composite)wSuccessOn, 131072);
        this.wlSuccessBooleanCondition.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessBooleanCondition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSuccessBooleanCondition);
        FormData fdlSuccessBooleanCondition = new FormData();
        fdlSuccessBooleanCondition.left = new FormAttachment(0, 0);
        fdlSuccessBooleanCondition.right = new FormAttachment(middle, -margin);
        fdlSuccessBooleanCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        this.wlSuccessBooleanCondition.setLayoutData((Object)fdlSuccessBooleanCondition);
        this.wSuccessBooleanCondition = new Combo((Composite)wSuccessOn, 2060);
        this.wSuccessBooleanCondition.setItems(ActionSimpleEval.SuccessBooleanCondition.getDescriptions());
        this.wSuccessBooleanCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessBooleanCondition);
        FormData fdSuccessBooleanCondition = new FormData();
        fdSuccessBooleanCondition.left = new FormAttachment(middle, 0);
        fdSuccessBooleanCondition.top = new FormAttachment((Control)this.wSuccessWhenSet, margin);
        fdSuccessBooleanCondition.right = new FormAttachment(100, 0);
        this.wSuccessBooleanCondition.setLayoutData((Object)fdSuccessBooleanCondition);
        this.wSuccessBooleanCondition.addListener(13, e -> {
            this.refresh();
            this.action.setChanged();
        });
        this.wlCompareValue = new Label((Composite)wSuccessOn, 131072);
        this.wlCompareValue.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.CompareValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCompareValue);
        FormData fdlCompareValue = new FormData();
        fdlCompareValue.left = new FormAttachment(0, 0);
        fdlCompareValue.top = new FormAttachment((Control)this.wSuccessNumberCondition, margin);
        fdlCompareValue.right = new FormAttachment(middle, -margin);
        this.wlCompareValue.setLayoutData((Object)fdlCompareValue);
        this.wCompareValue = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionSimpleEval.CompareValue.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCompareValue);
        FormData fdCompareValue = new FormData();
        fdCompareValue.left = new FormAttachment(middle, 0);
        fdCompareValue.top = new FormAttachment((Control)this.wSuccessNumberCondition, margin);
        fdCompareValue.right = new FormAttachment(100, -margin);
        this.wCompareValue.setLayoutData((Object)fdCompareValue);
        this.wCompareValue.addListener(24, e -> this.action.setChanged());
        this.wlMinValue = new Label((Composite)wSuccessOn, 131072);
        this.wlMinValue.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.MinValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMinValue);
        FormData fdlMinValue = new FormData();
        fdlMinValue.left = new FormAttachment(0, 0);
        fdlMinValue.top = new FormAttachment((Control)this.wSuccessNumberCondition, margin);
        fdlMinValue.right = new FormAttachment(middle, -margin);
        this.wlMinValue.setLayoutData((Object)fdlMinValue);
        this.wMinValue = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionSimpleEval.MinValue.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wMinValue);
        FormData fdMinValue = new FormData();
        fdMinValue.left = new FormAttachment(middle, 0);
        fdMinValue.top = new FormAttachment((Control)this.wSuccessNumberCondition, margin);
        fdMinValue.right = new FormAttachment(100, -margin);
        this.wMinValue.setLayoutData((Object)fdMinValue);
        this.wMinValue.addListener(24, e -> this.action.setChanged());
        this.wlMaxValue = new Label((Composite)wSuccessOn, 131072);
        this.wlMaxValue.setText(BaseMessages.getString(PKG, (String)"ActionSimpleEval.MaxValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMaxValue);
        FormData fdlMaxValue = new FormData();
        fdlMaxValue.left = new FormAttachment(0, 0);
        fdlMaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdlMaxValue.right = new FormAttachment(middle, -margin);
        this.wlMaxValue.setLayoutData((Object)fdlMaxValue);
        this.wMaxValue = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionSimpleEval.MaxValue.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wMaxValue);
        FormData fdMaxValue = new FormData();
        fdMaxValue.left = new FormAttachment(middle, 0);
        fdMaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdMaxValue.right = new FormAttachment(100, -margin);
        this.wMaxValue.setLayoutData((Object)fdMaxValue);
        this.wMaxValue.addListener(24, e -> this.action.setChanged());
        FormData fdSuccessOn = new FormData();
        fdSuccessOn.left = new FormAttachment(0, margin);
        fdSuccessOn.top = new FormAttachment((Control)wSource, margin);
        fdSuccessOn.right = new FormAttachment(100, -margin);
        wSuccessOn.setLayoutData((Object)fdSuccessOn);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.refresh();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wValueType.setText(this.action.getValueType().getDescription());
        this.wFieldName.setText(Const.nullToEmpty((String)this.action.getFieldName()));
        this.wVariableName.setText(Const.nullToEmpty((String)this.action.getVariableName()));
        this.wSuccessWhenSet.setSelection(this.action.isSuccessWhenVarSet());
        this.wFieldType.setText(this.action.getFieldType().getDescription());
        this.wMask.setText(Const.nullToEmpty((String)this.action.getMask()));
        this.wCompareValue.setText(Const.nullToEmpty((String)this.action.getCompareValue()));
        this.wMinValue.setText(Const.nullToEmpty((String)this.action.getMinValue()));
        this.wMaxValue.setText(Const.nullToEmpty((String)this.action.getMaxValue()));
        this.wSuccessStringCondition.setText(this.action.getSuccessStringCondition().getDescription());
        this.wSuccessNumberCondition.setText(this.action.getSuccessNumberCondition().getDescription());
        this.wSuccessBooleanCondition.setText(this.action.getSuccessBooleanCondition().getDescription());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void refresh() {
        boolean evaluatepreviousRowField = ActionSimpleEval.ValueType.lookupDescription(this.wValueType.getText()) == ActionSimpleEval.ValueType.FIELD;
        boolean evaluateVariable = ActionSimpleEval.ValueType.lookupDescription(this.wValueType.getText()) == ActionSimpleEval.ValueType.VARIABLE;
        this.wlVariableName.setVisible(evaluateVariable);
        this.wVariableName.setVisible(evaluateVariable);
        this.wlFieldName.setVisible(evaluatepreviousRowField);
        this.wFieldName.setVisible(evaluatepreviousRowField);
        this.wlSuccessWhenSet.setVisible(evaluateVariable);
        this.wSuccessWhenSet.setVisible(evaluateVariable);
        boolean successWhenSet = this.wSuccessWhenSet.getSelection() && evaluateVariable;
        this.wlFieldType.setVisible(!successWhenSet);
        this.wFieldType.setVisible(!successWhenSet);
        boolean valueTypeDate = ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()) == ActionSimpleEval.FieldType.DATE_TIME;
        this.wlMask.setVisible(!successWhenSet && valueTypeDate);
        this.wMask.setVisible(!successWhenSet && valueTypeDate);
        boolean valueTypeString = ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()) == ActionSimpleEval.FieldType.STRING;
        this.wlSuccessStringCondition.setVisible(!successWhenSet && valueTypeString);
        this.wSuccessStringCondition.setVisible(!successWhenSet && valueTypeString);
        boolean valueTypeNumber = ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()) == ActionSimpleEval.FieldType.NUMBER || ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()) == ActionSimpleEval.FieldType.DATE_TIME;
        this.wlSuccessNumberCondition.setVisible(!successWhenSet && valueTypeNumber);
        this.wSuccessNumberCondition.setVisible(!successWhenSet && valueTypeNumber);
        boolean valueTypeBoolean = ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()) == ActionSimpleEval.FieldType.BOOLEAN;
        this.wlSuccessBooleanCondition.setVisible(!successWhenSet && valueTypeBoolean);
        this.wSuccessBooleanCondition.setVisible(!successWhenSet && valueTypeBoolean);
        boolean compareValue = valueTypeString || !valueTypeString && ActionSimpleEval.SuccessNumberCondition.lookupDescription(this.wSuccessNumberCondition.getText()) != ActionSimpleEval.SuccessNumberCondition.BETWEEN;
        this.wlCompareValue.setVisible(!successWhenSet && compareValue && !valueTypeBoolean);
        this.wCompareValue.setVisible(!successWhenSet && compareValue && !valueTypeBoolean);
        this.wlMinValue.setVisible(!successWhenSet && !compareValue && !valueTypeBoolean);
        this.wMinValue.setVisible(!successWhenSet && !compareValue && !valueTypeBoolean);
        this.wlMaxValue.setVisible(!successWhenSet && !compareValue && !valueTypeBoolean);
        this.wMaxValue.setVisible(!successWhenSet && !compareValue && !valueTypeBoolean);
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setValueType(ActionSimpleEval.ValueType.lookupDescription(this.wValueType.getText()));
        this.action.setFieldName(this.wFieldName.getText());
        this.action.setVariableName(this.wVariableName.getText());
        this.action.setFieldType(ActionSimpleEval.FieldType.lookupDescription(this.wFieldType.getText()));
        this.action.setMask(this.wMask.getText());
        this.action.setCompareValue(this.wCompareValue.getText());
        this.action.setMinValue(this.wMinValue.getText());
        this.action.setMaxValue(this.wMaxValue.getText());
        this.action.setSuccessStringCondition(ActionSimpleEval.SuccessStringCondition.lookupDescription(this.wSuccessStringCondition.getText()));
        this.action.setSuccessNumberCondition(ActionSimpleEval.SuccessNumberCondition.lookupDescription(this.wSuccessNumberCondition.getText()));
        this.action.setSuccessBooleanCondition(ActionSimpleEval.SuccessBooleanCondition.lookupDescription(this.wSuccessBooleanCondition.getText()));
        this.action.setSuccessWhenVarSet(this.wSuccessWhenSet.getSelection());
        this.dispose();
    }
}

