/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.run;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.FileLoggingEventListener;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import picocli.CommandLine;

public abstract class HopRunBase
implements Runnable,
IHasHopMetadataProvider {
    @CommandLine.Option(names={"-f", "--file"}, description={"The filename of the workflow or pipeline to run"})
    protected String filename;
    @CommandLine.Option(names={"-l", "--level"}, description={"The debug level, one of NOTHING, ERROR, MINIMAL, BASIC, DETAILED, DEBUG, ROWLEVEL"})
    protected String level;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays this help message and quits."})
    protected boolean helpRequested;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    protected boolean versionRequested;
    @CommandLine.Option(names={"-lf", "--logfile"}, description={"The complete filename where hop-run will write the Hop console log"})
    protected String logFile;
    @CommandLine.Option(names={"-p", "--parameters"}, description={"A list of PARAMETER=VALUE pairs"})
    protected String[] parameters = null;
    @CommandLine.Option(names={"-ps", "--parameters-separator"}, description={"A character to be used as separator for our list of PARAMETER=VALUE pairs (default is ,)"})
    protected String parametersSeparator = null;
    @CommandLine.Option(names={"-s", "--system-properties"}, description={"A comma separated list of KEY=VALUE pairs"}, split=",")
    protected String[] systemProperties = null;
    @CommandLine.Option(names={"-r", "--runconfig"}, description={"The name of the Run Configuration to use"})
    protected String runConfigurationName = null;
    @CommandLine.Option(names={"-a", "--startaction"}, description={"The name of the action where to start a workflow"})
    protected String startActionName = null;
    @CommandLine.Option(names={"-m", "--metadata-export"}, description={"A file containing exported metadata in JSON format"})
    protected String metadataExportFile;
    @CommandLine.Option(names={"-o", "--printoptions"}, description={"Print the used options"})
    protected boolean printingOptions = false;
    protected IVariables variables = new Variables();
    protected String realRunConfigurationName;
    protected String realFilename;
    protected CommandLine cmd;
    protected ILogChannel log;
    protected MultiMetadataProvider metadataProvider;
    protected boolean finishedWithoutError;

    protected HopRunBase() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.validateOptions();
        FileLoggingEventListener fileLoggingEventListener = null;
        try {
            this.log = new LogChannel((Object)"HopRun");
            this.log.setLogLevel(this.determineLogLevel());
            this.log.logDetailed("Start of Hop Run");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunStart.id, (Object)this);
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                configOptions.handleOption(this.log, (IHasHopMetadataProvider)this, this.variables);
            }
            String metadataExportFile = this.variables.resolve(this.getMetadataExportFile());
            if (StringUtils.isNotEmpty((String)metadataExportFile)) {
                try (InputStream inputStream = HopVfs.getInputStream((String)metadataExportFile);){
                    String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    SerializableMetadataProvider exportedProvider = new SerializableMetadataProvider(json);
                    this.metadataProvider.getProviders().add(exportedProvider);
                    System.out.println("===> Metadata provider is now: " + this.metadataProvider.getDescription());
                }
            }
            if (!Utils.isEmpty((CharSequence)this.logFile)) {
                fileLoggingEventListener = new FileLoggingEventListener(this.logFile, false);
                HopLogStore.getAppender().addLoggingEventListener((IHopLoggingEventListener)fileLoggingEventListener);
            }
            if (this.isPipeline()) {
                this.runPipeline(this.cmd, this.log);
            }
            if (this.isWorkflow()) {
                this.runWorkflow(this.cmd, this.log);
            }
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunEnd.id, (Object)this);
            if (fileLoggingEventListener == null) return;
        }
        catch (Exception e) {
            try {
                throw new CommandLine.ExecutionException(this.cmd, "There was an error during execution of file '" + this.filename + "'", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (fileLoggingEventListener == null) throw throwable;
                HopLogStore.getAppender().removeLoggingEventListener(fileLoggingEventListener);
                throw throwable;
            }
        }
        HopLogStore.getAppender().removeLoggingEventListener((IHopLoggingEventListener)fileLoggingEventListener);
        return;
    }

    protected void buildVariableSpace() {
        this.variables = Variables.getADefaultVariableSpace();
    }

    protected void runPipeline(CommandLine cmd, ILogChannel log) {
        try {
            PipelineRunConfiguration defaultRunConfiguration;
            this.calculateRealFilename();
            PipelineMeta pipelineMeta = new PipelineMeta(this.realFilename, (IHopMetadataProvider)this.metadataProvider, this.variables);
            PipelineExecutionConfiguration configuration = new PipelineExecutionConfiguration();
            this.parseOptions(cmd, configuration, pipelineMeta);
            if (StringUtils.isEmpty((String)configuration.getRunConfiguration()) && (defaultRunConfiguration = PipelineRunConfiguration.findDefault((IHopMetadataProvider)this.metadataProvider)) != null) {
                configuration.setRunConfiguration(defaultRunConfiguration.getName());
            }
            if (this.printingOptions) {
                this.printOptions(configuration);
            }
            this.runPipeline(cmd, log, configuration, pipelineMeta);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of pipeline '" + this.filename + "'", (Throwable)e);
        }
    }

    protected void calculateRealFilename() throws HopException {
        this.realFilename = this.variables.resolve(this.filename);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunCalculateFilename.id, (Object)this);
    }

    protected void runPipeline(CommandLine cmd, ILogChannel log, PipelineExecutionConfiguration configuration, PipelineMeta pipelineMeta) {
        try {
            String pipelineRunConfigurationName = this.variables.resolve(configuration.getRunConfiguration());
            IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, pipelineRunConfigurationName, (IHopMetadataProvider)this.metadataProvider, pipelineMeta);
            pipeline.getPipelineMeta().setInternalHopVariables(pipeline);
            pipeline.initializeFrom(null);
            pipeline.setVariables(configuration.getVariablesMap());
            pipeline.copyParametersFromDefinitions(pipelineMeta);
            this.configureParametersAndVariables(cmd, configuration, pipeline, pipeline);
            pipeline.setLogLevel(configuration.getLogLevel());
            pipeline.setMetadataProvider((IHopMetadataProvider)this.metadataProvider);
            pipeline.activateParameters(pipeline);
            log.logMinimal("Starting pipeline: " + pipelineMeta.getFilename());
            pipeline.prepareExecution();
            pipeline.startThreads();
            pipeline.waitUntilFinished();
            this.setFinishedWithoutError(pipeline.getResult().getNrErrors() == 0L);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "Error running pipeline locally", (Throwable)e);
        }
    }

    protected void runWorkflow(CommandLine cmd, ILogChannel log) {
        try {
            WorkflowRunConfiguration defaultRunConfiguration;
            this.calculateRealFilename();
            WorkflowMeta workflowMeta = new WorkflowMeta(this.variables, this.realFilename, (IHopMetadataProvider)this.metadataProvider);
            WorkflowExecutionConfiguration configuration = new WorkflowExecutionConfiguration();
            this.parseOptions(cmd, configuration, workflowMeta);
            if (StringUtils.isEmpty((String)configuration.getRunConfiguration()) && (defaultRunConfiguration = WorkflowRunConfiguration.findDefault((IHopMetadataProvider)this.metadataProvider)) != null) {
                configuration.setRunConfiguration(defaultRunConfiguration.getName());
            }
            configuration.setStartActionName(this.startActionName);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiWorkflowBeforeStart.id, (Object)new Object[]{configuration, null, workflowMeta, null});
            if (this.printingOptions) {
                this.printOptions(configuration);
            }
            this.runWorkflow(cmd, log, configuration, workflowMeta);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of workflow '" + this.filename + "'", (Throwable)e);
        }
    }

    protected void runWorkflow(CommandLine cmd, ILogChannel log, WorkflowExecutionConfiguration configuration, WorkflowMeta workflowMeta) {
        try {
            String runConfigurationName = this.variables.resolve(configuration.getRunConfiguration());
            LoggingObject workflowLog = new LoggingObject((Object)log);
            workflowLog.setLogLevel(configuration.getLogLevel());
            IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, runConfigurationName, (IHopMetadataProvider)this.metadataProvider, workflowMeta, (ILoggingObject)workflowLog);
            workflow.getWorkflowMeta().setInternalHopVariables(workflow);
            workflow.setVariables(configuration.getVariablesMap());
            workflow.copyParametersFromDefinitions(workflowMeta);
            this.configureParametersAndVariables(cmd, configuration, workflow, workflow);
            workflow.activateParameters(workflow);
            if (!Utils.isEmpty((CharSequence)configuration.getStartActionName())) {
                ActionMeta startActionMeta = workflowMeta.findAction(configuration.getStartActionName());
                if (startActionMeta == null) {
                    throw new CommandLine.ExecutionException(cmd, "Error running workflow, specified start action not found");
                }
                workflow.setStartActionMeta(startActionMeta);
            }
            log.logMinimal("Starting workflow: " + workflowMeta.getFilename());
            workflow.startExecution();
            this.setFinishedWithoutError(workflow.getResult().isResult());
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "Error running workflow locally", (Throwable)e);
        }
    }

    protected void parseOptions(CommandLine cmd, IExecutionConfiguration configuration, INamedParameterDefinitions namedParams) throws HopException {
        this.realRunConfigurationName = this.variables.resolve(this.runConfigurationName);
        configuration.setRunConfiguration(this.realRunConfigurationName);
        configuration.setLogLevel(this.determineLogLevel());
        this.parseParametersAndVariables(cmd, configuration, namedParams);
    }

    protected LogLevel determineLogLevel() {
        return LogLevel.lookupCode((String)this.variables.resolve(this.level));
    }

    protected boolean isPipeline() {
        if (StringUtils.isEmpty((String)this.filename)) {
            return false;
        }
        return this.filename.toLowerCase().endsWith(".hpl");
    }

    protected boolean isWorkflow() {
        if (StringUtils.isEmpty((String)this.filename)) {
            return false;
        }
        return this.filename.toLowerCase().endsWith(".hwf");
    }

    protected void parseParametersAndVariables(CommandLine cmd, IExecutionConfiguration configuration, INamedParameterDefinitions namedParams) {
        try {
            String[] availableParameters = namedParams.listParameters();
            if (this.parameters != null) {
                this.parametersSeparator = this.parametersSeparator == null ? "," : this.parametersSeparator;
                for (String parameter : this.parameters) {
                    for (String singleParameter : parameter.split(this.parametersSeparator)) {
                        String value;
                        String[] split = singleParameter.split("=", 2);
                        String key = split.length > 0 ? split[0] : null;
                        String string = value = split.length > 1 ? split[1] : null;
                        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        if (key == null) continue;
                        if (Const.indexOfString((String)key, (String[])availableParameters) < 0) {
                            configuration.getVariablesMap().put(key, value);
                            continue;
                        }
                        configuration.getParametersMap().put(key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of pipeline '" + this.filename + "'", (Throwable)e);
        }
    }

    protected void configureParametersAndVariables(CommandLine cmd, IExecutionConfiguration configuration, IVariables variables, INamedParameters namedParams) {
        variables.setVariables(configuration.getVariablesMap());
        for (String key : namedParams.listParameters()) {
            String value = variables.getVariable(key);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            try {
                namedParams.setParameterValue(key, value);
            }
            catch (UnknownParamException e) {
                throw new CommandLine.ParameterException(cmd, "Unable to set parameter '" + key + "'", (Throwable)e);
            }
        }
        for (String key : configuration.getParametersMap().keySet()) {
            String value = configuration.getParametersMap().get(key);
            try {
                namedParams.setParameterValue(key, value);
            }
            catch (UnknownParamException e) {
                throw new CommandLine.ParameterException(cmd, "Unable to set parameter '" + key + "'", (Throwable)e);
            }
        }
    }

    protected void validateOptions() {
        if (StringUtils.isEmpty((String)this.filename)) {
            throw new CommandLine.ParameterException(new CommandLine((Object)this), "A filename is needed to run a workflow or pipeline");
        }
    }

    protected void printOptions(IExecutionConfiguration configuration) {
        if (StringUtils.isNotEmpty((String)this.realFilename)) {
            this.log.logMinimal("OPTION: filename : '" + this.realFilename + "'");
        }
        if (StringUtils.isNotEmpty((String)configuration.getRunConfiguration())) {
            this.log.logMinimal("OPTION: run configuration : '" + configuration.getRunConfiguration() + "'");
        }
        this.log.logMinimal("OPTION: Logging level : " + configuration.getLogLevel().getDescription());
        if (!configuration.getVariablesMap().isEmpty()) {
            this.log.logMinimal("OPTION: Variables: ");
            for (String variable : configuration.getVariablesMap().keySet()) {
                this.log.logMinimal("  " + variable + " : '" + configuration.getVariablesMap().get(variable));
            }
        }
        if (!configuration.getParametersMap().isEmpty()) {
            this.log.logMinimal("OPTION: Parameters: ");
            for (String parameter : configuration.getParametersMap().keySet()) {
                this.log.logMinimal("OPTION:   " + parameter + " : '" + configuration.getParametersMap().get(parameter));
            }
        }
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    @Generated
    public boolean isVersionRequested() {
        return this.versionRequested;
    }

    @Generated
    public String getLogFile() {
        return this.logFile;
    }

    @Generated
    public String[] getParameters() {
        return this.parameters;
    }

    @Generated
    public String getParametersSeparator() {
        return this.parametersSeparator;
    }

    @Generated
    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    @Generated
    public String getStartActionName() {
        return this.startActionName;
    }

    @Generated
    public String getMetadataExportFile() {
        return this.metadataExportFile;
    }

    @Generated
    public boolean isPrintingOptions() {
        return this.printingOptions;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public String getRealRunConfigurationName() {
        return this.realRunConfigurationName;
    }

    @Generated
    public String getRealFilename() {
        return this.realFilename;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public ILogChannel getLog() {
        return this.log;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public boolean isFinishedWithoutError() {
        return this.finishedWithoutError;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setLevel(String level) {
        this.level = level;
    }

    @Generated
    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    @Generated
    public void setVersionRequested(boolean versionRequested) {
        this.versionRequested = versionRequested;
    }

    @Generated
    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @Generated
    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setParametersSeparator(String parametersSeparator) {
        this.parametersSeparator = parametersSeparator;
    }

    @Generated
    public void setSystemProperties(String[] systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    @Generated
    public void setStartActionName(String startActionName) {
        this.startActionName = startActionName;
    }

    @Generated
    public void setMetadataExportFile(String metadataExportFile) {
        this.metadataExportFile = metadataExportFile;
    }

    @Generated
    public void setPrintingOptions(boolean printingOptions) {
        this.printingOptions = printingOptions;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setRealRunConfigurationName(String realRunConfigurationName) {
        this.realRunConfigurationName = realRunConfigurationName;
    }

    @Generated
    public void setRealFilename(String realFilename) {
        this.realFilename = realFilename;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setLog(ILogChannel log) {
        this.log = log;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setFinishedWithoutError(boolean finishedWithoutError) {
        this.finishedWithoutError = finishedWithoutError;
    }
}

