/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.BaseSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;

@SearchableAnalyserPlugin(id="WorkflowMetaSearchAnalyser", name="Search in workflow metadata")
public class WorkflowMetaSearchAnalyser
extends BaseSearchableAnalyser<WorkflowMeta>
implements ISearchableAnalyser<WorkflowMeta> {
    public Class<WorkflowMeta> getSearchableClass() {
        return WorkflowMeta.class;
    }

    public List<ISearchResult> search(ISearchable<WorkflowMeta> searchable, ISearchQuery searchQuery) {
        WorkflowMeta workflowMeta = (WorkflowMeta)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "workflow name", workflowMeta.getName(), null);
        this.matchProperty(searchable, results, searchQuery, "workflow description", workflowMeta.getDescription(), null);
        for (String parameterName : workflowMeta.listParameters()) {
            String componentName = "workflow parameter " + parameterName;
            this.matchProperty(searchable, results, searchQuery, "parameter", parameterName, componentName);
            try {
                String defaultValue = workflowMeta.getParameterDefault(parameterName);
                String description = workflowMeta.getParameterDescription(parameterName);
                this.matchProperty(searchable, results, searchQuery, "parameter default", defaultValue, componentName);
                this.matchProperty(searchable, results, searchQuery, "parameter description", description, componentName);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error searching parameter " + parameterName, (Throwable)e);
            }
        }
        for (ActionMeta actionMeta : workflowMeta.getActions()) {
            String actionName = actionMeta.getName();
            this.matchProperty(searchable, results, searchQuery, "workflow action name", actionName, actionName);
            this.matchProperty(searchable, results, searchQuery, "workflow action description", actionMeta.getDescription(), actionName);
            IAction action = actionMeta.getAction();
            if (action == null) continue;
            String actionPluginId = action.getPluginId();
            if (actionPluginId != null) {
                this.matchProperty(searchable, results, searchQuery, "workflow action plugin ID", actionPluginId, actionName);
                IPlugin actionPlugin = PluginRegistry.getInstance().findPluginWithId(ActionPluginType.class, actionPluginId);
                if (actionPlugin != null) {
                    this.matchProperty(searchable, results, searchQuery, "workflow action plugin name", actionPlugin.getName(), actionName);
                }
            }
            this.matchObjectFields(searchable, results, searchQuery, action, "workflow action property", actionName);
        }
        for (NotePadMeta note : workflowMeta.getNotes()) {
            this.matchProperty(searchable, results, searchQuery, "workflow note", note.getNote(), null);
        }
        return results;
    }
}

