/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.util.List;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EnterPreviewRowsDialog
extends Dialog {
    private static final Class<?> PKG = EnterPreviewRowsDialog.class;
    private String transformName;
    private org.eclipse.swt.widgets.List wTransformList;
    private Shell shell;
    private List<String> transformNames;
    private List<IRowMeta> rowMetas;
    private List<List<Object[]>> rowDatas;
    private PropsUi props;

    public EnterPreviewRowsDialog(Shell parent, int style, List<String> transformNames, List<IRowMeta> rowMetas, List<List<Object[]>> rowBuffers) {
        super(parent, style);
        this.transformNames = transformNames;
        this.rowDatas = rowBuffers;
        this.rowMetas = rowMetas;
        this.props = PropsUi.getInstance();
    }

    public Object open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.PreviewTransform.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformList = new Label((Composite)this.shell, 0);
        wlTransformList.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.PreviewTransform.Message", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformList);
        FormData fdlTransformList = new FormData();
        fdlTransformList.left = new FormAttachment(0, 0);
        fdlTransformList.top = new FormAttachment(0, margin);
        wlTransformList.setLayoutData((Object)fdlTransformList);
        this.wTransformList = new org.eclipse.swt.widgets.List((Composite)this.shell, 19212);
        for (int i = 0; i < this.transformNames.size(); ++i) {
            this.wTransformList.add(this.transformNames.get(i));
        }
        this.wTransformList.select(0);
        PropsUi.setLook((Widget)this.wTransformList);
        FormData fdTransformList = new FormData();
        fdTransformList.left = new FormAttachment(middle, 0);
        fdTransformList.top = new FormAttachment(0, margin);
        fdTransformList.bottom = new FormAttachment(100, -60);
        fdTransformList.right = new FormAttachment(100, 0);
        this.wTransformList.setLayoutData((Object)fdTransformList);
        this.wTransformList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                EnterPreviewRowsDialog.this.show();
            }
        });
        Button wShow = new Button((Composite)this.shell, 8);
        wShow.setText(BaseMessages.getString(PKG, (String)"System.Button.Show", (String[])new String[0]));
        Button wClose = new Button((Composite)this.shell, 8);
        wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wShow, wClose}, margin, null);
        Listener lsShow = e -> this.show();
        Listener lsClose = e -> this.close();
        wShow.addListener(13, lsShow);
        wClose.addListener(13, lsClose);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterPreviewRowsDialog.this.close();
            }
        });
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        if (this.transformNames.size() == 1) {
            this.wTransformList.select(0);
            this.show();
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
    }

    private void close() {
        this.dispose();
    }

    private void show() {
        if (this.rowDatas.isEmpty()) {
            return;
        }
        int nr = this.wTransformList.getSelectionIndex();
        List<Object[]> buffer = this.rowDatas.get(nr);
        IRowMeta rowMeta = this.rowMetas.get(nr);
        String name = this.transformNames.get(nr);
        if (rowMeta != null && !Utils.isEmpty(buffer)) {
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, Variables.getADefaultVariableSpace(), 0, name, rowMeta, buffer);
            prd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.NoPreviewRowsFound.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.NoPreviewRowsFound.Message", (String[])new String[0]));
            mb.open();
        }
    }
}

