/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorData;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorMeta;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorParameters;

public class PipelineExecutor
extends BaseTransform<PipelineExecutorMeta, PipelineExecutorData> {
    private static final Class<?> PKG = PipelineExecutorMeta.class;

    public PipelineExecutor(TransformMeta transformMeta, PipelineExecutorMeta meta, PipelineExecutorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        try {
            PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
            Object[] row = this.getRow();
            if (row == null) {
                this.executePipeline(null);
                this.setOutputDone();
                return false;
            }
            ArrayList<String> incomingFieldValues = new ArrayList<String>();
            if (this.getInputRowMeta() != null) {
                for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
                    String fieldvalue = this.getInputRowMeta().getString(row, i);
                    incomingFieldValues.add(fieldvalue);
                }
            }
            if (this.first) {
                this.first = false;
                if (!((PipelineExecutorMeta)this.meta).isFilenameInField()) {
                    this.initOnFirstProcessingIteration();
                }
            }
            if (((PipelineExecutorMeta)this.meta).isFilenameInField()) {
                IRowMeta rowMeta = this.getInputRowMeta();
                int pos = rowMeta.indexOfValue(((PipelineExecutorMeta)this.meta).getFilenameField());
                String filename = (String)row[pos];
                if (pipelineExecutorData.prevFilename == null || !pipelineExecutorData.prevFilename.equals(filename)) {
                    this.logDetailed("Identified a new pipeline to execute: '" + filename + "'");
                    ((PipelineExecutorMeta)this.meta).setFilename(filename);
                    pipelineExecutorData.prevFilename = filename;
                    this.initPipeline(pipelineExecutorData);
                    this.initOnFirstProcessingIteration();
                }
            }
            IRowSet executorTransformOutputRowSet = pipelineExecutorData.getExecutorTransformOutputRowSet();
            if (pipelineExecutorData.getExecutorTransformOutputRowMeta() != null && executorTransformOutputRowSet != null) {
                this.putRowTo(pipelineExecutorData.getExecutorTransformOutputRowMeta(), row, executorTransformOutputRowSet);
            }
            if (pipelineExecutorData.groupSize < 0) {
                long now;
                if (pipelineExecutorData.groupFieldIndex >= 0) {
                    Object groupFieldData = row[pipelineExecutorData.groupFieldIndex];
                    if (pipelineExecutorData.prevGroupFieldData != null && pipelineExecutorData.groupFieldMeta.compare(pipelineExecutorData.prevGroupFieldData, groupFieldData) != 0) {
                        this.executePipeline(this.getLastIncomingFieldValues());
                    }
                    pipelineExecutorData.prevGroupFieldData = groupFieldData;
                } else if (pipelineExecutorData.groupTime > 0 && (now = System.currentTimeMillis()) - pipelineExecutorData.groupTimeStart >= (long)pipelineExecutorData.groupTime) {
                    this.executePipeline(incomingFieldValues);
                }
            }
            pipelineExecutorData.groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            if (pipelineExecutorData.groupSize > 0 && pipelineExecutorData.groupBuffer.size() >= pipelineExecutorData.groupSize) {
                this.executePipeline(incomingFieldValues);
            }
            return true;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"PipelineExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    private void initOnFirstProcessingIteration() throws HopException {
        PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
        pipelineExecutorData.setInputRowMeta(this.getInputRowMeta());
        pipelineExecutorData.setExecutionResultsOutputRowMeta((IRowMeta)new RowMeta());
        if (((PipelineExecutorMeta)this.meta).getExecutionResultTargetTransformMeta() != null) {
            ((PipelineExecutorMeta)this.meta).prepareExecutionResultsFields(pipelineExecutorData.getExecutionResultsOutputRowMeta(), ((PipelineExecutorMeta)this.meta).getExecutionResultTargetTransformMeta());
            pipelineExecutorData.setExecutionResultRowSet(this.findOutputRowSet(((PipelineExecutorMeta)this.meta).getExecutionResultTargetTransformMeta().getName()));
        }
        pipelineExecutorData.setResultFilesOutputRowMeta((IRowMeta)new RowMeta());
        if (((PipelineExecutorMeta)this.meta).getResultFilesTargetTransformMeta() != null) {
            ((PipelineExecutorMeta)this.meta).prepareExecutionResultsFileFields(pipelineExecutorData.getResultFilesOutputRowMeta(), ((PipelineExecutorMeta)this.meta).getResultFilesTargetTransformMeta());
            pipelineExecutorData.setResultFilesRowSet(this.findOutputRowSet(((PipelineExecutorMeta)this.meta).getResultFilesTargetTransformMeta().getName()));
        }
        pipelineExecutorData.setResultRowsOutputRowMeta((IRowMeta)new RowMeta());
        if (((PipelineExecutorMeta)this.meta).getOutputRowsSourceTransformMeta() != null) {
            ((PipelineExecutorMeta)this.meta).prepareResultsRowsFields(pipelineExecutorData.getResultRowsOutputRowMeta());
            pipelineExecutorData.setResultRowsRowSet(this.findOutputRowSet(((PipelineExecutorMeta)this.meta).getOutputRowsSourceTransformMeta().getName()));
        }
        if (((PipelineExecutorMeta)this.meta).getExecutorsOutputTransformMeta() != null) {
            pipelineExecutorData.setExecutorTransformOutputRowMeta(this.getInputRowMeta().clone());
            pipelineExecutorData.setExecutorTransformOutputRowSet(this.findOutputRowSet(((PipelineExecutorMeta)this.meta).getExecutorsOutputTransformMeta().getName()));
        }
        pipelineExecutorData.groupFieldIndex = -1;
        if (!Utils.isEmpty((CharSequence)pipelineExecutorData.groupField)) {
            pipelineExecutorData.groupFieldIndex = this.getInputRowMeta().indexOfValue(pipelineExecutorData.groupField);
            if (pipelineExecutorData.groupFieldIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"PipelineExecutor.Exception.GroupFieldNotFound", (String[])new String[]{pipelineExecutorData.groupField}));
            }
            pipelineExecutorData.groupFieldMeta = this.getInputRowMeta().getValueMeta(pipelineExecutorData.groupFieldIndex);
        }
    }

    private void executePipeline(List<String> incomingFieldValues) throws HopException {
        PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
        if (Utils.isEmpty(pipelineExecutorData.groupBuffer)) {
            return;
        }
        pipelineExecutorData.groupTimeStart = System.currentTimeMillis();
        if (this.first) {
            this.discardLogLines(pipelineExecutorData);
        }
        IPipelineEngine<PipelineMeta> executorPipeline = this.createInternalPipeline();
        pipelineExecutorData.setExecutorPipeline(executorPipeline);
        if (incomingFieldValues != null) {
            this.passParametersToPipeline(incomingFieldValues);
        } else {
            List<String> lastIncomingFieldValues = this.getLastIncomingFieldValues();
            this.passParametersToPipeline(!Utils.isEmpty(lastIncomingFieldValues) ? lastIncomingFieldValues : incomingFieldValues);
        }
        this.getPipeline().addActiveSubPipeline(this.getTransformName(), executorPipeline);
        Result result = new Result();
        result.setRows(pipelineExecutorData.groupBuffer);
        executorPipeline.setPreviousResult(result);
        try {
            executorPipeline.prepareExecution();
            executorPipeline.startThreads();
            executorPipeline.waitUntilFinished();
            result = executorPipeline.getResult();
        }
        catch (HopException e) {
            this.logError("An error occurred executing the pipeline: ", e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        this.collectPipelineResults(result);
        this.collectExecutionResults(result);
        this.collectExecutionResultFiles(result);
        pipelineExecutorData.groupBuffer.clear();
    }

    @VisibleForTesting
    void discardLogLines(PipelineExecutorData pipelineExecutorData) {
        IPipelineEngine<PipelineMeta> executorPipeline = pipelineExecutorData.getExecutorPipeline();
        if (executorPipeline != null) {
            HopLogStore.discardLines((String)executorPipeline.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(executorPipeline.getLogChannelId());
        }
    }

    @VisibleForTesting
    IPipelineEngine<PipelineMeta> createInternalPipeline() throws HopException {
        String runConfigurationName = this.resolve(((PipelineExecutorMeta)this.meta).getRunConfigurationName());
        IPipelineEngine executorPipeline = PipelineEngineFactory.createPipelineEngine((IVariables)this, (String)runConfigurationName, (IHopMetadataProvider)this.metadataProvider, (PipelineMeta)((PipelineExecutorData)this.getData()).getExecutorPipelineMeta());
        executorPipeline.setParentPipeline(this.getPipeline());
        executorPipeline.setParent((ILoggingObject)this);
        executorPipeline.setLogLevel(this.getLogLevel());
        executorPipeline.setInternalHopVariables((IVariables)this);
        executorPipeline.setPreview(this.getPipeline().isPreview());
        return executorPipeline;
    }

    @VisibleForTesting
    void passParametersToPipeline(List<String> incomingFieldValues) {
        if (incomingFieldValues == null) {
            incomingFieldValues = new ArrayList<String>();
        }
        List<PipelineExecutorParameters> parameters = ((PipelineExecutorMeta)this.meta).getParameters();
        LinkedHashMap<String, String> resolvingValuesMap = new LinkedHashMap<String, String>();
        ArrayList<String> resolvingParameters = new ArrayList<String>();
        ArrayList<String> fieldsToUse = new ArrayList<String>();
        ArrayList<String> staticInputs = new ArrayList<String>();
        for (PipelineExecutorParameters parameter : parameters) {
            resolvingParameters.add(parameter.getVariable());
            resolvingValuesMap.put(parameter.getVariable(), null);
            fieldsToUse.add(parameter.getField());
            staticInputs.add(parameter.getInput());
        }
        List<Object> incomingFields = new ArrayList();
        if (((PipelineExecutorData)this.data).getInputRowMeta() != null) {
            incomingFields = Arrays.asList(((PipelineExecutorData)this.data).getInputRowMeta().getFieldNames());
        }
        for (int i = 0; i < parameters.size(); ++i) {
            String currentVariableToUpdate = (String)resolvingValuesMap.keySet().toArray()[i];
            boolean hasIncomingFieldValues = !Utils.isEmpty(incomingFieldValues);
            try {
                if (i < fieldsToUse.size() && incomingFields.contains(fieldsToUse.get(i)) && hasIncomingFieldValues && !Utils.isEmpty((CharSequence)Const.trim((String)incomingFieldValues.get(incomingFields.indexOf(fieldsToUse.get(i)))))) {
                    resolvingValuesMap.put(currentVariableToUpdate, incomingFieldValues.get(incomingFields.indexOf(fieldsToUse.get(i))));
                    continue;
                }
                if (i < staticInputs.size() && !Utils.isEmpty((CharSequence)Const.trim((String)((String)staticInputs.get(i))))) {
                    resolvingValuesMap.put(currentVariableToUpdate, (String)staticInputs.get(i));
                    continue;
                }
                if (!Utils.isEmpty((CharSequence)Const.trim((String)((String)fieldsToUse.get(i))))) {
                    resolvingValuesMap.put(currentVariableToUpdate, "");
                    this.setVariable(parameters.get(i).getVariable(), (String)resolvingValuesMap.get(parameters.get(i).getVariable()));
                    continue;
                }
                if (!Utils.isEmpty((CharSequence)Const.trim((String)this.getVariable(parameters.get(i).getVariable()))) && ((PipelineExecutorMeta)this.meta).isInheritingAllVariables()) {
                    resolvingValuesMap.put(currentVariableToUpdate, this.getVariable(parameters.get(i).getVariable()));
                    continue;
                }
                resolvingValuesMap.put(currentVariableToUpdate, "");
                this.setVariable(parameters.get(i).getVariable(), (String)resolvingValuesMap.get(parameters.get(i).getVariable()));
                continue;
            }
            catch (Exception e) {
                resolvingValuesMap.put((String)resolvingValuesMap.keySet().toArray()[i], "");
                this.setVariable(parameters.get(i).getVariable(), (String)resolvingValuesMap.get(parameters.get(i).getVariable()));
            }
        }
        String[] inputFieldValues = new String[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            inputFieldValues[i] = (String)resolvingValuesMap.get(parameters.get(i).getVariable());
        }
        IPipelineEngine<PipelineMeta> pipeline = this.getExecutorPipeline();
        TransformWithMappingMeta.activateParams(pipeline, pipeline, (IVariables)this, (String[])pipeline.listParameters(), (String[])resolvingParameters.toArray(new String[0]), (String[])inputFieldValues, (boolean)((PipelineExecutorMeta)this.meta).isInheritingAllVariables());
    }

    @VisibleForTesting
    void collectPipelineResults(Result result) throws HopException {
        IRowSet pipelineResultsRowSet = ((PipelineExecutorData)this.getData()).getResultRowsRowSet();
        if (((PipelineExecutorMeta)this.meta).getOutputRowsSourceTransformMeta() != null && pipelineResultsRowSet != null) {
            for (RowMetaAndData metaAndData : result.getRows()) {
                this.putRowTo(metaAndData.getRowMeta(), metaAndData.getData(), pipelineResultsRowSet);
            }
        }
    }

    @VisibleForTesting
    void collectExecutionResults(Result result) throws HopException {
        IRowSet executionResultsRowSet = ((PipelineExecutorData)this.getData()).getExecutionResultRowSet();
        if (((PipelineExecutorMeta)this.meta).getExecutionResultTargetTransformMeta() != null && executionResultsRowSet != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)((PipelineExecutorData)this.getData()).getExecutionResultsOutputRowMeta().size());
            int idx = 0;
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - ((PipelineExecutorData)this.getData()).groupTimeStart;
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionResultField())) {
                outputRow[idx++] = result.isResult();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLogTextField())) {
                String channelId = ((PipelineExecutorData)this.getData()).getExecutorPipeline().getLogChannelId();
                String logText = HopLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getExecutionLogChannelIdField())) {
                outputRow[idx++] = ((PipelineExecutorData)this.getData()).getExecutorPipeline().getLogChannelId();
            }
            this.putRowTo(((PipelineExecutorData)this.getData()).getExecutionResultsOutputRowMeta(), outputRow, executionResultsRowSet);
        }
    }

    @VisibleForTesting
    void collectExecutionResultFiles(Result result) throws HopException {
        IRowSet resultFilesRowSet = ((PipelineExecutorData)this.getData()).getResultFilesRowSet();
        if (((PipelineExecutorMeta)this.meta).getResultFilesTargetTransformMeta() != null && result.getResultFilesList() != null && resultFilesRowSet != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                Object[] targetRow = RowDataUtil.allocateRowData((int)((PipelineExecutorData)this.getData()).getResultFilesOutputRowMeta().size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(((PipelineExecutorData)this.getData()).getResultFilesOutputRowMeta(), targetRow, resultFilesRowSet);
            }
        }
    }

    public boolean init() {
        PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
        boolean transformSuccessfullyInitialized = super.init();
        if (transformSuccessfullyInitialized) {
            pipelineExecutorData.groupBuffer = new ArrayList<RowMetaAndData>();
            pipelineExecutorData.groupSize = !Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getGroupSize()) ? Const.toInt((String)this.resolve(((PipelineExecutorMeta)this.meta).getGroupSize()), (int)-1) : -1;
            pipelineExecutorData.groupTime = !Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getGroupTime()) ? Const.toInt((String)this.resolve(((PipelineExecutorMeta)this.meta).getGroupTime()), (int)-1) : -1;
            if (!Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getGroupField())) {
                pipelineExecutorData.groupField = this.resolve(((PipelineExecutorMeta)this.meta).getGroupField());
            }
            try {
                if (!((PipelineExecutorMeta)this.meta).isFilenameInField() && Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getFilename()) || ((PipelineExecutorMeta)this.meta).isFilenameInField() && Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getFilenameField())) {
                    this.logError("No pipeline filename given either in path or in a field!");
                    transformSuccessfullyInitialized = false;
                } else if (!((PipelineExecutorMeta)this.meta).isFilenameInField() && !Utils.isEmpty((CharSequence)((PipelineExecutorMeta)this.meta).getFilename())) {
                    transformSuccessfullyInitialized = this.initPipeline(pipelineExecutorData);
                }
            }
            catch (Exception e) {
                this.logError("Unable to load the pipeline executor because of an error : ", e);
            }
            return transformSuccessfullyInitialized;
        }
        return transformSuccessfullyInitialized;
    }

    private boolean initPipeline(PipelineExecutorData pipelineExecutorData) throws HopException {
        pipelineExecutorData.setExecutorPipelineMeta(this.loadExecutorPipelineMeta());
        if (pipelineExecutorData.getExecutorPipelineMeta() != null) {
            pipelineExecutorData.groupTimeStart = System.currentTimeMillis();
            return true;
        }
        this.logError("No valid pipeline was specified nor loaded!");
        return false;
    }

    @VisibleForTesting
    PipelineMeta loadExecutorPipelineMeta() throws HopException {
        return TransformWithMappingMeta.loadMappingMeta((TransformWithMappingMeta)((TransformWithMappingMeta)this.meta), (IHopMetadataProvider)this.metadataProvider, (IVariables)this);
    }

    public void dispose() {
        PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
        pipelineExecutorData.groupBuffer = null;
        super.dispose();
    }

    public void stopRunning() throws HopException {
        if (((PipelineExecutorData)this.getData()).getExecutorPipeline() != null) {
            ((PipelineExecutorData)this.getData()).getExecutorPipeline().stopAll();
        }
    }

    public void stopAll() {
        if (((PipelineExecutorData)this.getData()).getExecutorPipeline() != null) {
            ((PipelineExecutorData)this.getData()).getExecutorPipeline().stopAll();
        }
        super.stopAll();
    }

    public IPipelineEngine<PipelineMeta> getExecutorPipeline() {
        return ((PipelineExecutorData)this.getData()).getExecutorPipeline();
    }

    protected List<String> getLastIncomingFieldValues() {
        PipelineExecutorData pipelineExecutorData = (PipelineExecutorData)this.getData();
        ArrayList<String> lastIncomingFieldValues = new ArrayList<String>();
        if (pipelineExecutorData == null || pipelineExecutorData.groupBuffer.isEmpty()) {
            return null;
        }
        int lastIncomingFieldIndex = pipelineExecutorData.groupBuffer.size() - 1;
        ArrayList<Object> lastGroupBufferData = new ArrayList<Object>(Arrays.asList(pipelineExecutorData.groupBuffer.get(lastIncomingFieldIndex).getData()));
        lastGroupBufferData.removeAll(Collections.singleton(null));
        for (int i = 0; i < lastGroupBufferData.size(); ++i) {
            lastIncomingFieldValues.add(lastGroupBufferData.get(i).toString());
        }
        return lastIncomingFieldValues;
    }
}

