/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DisallowedDirectories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.FSDiskFullWriteError;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSErrorHandler;
import org.apache.cassandra.io.FSNoDiskAvailableForWriteError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFSErrorHandler
implements FSErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFSErrorHandler.class);
    private static final Set<Class<?>> exceptionsSkippingDataRemoval = ImmutableSet.of(OutOfMemoryError.class);

    @Override
    public void handleCorruptSSTable(CorruptSSTableException e) {
        if (!StorageService.instance.isDaemonSetupCompleted()) {
            this.handleStartupFSError(e);
        }
        switch (DatabaseDescriptor.getDiskFailurePolicy()) {
            case die: 
            case stop_paranoid: {
                logger.error("Stopping transports as disk_failure_policy is " + (Object)((Object)DatabaseDescriptor.getDiskFailurePolicy()));
                StorageService.instance.stopTransports();
            }
        }
    }

    @Override
    public void handleFSError(FSError e) {
        if (!StorageService.instance.isDaemonSetupCompleted()) {
            this.handleStartupFSError(e);
        }
        switch (DatabaseDescriptor.getDiskFailurePolicy()) {
            case die: 
            case stop_paranoid: 
            case stop: {
                logger.error("Stopping transports as disk_failure_policy is " + (Object)((Object)DatabaseDescriptor.getDiskFailurePolicy()));
                StorageService.instance.stopTransports();
                break;
            }
            case best_effort: {
                File directory;
                if (e instanceof FSDiskFullWriteError || e instanceof FSNoDiskAvailableForWriteError) {
                    logger.error("Stopping transports: " + e.getCause().getMessage());
                    StorageService.instance.stopTransports();
                }
                DisallowedDirectories.maybeMarkUnwritable(new File(e.path));
                if (!(e instanceof FSReadError) || !this.shouldMaybeRemoveData(e) || (directory = DisallowedDirectories.maybeMarkUnreadable(new File(e.path))) == null) break;
                Keyspace.removeUnreadableSSTables(directory);
                break;
            }
            case ignore: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private boolean shouldMaybeRemoveData(Throwable error) {
        for (Throwable t = error; t != null; t = t.getCause()) {
            for (Class<?> c : exceptionsSkippingDataRemoval) {
                if (!c.isAssignableFrom(t.getClass())) continue;
                return false;
            }
            for (Throwable s : t.getSuppressed()) {
                for (Class<?> c : exceptionsSkippingDataRemoval) {
                    if (!c.isAssignableFrom(s.getClass())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void handleStartupFSError(Throwable t) {
        switch (DatabaseDescriptor.getDiskFailurePolicy()) {
            case die: 
            case stop_paranoid: 
            case stop: {
                logger.error("Exiting forcefully due to file system exception on startup, disk failure policy \"{}\"", (Object)DatabaseDescriptor.getDiskFailurePolicy(), (Object)t);
                JVMStabilityInspector.killCurrentJVM(t, true);
                break;
            }
        }
    }
}

