/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.postpass;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceGroupOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.RuntimeComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeSerializerFactory;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.CompilerPostPassException;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plan.WorksetPlanNode;
import org.apache.flink.optimizer.postpass.OptimizerPostPass;
import org.apache.flink.optimizer.util.NoOpUnaryUdfOp;
import org.apache.flink.runtime.operators.DriverStrategy;

public class JavaApiPostPass
implements OptimizerPostPass {
    private final Set<PlanNode> alreadyDone = new HashSet<PlanNode>();
    private ExecutionConfig executionConfig = null;

    @Override
    public void postPass(OptimizedPlan plan) {
        this.executionConfig = plan.getOriginalPlan().getExecutionConfig();
        for (SinkPlanNode sink : plan.getDataSinks()) {
            this.traverse(sink);
        }
    }

    protected void traverse(PlanNode node) {
        if (!this.alreadyDone.add(node)) {
            return;
        }
        if (node instanceof SinkPlanNode) {
            SinkPlanNode sn = (SinkPlanNode)node;
            Channel inchannel = sn.getInput();
            this.traverseChannel(inchannel);
        } else if (node instanceof SourcePlanNode) {
            TypeInformation typeInfo = JavaApiPostPass.getTypeInfoFromSource((SourcePlanNode)node);
            ((SourcePlanNode)node).setSerializer(this.createSerializer(typeInfo));
        } else if (node instanceof BulkIterationPlanNode) {
            BulkIterationPlanNode iterationNode = (BulkIterationPlanNode)node;
            if (iterationNode.getRootOfStepFunction() instanceof NAryUnionPlanNode) {
                throw new CompilerException("Optimizer cannot compile an iteration step function where next partial solution is created by a Union node.");
            }
            if (iterationNode.getRootOfTerminationCriterion() != null) {
                SingleInputPlanNode addMapper = (SingleInputPlanNode)iterationNode.getRootOfTerminationCriterion();
                this.traverseChannel(addMapper.getInput());
            }
            BulkIterationBase operator = (BulkIterationBase)iterationNode.getProgramOperator();
            iterationNode.setSerializerForIterationChannel(this.createSerializer(operator.getOperatorInfo().getOutputType()));
            this.traverseChannel(iterationNode.getInput());
            this.traverse(iterationNode.getRootOfStepFunction());
        } else if (node instanceof WorksetIterationPlanNode) {
            WorksetIterationPlanNode iterationNode = (WorksetIterationPlanNode)node;
            if (iterationNode.getNextWorkSetPlanNode() instanceof NAryUnionPlanNode) {
                throw new CompilerException("Optimizer cannot compile a workset iteration step function where the next workset is produced by a Union node.");
            }
            if (iterationNode.getSolutionSetDeltaPlanNode() instanceof NAryUnionPlanNode) {
                throw new CompilerException("Optimizer cannot compile a workset iteration step function where the solution set delta is produced by a Union node.");
            }
            DeltaIterationBase operator = (DeltaIterationBase)iterationNode.getProgramOperator();
            iterationNode.setSolutionSetSerializer(this.createSerializer(operator.getOperatorInfo().getFirstInputType()));
            iterationNode.setWorksetSerializer(this.createSerializer(operator.getOperatorInfo().getSecondInputType()));
            iterationNode.setSolutionSetComparator(this.createComparator(operator.getOperatorInfo().getFirstInputType(), iterationNode.getSolutionSetKeyFields(), JavaApiPostPass.getSortOrders(iterationNode.getSolutionSetKeyFields(), null)));
            this.traverseChannel(iterationNode.getInput1());
            this.traverseChannel(iterationNode.getInput2());
            this.traverse(iterationNode.getSolutionSetDeltaPlanNode());
            this.traverse(iterationNode.getNextWorkSetPlanNode());
        } else if (node instanceof SingleInputPlanNode) {
            SingleInputPlanNode sn = (SingleInputPlanNode)node;
            if (!(sn.getOptimizerNode().getOperator() instanceof SingleInputOperator)) {
                if (sn.getOptimizerNode().getOperator() instanceof NoOpUnaryUdfOp) {
                    this.traverseChannel(sn.getInput());
                    return;
                }
                throw new RuntimeException("Wrong operator type found in post pass.");
            }
            SingleInputOperator singleInputOperator = (SingleInputOperator)sn.getOptimizerNode().getOperator();
            for (int i = 0; i < sn.getDriverStrategy().getNumRequiredComparators(); ++i) {
                sn.setComparator(this.createComparator(singleInputOperator.getOperatorInfo().getInputType(), sn.getKeys(i), JavaApiPostPass.getSortOrders(sn.getKeys(i), sn.getSortOrders(i))), i);
            }
            this.traverseChannel(sn.getInput());
            for (Channel channel : sn.getBroadcastInputs()) {
                this.traverseChannel(channel);
            }
        } else if (node instanceof DualInputPlanNode) {
            DualInputPlanNode dn = (DualInputPlanNode)node;
            if (!(dn.getOptimizerNode().getOperator() instanceof DualInputOperator)) {
                throw new RuntimeException("Wrong operator type found in post pass.");
            }
            DualInputOperator dualInputOperator = (DualInputOperator)dn.getOptimizerNode().getOperator();
            if (dn.getDriverStrategy().getNumRequiredComparators() > 0) {
                dn.setComparator1(this.createComparator(dualInputOperator.getOperatorInfo().getFirstInputType(), dn.getKeysForInput1(), JavaApiPostPass.getSortOrders(dn.getKeysForInput1(), dn.getSortOrders())));
                dn.setComparator2(this.createComparator(dualInputOperator.getOperatorInfo().getSecondInputType(), dn.getKeysForInput2(), JavaApiPostPass.getSortOrders(dn.getKeysForInput2(), dn.getSortOrders())));
                dn.setPairComparator(JavaApiPostPass.createPairComparator(dualInputOperator.getOperatorInfo().getFirstInputType(), dualInputOperator.getOperatorInfo().getSecondInputType()));
            }
            this.traverseChannel(dn.getInput1());
            this.traverseChannel(dn.getInput2());
            for (Channel channel : dn.getBroadcastInputs()) {
                this.traverseChannel(channel);
            }
        } else if (!(node instanceof BulkPartialSolutionPlanNode || node instanceof SolutionSetPlanNode || node instanceof WorksetPlanNode)) {
            if (node instanceof NAryUnionPlanNode) {
                for (Channel channel : node.getInputs()) {
                    this.traverseChannel(channel);
                }
            } else {
                throw new CompilerPostPassException("Unknown node type encountered: " + node.getClass().getName());
            }
        }
    }

    private void traverseChannel(Channel channel) {
        PlanNode source = channel.getSource();
        Operator<?> javaOp = source.getProgramOperator();
        TypeInformation type = javaOp.getOperatorInfo().getOutputType();
        if (javaOp instanceof GroupReduceOperatorBase && (source.getDriverStrategy() == DriverStrategy.SORTED_GROUP_COMBINE || source.getDriverStrategy() == DriverStrategy.ALL_GROUP_REDUCE_COMBINE)) {
            GroupReduceOperatorBase groupNode = (GroupReduceOperatorBase)javaOp;
            type = groupNode.getInput().getOperatorInfo().getOutputType();
        } else if (javaOp instanceof PlanUnwrappingReduceGroupOperator && source.getDriverStrategy().equals((Object)DriverStrategy.SORTED_GROUP_COMBINE)) {
            PlanUnwrappingReduceGroupOperator groupNode = (PlanUnwrappingReduceGroupOperator)javaOp;
            type = groupNode.getInput().getOperatorInfo().getOutputType();
        }
        channel.setSerializer(this.createSerializer(type));
        if (channel.getShipStrategy().requiresComparator()) {
            channel.setShipStrategyComparator(this.createComparator(type, channel.getShipStrategyKeys(), JavaApiPostPass.getSortOrders(channel.getShipStrategyKeys(), channel.getShipStrategySortOrder())));
        }
        if (channel.getLocalStrategy().requiresComparator()) {
            channel.setLocalStrategyComparator(this.createComparator(type, channel.getLocalStrategyKeys(), JavaApiPostPass.getSortOrders(channel.getLocalStrategyKeys(), channel.getLocalStrategySortOrder())));
        }
        this.traverse(channel.getSource());
    }

    private static <T> TypeInformation<T> getTypeInfoFromSource(SourcePlanNode node) {
        Operator<?> op = node.getOptimizerNode().getOperator();
        if (op instanceof GenericDataSourceBase) {
            return ((GenericDataSourceBase)op).getOperatorInfo().getOutputType();
        }
        throw new RuntimeException("Wrong operator type found in post pass.");
    }

    private <T> TypeSerializerFactory<?> createSerializer(TypeInformation<T> typeInfo) {
        TypeSerializer serializer = typeInfo.createSerializer(this.executionConfig.getSerializerConfig());
        return new RuntimeSerializerFactory(serializer, typeInfo.getTypeClass());
    }

    private <T> TypeComparatorFactory<?> createComparator(TypeInformation<T> typeInfo, FieldList keys, boolean[] sortOrder) {
        TypeComparator comparator;
        if (typeInfo instanceof CompositeType) {
            comparator = ((CompositeType)typeInfo).createComparator(keys.toArray(), sortOrder, 0, this.executionConfig);
        } else if (typeInfo instanceof AtomicType) {
            comparator = ((AtomicType)typeInfo).createComparator(sortOrder[0], this.executionConfig);
        } else {
            throw new RuntimeException("Unrecognized type: " + typeInfo);
        }
        return new RuntimeComparatorFactory(comparator);
    }

    private static <T1 extends Tuple, T2 extends Tuple> TypePairComparatorFactory<T1, T2> createPairComparator(TypeInformation<?> typeInfo1, TypeInformation<?> typeInfo2) {
        return new RuntimePairComparatorFactory();
    }

    private static final boolean[] getSortOrders(FieldList keys, boolean[] orders) {
        if (orders == null) {
            orders = new boolean[keys.size()];
            Arrays.fill(orders, true);
        }
        return orders;
    }
}

