/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.project;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ProjectDialog
extends Dialog {
    private static final Class<?> PKG = ProjectDialog.class;
    public static final String CONST_PROJECT = "Project '";
    private final Project project;
    private final ProjectConfig projectConfig;
    private String returnValue;
    private Shell shell;
    private final PropsUi props;
    private Text wName;
    private TextVar wHome;
    private ComboVar wParentProject;
    private TextVar wConfigFile;
    private Text wDescription;
    private Text wCompany;
    private Text wDepartment;
    private TextVar wMetadataBaseFolder;
    private TextVar wUnitTestsBasePath;
    private TextVar wDataSetCsvFolder;
    private Button wEnforceHomeExecution;
    private TableView wVariables;
    private final IVariables variables;
    private boolean needingProjectRefresh;
    private final Boolean editMode;

    public ProjectDialog(Shell parent, Project project, ProjectConfig projectConfig, IVariables variables, Boolean editMode) {
        super(parent, 67696);
        this.project = project;
        this.projectConfig = projectConfig;
        this.editMode = editMode;
        this.props = PropsUi.getInstance();
        this.variables = new Variables();
        this.variables.initializeFrom(null);
        try {
            project.modifyVariables(variables, projectConfig, Collections.emptyList(), null);
        }
        catch (Exception e) {
            new ErrorDialog(parent, BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectDefinitionError.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectDefinitionError.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        PropsUi.setLook((Widget)this.shell);
        int margin = PropsUi.getMargin() + 2;
        int middle = this.props.getMiddlePct();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Shell.Name", (String[])new String[0]));
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, event -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, event -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)(margin * 3), null);
        ScrolledComposite scroll = new ScrolledComposite((Composite)this.shell, 512);
        scroll.setLayout((Layout)new FillLayout());
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setBackground(this.shell.getDisplay().getSystemColor(2));
        PropsUi.setLook((Widget)scroll);
        this.shell.setLayoutData((Object)scroll);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)wOk, 0);
        scroll.setLayoutData((Object)fd);
        Composite comp = new Composite((Composite)scroll, 0);
        comp.setLayout((Layout)new FormLayout());
        PropsUi.setLook((Widget)comp);
        Label wlName = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.ProjectName", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        fdlName.top = new FormAttachment(0, margin * 2);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(comp, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(99, 0);
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlHome = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlHome);
        wlHome.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.HomeFolder", (String[])new String[0]));
        FormData fdlHome = new FormData();
        fdlHome.left = new FormAttachment(0, 0);
        fdlHome.right = new FormAttachment(middle, 0);
        fdlHome.top = new FormAttachment((Control)lastControl, margin);
        wlHome.setLayoutData((Object)fdlHome);
        Button wbHome = new Button(comp, 8);
        PropsUi.setLook((Widget)wbHome);
        wbHome.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Button.Browse", (String[])new String[0]));
        FormData fdbHome = new FormData();
        fdbHome.right = new FormAttachment(99, 0);
        fdbHome.top = new FormAttachment((Control)wlHome, 0, 0x1000000);
        wbHome.setLayoutData((Object)fdbHome);
        wbHome.addListener(13, this::browseHomeFolder);
        this.wHome = new TextVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wHome);
        FormData fdHome = new FormData();
        fdHome.left = new FormAttachment(middle, margin);
        fdHome.right = new FormAttachment((Control)wbHome, -margin);
        fdHome.top = new FormAttachment((Control)wlHome, 0, 0x1000000);
        this.wHome.setLayoutData((Object)fdHome);
        lastControl = this.wHome;
        Label wlConfigFile = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlConfigFile);
        wlConfigFile.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.ConfigurationFile", (String[])new String[0]));
        FormData fdlConfigFile = new FormData();
        fdlConfigFile.left = new FormAttachment(0, 0);
        fdlConfigFile.right = new FormAttachment(middle, 0);
        fdlConfigFile.top = new FormAttachment((Control)lastControl, margin);
        wlConfigFile.setLayoutData((Object)fdlConfigFile);
        Button wbConfigFile = new Button(comp, 8);
        PropsUi.setLook((Widget)wbConfigFile);
        wbConfigFile.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Button.Browse", (String[])new String[0]));
        FormData fdbConfigFile = new FormData();
        fdbConfigFile.right = new FormAttachment(99, 0);
        fdbConfigFile.top = new FormAttachment((Control)wlConfigFile, 0, 0x1000000);
        wbConfigFile.setLayoutData((Object)fdbConfigFile);
        wbConfigFile.addListener(13, this::browseConfigFolder);
        this.wConfigFile = new TextVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wConfigFile);
        FormData fdConfigFile = new FormData();
        fdConfigFile.left = new FormAttachment(middle, margin);
        fdConfigFile.right = new FormAttachment((Control)wbConfigFile, -margin);
        fdConfigFile.top = new FormAttachment((Control)wlConfigFile, 0, 0x1000000);
        this.wConfigFile.setLayoutData((Object)fdConfigFile);
        lastControl = this.wConfigFile;
        Label wlParentProject = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlParentProject);
        wlParentProject.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.ParentProject", (String[])new String[0]));
        FormData fdlParentProject = new FormData();
        fdlParentProject.left = new FormAttachment(0, 0);
        fdlParentProject.right = new FormAttachment(middle, 0);
        fdlParentProject.top = new FormAttachment((Control)lastControl, margin);
        wlParentProject.setLayoutData((Object)fdlParentProject);
        this.wParentProject = new ComboVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wParentProject);
        FormData fdParentProject = new FormData();
        fdParentProject.left = new FormAttachment(middle, margin);
        fdParentProject.right = new FormAttachment(99, 0);
        fdParentProject.top = new FormAttachment((Control)wlParentProject, 0, 0x1000000);
        this.wParentProject.setLayoutData((Object)fdParentProject);
        lastControl = this.wParentProject;
        Label wlDescription = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.Description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, 0);
        fdlDescription.top = new FormAttachment((Control)lastControl, margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(comp, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.left = new FormAttachment(middle, margin);
        fdDescription.right = new FormAttachment(99, 0);
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlCompany = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlCompany);
        wlCompany.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.Company", (String[])new String[0]));
        FormData fdlCompany = new FormData();
        fdlCompany.left = new FormAttachment(0, 0);
        fdlCompany.right = new FormAttachment(middle, 0);
        fdlCompany.top = new FormAttachment((Control)lastControl, margin);
        wlCompany.setLayoutData((Object)fdlCompany);
        this.wCompany = new Text(comp, 18436);
        PropsUi.setLook((Widget)this.wCompany);
        FormData fdCompany = new FormData();
        fdCompany.left = new FormAttachment(middle, margin);
        fdCompany.right = new FormAttachment(99, 0);
        fdCompany.top = new FormAttachment((Control)wlCompany, 0, 0x1000000);
        this.wCompany.setLayoutData((Object)fdCompany);
        lastControl = this.wCompany;
        Label wlDepartment = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlDepartment);
        wlDepartment.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.Department", (String[])new String[0]));
        FormData fdlDepartment = new FormData();
        fdlDepartment.left = new FormAttachment(0, 0);
        fdlDepartment.right = new FormAttachment(middle, 0);
        fdlDepartment.top = new FormAttachment((Control)lastControl, margin);
        wlDepartment.setLayoutData((Object)fdlDepartment);
        this.wDepartment = new Text(comp, 18436);
        PropsUi.setLook((Widget)this.wDepartment);
        FormData fdDepartment = new FormData();
        fdDepartment.left = new FormAttachment(middle, margin);
        fdDepartment.right = new FormAttachment(99, 0);
        fdDepartment.top = new FormAttachment((Control)wlDepartment, 0, 0x1000000);
        this.wDepartment.setLayoutData((Object)fdDepartment);
        lastControl = this.wDepartment;
        Label wlMetadataBaseFolder = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlMetadataBaseFolder);
        wlMetadataBaseFolder.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.MetadataBaseFolder", (String[])new String[0]));
        FormData fdlMetadataBaseFolder = new FormData();
        fdlMetadataBaseFolder.left = new FormAttachment(0, 0);
        fdlMetadataBaseFolder.right = new FormAttachment(middle, 0);
        fdlMetadataBaseFolder.top = new FormAttachment((Control)lastControl, margin);
        wlMetadataBaseFolder.setLayoutData((Object)fdlMetadataBaseFolder);
        this.wMetadataBaseFolder = new TextVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wMetadataBaseFolder);
        FormData fdMetadataBaseFolder = new FormData();
        fdMetadataBaseFolder.left = new FormAttachment(middle, margin);
        fdMetadataBaseFolder.right = new FormAttachment(99, 0);
        fdMetadataBaseFolder.top = new FormAttachment((Control)wlMetadataBaseFolder, 0, 0x1000000);
        this.wMetadataBaseFolder.setLayoutData((Object)fdMetadataBaseFolder);
        this.wMetadataBaseFolder.addModifyListener(e -> this.updateIVariables());
        lastControl = this.wMetadataBaseFolder;
        Label wlUnitTestsBasePath = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlUnitTestsBasePath);
        wlUnitTestsBasePath.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.UnitTestBaseFolder", (String[])new String[0]));
        FormData fdlUnitTestsBasePath = new FormData();
        fdlUnitTestsBasePath.left = new FormAttachment(0, 0);
        fdlUnitTestsBasePath.right = new FormAttachment(middle, 0);
        fdlUnitTestsBasePath.top = new FormAttachment((Control)lastControl, margin);
        wlUnitTestsBasePath.setLayoutData((Object)fdlUnitTestsBasePath);
        this.wUnitTestsBasePath = new TextVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wUnitTestsBasePath);
        FormData fdUnitTestsBasePath = new FormData();
        fdUnitTestsBasePath.left = new FormAttachment(middle, margin);
        fdUnitTestsBasePath.right = new FormAttachment(99, 0);
        fdUnitTestsBasePath.top = new FormAttachment((Control)wlUnitTestsBasePath, 0, 0x1000000);
        this.wUnitTestsBasePath.setLayoutData((Object)fdUnitTestsBasePath);
        this.wUnitTestsBasePath.addModifyListener(e -> this.updateIVariables());
        lastControl = this.wUnitTestsBasePath;
        Label wlDataSetCsvFolder = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlDataSetCsvFolder);
        wlDataSetCsvFolder.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.DatasetCSVFolder", (String[])new String[0]));
        FormData fdlDataSetCsvFolder = new FormData();
        fdlDataSetCsvFolder.left = new FormAttachment(0, 0);
        fdlDataSetCsvFolder.right = new FormAttachment(middle, 0);
        fdlDataSetCsvFolder.top = new FormAttachment((Control)lastControl, margin);
        wlDataSetCsvFolder.setLayoutData((Object)fdlDataSetCsvFolder);
        this.wDataSetCsvFolder = new TextVar(this.variables, comp, 18436);
        PropsUi.setLook((Widget)this.wDataSetCsvFolder);
        FormData fdDataSetCsvFolder = new FormData();
        fdDataSetCsvFolder.left = new FormAttachment(middle, margin);
        fdDataSetCsvFolder.right = new FormAttachment(99, 0);
        fdDataSetCsvFolder.top = new FormAttachment((Control)wlDataSetCsvFolder, 0, 0x1000000);
        this.wDataSetCsvFolder.setLayoutData((Object)fdDataSetCsvFolder);
        this.wDataSetCsvFolder.addModifyListener(e -> this.updateIVariables());
        lastControl = this.wDataSetCsvFolder;
        Label wlEnforceHomeExecution = new Label(comp, 131072);
        PropsUi.setLook((Widget)wlEnforceHomeExecution);
        wlEnforceHomeExecution.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Label.EnforceExecutionInHome", (String[])new String[0]));
        FormData fdlEnforceHomeExecution = new FormData();
        fdlEnforceHomeExecution.left = new FormAttachment(0, 0);
        fdlEnforceHomeExecution.right = new FormAttachment(middle, 0);
        fdlEnforceHomeExecution.top = new FormAttachment((Control)lastControl, margin);
        wlEnforceHomeExecution.setLayoutData((Object)fdlEnforceHomeExecution);
        this.wEnforceHomeExecution = new Button(comp, 16416);
        PropsUi.setLook((Widget)this.wEnforceHomeExecution);
        FormData fdEnforceHomeExecution = new FormData();
        fdEnforceHomeExecution.left = new FormAttachment(middle, margin);
        fdEnforceHomeExecution.right = new FormAttachment(99, 0);
        fdEnforceHomeExecution.top = new FormAttachment((Control)wlEnforceHomeExecution, 0, 0x1000000);
        this.wEnforceHomeExecution.setLayoutData((Object)fdEnforceHomeExecution);
        lastControl = wlEnforceHomeExecution;
        Label wlVariables = new Label(comp, 16384);
        PropsUi.setLook((Widget)wlVariables);
        wlVariables.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.Group.Label.ProjectVariablesToSet", (String[])new String[0]));
        FormData fdlVariables = new FormData();
        fdlVariables.left = new FormAttachment(1, 0);
        fdlVariables.right = new FormAttachment(99, 0);
        fdlVariables.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlVariables.setLayoutData((Object)fdlVariables);
        ColumnInfo[] columnInfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ProjectDialog.DetailTable.Label.VariableName", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ProjectDialog.DetailTable.Label.VariableValue", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ProjectDialog.DetailTable.Label.VariableDescription", (String[])new String[0]), 1, false, false)};
        columnInfo[0].setUsingVariables(true);
        columnInfo[1].setUsingVariables(true);
        this.wVariables = new TableView((IVariables)new Variables(), comp, 2048, columnInfo, Math.max(this.project.getDescribedVariables().size(), 3), null, this.props);
        PropsUi.setLook((Widget)this.wVariables);
        FormData fdVariables = new FormData();
        fdVariables.left = new FormAttachment(1, 0);
        fdVariables.right = new FormAttachment(99, 0);
        fdVariables.top = new FormAttachment((Control)wlVariables, margin);
        fdVariables.bottom = new FormAttachment(100, -margin * 4);
        fdVariables.width = 300;
        this.wVariables.setLayoutData((Object)fdVariables);
        this.wVariables.addModifyListener(e -> {
            this.needingProjectRefresh = true;
        });
        this.wParentProject.addModifyListener(e -> {
            this.needingProjectRefresh = true;
        });
        this.wHome.addModifyListener(e -> {
            this.needingProjectRefresh = true;
        });
        this.getData();
        comp.pack();
        scroll.setContent((Control)comp);
        scroll.setMinSize(comp.computeSize(-1, -1));
        this.shell.setMinimumSize(comp.getBounds().width, 200);
        this.shell.setDefaultButton(wOk);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.returnValue;
    }

    private void browseHomeFolder(Event event) {
        String homeFolder = BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wHome, (IVariables)this.variables);
        try {
            if (homeFolder != null && StringUtils.isEmpty((String)this.wName.getText())) {
                FileObject file = HopVfs.getFileObject((String)homeFolder);
                this.wName.setText(Const.NVL((String)file.getName().getBaseName(), (String)""));
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting base filename of home folder: " + homeFolder, (Throwable)e);
        }
    }

    private void browseConfigFolder(Event event) {
        String configDir;
        Object configFileStr = null;
        String rootPath = this.wHome.getText();
        File configFile = new File(this.wHome.getText() + File.separator + "config" + File.separator + "project-config.json");
        this.wConfigFile.setText(rootPath);
        configFileStr = configFile.exists() ? BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wConfigFile, (IVariables)this.variables, (String[])new String[]{"*.json", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"ProjectDialog.FileList.PrjFiles.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectDialog.FileList.AllFiles.Text", (String[])new String[0])}, (boolean)true) : ((configDir = BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wConfigFile, (IVariables)this.variables)) != null ? configDir : "") + File.separator + "project-config.json";
        if (configFileStr != null) {
            String relativeConfigFile = null;
            if (!((String)configFileStr).startsWith(rootPath)) {
                MessageBox box = new MessageBox(this.shell, 36);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.WrongConfigPath.Dialog.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.WrongConfigPath.Dialog.Message", (String[])new String[0]));
                box.open();
            } else {
                String tmpConfigFile = StringUtils.difference((String)(rootPath + File.separator), (String)configFileStr);
                relativeConfigFile = tmpConfigFile.startsWith("/") ? tmpConfigFile.substring(1) : tmpConfigFile;
                relativeConfigFile.replace("\\", "/");
            }
            this.wConfigFile.setText(Const.NVL((String)relativeConfigFile, (String)""));
        }
    }

    private void updateIVariables() {
        Project env = new Project();
        ProjectConfig pc = new ProjectConfig();
        try {
            this.getInfo(env, pc);
            env.modifyVariables(this.variables, pc, Collections.emptyList(), null);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectConfigError.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectConfigError.Error.Dialog.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void ok() {
        try {
            List<String> refs;
            String projectName;
            int anwser;
            MessageBox box;
            boolean projectHomeFolderChanged;
            String oriProjectName = this.projectConfig.getProjectName();
            String oriProjectHome = this.projectConfig.getProjectHome();
            String homeFolder = this.wHome.getText();
            boolean bl = projectHomeFolderChanged = this.editMode != false && !oriProjectHome.equals(homeFolder);
            if (StringUtils.isEmpty((String)this.variables.resolve(homeFolder))) {
                throw new HopException("Please specify a home folder for your project");
            }
            if (projectHomeFolderChanged) {
                box = new MessageBox(this.shell, 196);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.ChangeHome.Dialog.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectDialog.ChangeHome.Dialog.Message", (String[])new String[]{oriProjectHome, homeFolder}));
                anwser = box.open();
                if ((anwser & 0x80) != 0) {
                    this.wHome.setText(oriProjectHome);
                    projectHomeFolderChanged = false;
                }
            }
            if (!(HopVfs.getFileObject((String)this.variables.resolve(homeFolder)).exists() || this.editMode.booleanValue() && !projectHomeFolderChanged)) {
                box = new MessageBox(this.shell, 196);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.CreateHome.Dialog.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectDialog.CreateHome.Dialog.Message", (String[])new String[]{homeFolder}));
                anwser = box.open();
                if ((anwser & 0x40) != 0) {
                    HopVfs.getFileObject((String)homeFolder).createFolder();
                }
            }
            if (StringUtils.isEmpty((String)(projectName = this.wName.getText()))) {
                throw new HopException("Please give your new project a name");
            }
            if (Utils.isEmpty((CharSequence)this.wHome.getText())) {
                throw new HopException("Please specify project's home directory path!");
            }
            if (Utils.isEmpty((CharSequence)this.wConfigFile.getText())) {
                throw new HopException("Please specify project's configuration file relative path!");
            }
            if (this.wParentProject.getText() != null && !this.wParentProject.getText().isEmpty() && projectName.equals(this.wParentProject.getText())) {
                throw new HopException(CONST_PROJECT + projectName + "' cannot be set as a parent project of itself");
            }
            ProjectsConfig prjsCfg = ProjectsConfigSingleton.getConfig();
            List<String> prjs = prjsCfg.listProjectConfigNames();
            if (StringUtils.isEmpty((String)oriProjectName) || StringUtils.isNotEmpty((String)oriProjectName) && !projectName.equals(oriProjectName)) {
                for (String prj : prjs) {
                    if (!projectName.equals(prj)) continue;
                    throw new HopException(CONST_PROJECT + projectName + "' already exists. Project name must be unique!");
                }
            }
            HopGui hopGui = HopGui.getInstance();
            if (!Utils.isEmpty((CharSequence)this.wParentProject.getText())) {
                boolean parentPrjExists = ProjectsUtil.projectExists(this.wParentProject.getText());
                if (!parentPrjExists) {
                    throw new HopException(CONST_PROJECT + this.wParentProject.getText() + "' cannot be set as parent project because it does not exists!");
                }
                ProjectConfig parentPrjCfg = prjsCfg.findProjectConfig(this.wParentProject.getText());
                Project parentPrj = parentPrjCfg.loadProject(hopGui.getVariables());
                if (parentPrj.getParentProjectName() != null && parentPrj.getParentProjectName().equals(projectName)) {
                    throw new HopException(CONST_PROJECT + projectName + "' cannot reference '" + this.wParentProject.getText() + "' as parent project because we are going to create a circular reference!");
                }
            }
            if (this.editMode.booleanValue() && !oriProjectName.equals(projectName)) {
                MessageBox box2 = new MessageBox(this.shell, 196);
                box2.setText(BaseMessages.getString(PKG, (String)"ProjectDialog.ChangeProjectName.Dialog.Header", (String[])new String[0]));
                box2.setMessage(BaseMessages.getString(PKG, (String)"ProjectDialog.ChangeProjectName.Dialog.Message", (String[])new String[]{oriProjectName, projectName}));
                int anwser2 = box2.open();
                if ((anwser2 & 0x80) != 0) {
                    this.wName.setText(oriProjectName);
                }
            }
            if (!oriProjectName.equals(projectName) && !(refs = ProjectsUtil.getParentProjectReferences(oriProjectName)).isEmpty()) {
                ProjectsUtil.changeParentProjectReferences(oriProjectName, projectName);
            }
            this.getInfo(this.project, this.projectConfig);
            this.returnValue = this.projectConfig.getProjectName();
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectConfigError.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectConfigError.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void cancel() {
        this.needingProjectRefresh = false;
        this.returnValue = null;
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.projectConfig.getProjectName(), (String)""));
        this.wHome.setText(Const.NVL((String)this.projectConfig.getProjectHome(), (String)""));
        this.wConfigFile.setText(Const.NVL((String)this.projectConfig.getConfigFilename(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.project.getDescription(), (String)""));
        this.wCompany.setText(Const.NVL((String)this.project.getCompany(), (String)""));
        this.wDepartment.setText(Const.NVL((String)this.project.getDepartment(), (String)""));
        this.wMetadataBaseFolder.setText(Const.NVL((String)this.project.getMetadataBaseFolder(), (String)""));
        this.wUnitTestsBasePath.setText(Const.NVL((String)this.project.getUnitTestsBasePath(), (String)""));
        this.wDataSetCsvFolder.setText(Const.NVL((String)this.project.getDataSetsCsvFolder(), (String)""));
        this.wEnforceHomeExecution.setSelection(this.project.isEnforcingExecutionInHome());
        for (int i = 0; i < this.project.getDescribedVariables().size(); ++i) {
            DescribedVariable describedVariable = (DescribedVariable)this.project.getDescribedVariables().get(i);
            TableItem item = this.wVariables.table.getItem(i);
            item.setText(1, Const.NVL((String)describedVariable.getName(), (String)""));
            item.setText(2, Const.NVL((String)describedVariable.getValue(), (String)""));
            item.setText(3, Const.NVL((String)describedVariable.getDescription(), (String)""));
        }
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
        try {
            this.wParentProject.setText(Const.NVL((String)this.project.getParentProjectName(), (String)""));
            List<String> names = ProjectsConfigSingleton.getConfig().listProjectConfigNames();
            if (this.projectConfig.getProjectName() != null) {
                names.remove(this.projectConfig.getProjectName());
            }
            this.wParentProject.setItems(names.toArray(new String[0]));
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectList.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectDialog.ProjectList.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void getInfo(Project project, ProjectConfig projectConfig) throws HopException {
        projectConfig.setProjectName(this.wName.getText());
        projectConfig.setProjectHome(this.wHome.getText());
        projectConfig.setConfigFilename(this.wConfigFile.getText());
        project.setParentProjectName(this.wParentProject.getText());
        project.setDescription(this.wDescription.getText());
        project.setCompany(this.wCompany.getText());
        project.setDepartment(this.wDepartment.getText());
        project.setMetadataBaseFolder(this.wMetadataBaseFolder.getText());
        project.setUnitTestsBasePath(this.wUnitTestsBasePath.getText());
        project.setDataSetsCsvFolder(this.wDataSetCsvFolder.getText());
        project.setEnforcingExecutionInHome(this.wEnforceHomeExecution.getSelection());
        project.getDescribedVariables().clear();
        for (int i = 0; i < this.wVariables.nrNonEmpty(); ++i) {
            TableItem item = this.wVariables.getNonEmpty(i);
            DescribedVariable variable = new DescribedVariable(item.getText(1), item.getText(2), item.getText(3));
            project.getDescribedVariables().add(variable);
        }
        if (StringUtils.isNotEmpty((String)projectConfig.getProjectHome()) && StringUtils.isNotEmpty((String)projectConfig.configFilename)) {
            project.setConfigFilename(projectConfig.getActualProjectConfigFilename(this.variables));
        }
        project.verifyProjectsChain(projectConfig.getProjectName(), this.variables);
    }

    public boolean isNeedingProjectRefresh() {
        return this.needingProjectRefresh;
    }

    public void setNeedingProjectRefresh(boolean needingProjectRefresh) {
        this.needingProjectRefresh = needingProjectRefresh;
    }
}

