/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator.calculations.conversion;

import java.util.Base64;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.ICalculation;

public class Base64Decode
implements ICalculation {
    private static final String description = BaseMessages.getString((Class)PKG, (String)"CalculatorMetaFunction.CalcFunctions.Base64Decode", (String[])new String[0]);

    @Override
    public String getCode() {
        return "BASE64_DECODE";
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getDefaultResultType() {
        return 2;
    }

    @Override
    public CalculationOutput calculate(CalculationInput in) throws HopValueException {
        Object value = null;
        if (in.dataA != null) {
            byte[] tmpDecoded = Base64.getDecoder().decode(in.metaA.getString(in.dataA));
            if (in.targetMeta.getType() == 8) {
                value = tmpDecoded;
            } else {
                String tmpDecodedString = new String(tmpDecoded);
                value = in.targetMeta.convertData(in.metaA, (Object)tmpDecodedString);
            }
        }
        return new CalculationOutput(in.targetMeta.getType(), value);
    }
}

