/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.serde.POJOFieldDeserializer;
import com.clickhouse.client.internal.org.objectweb.asm.ClassWriter;
import com.clickhouse.client.internal.org.objectweb.asm.MethodVisitor;
import com.clickhouse.client.internal.org.objectweb.asm.Type;
import com.clickhouse.data.ClickHouseAggregateFunction;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseEnum;
import com.clickhouse.data.format.BinaryStreamUtils;
import com.clickhouse.data.value.ClickHouseBitmap;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;

public class SerializerUtils {
    private static final Map<Class<?>, ClickHouseColumn> PREDEFINED_TYPE_COLUMNS = SerializerUtils.getPredefinedTypeColumnsMap();
    private static final ClickHouseColumn GEO_POINT_TUPLE = ClickHouseColumn.parse("geopoint Tuple(Float64, Float64)").get(0);
    private static final ClickHouseColumn GEO_RING_ARRAY = ClickHouseColumn.parse("georing Array(Tuple(Float64, Float64))").get(0);
    private static final ClickHouseColumn GEO_POLYGON_ARRAY = ClickHouseColumn.parse("geopolygin Array(Array(Tuple(Float64, Float64)))").get(0);
    private static final ClickHouseColumn GEO_MULTI_POLYGON_ARRAY = ClickHouseColumn.parse("geomultipolygin Array(Array(Array(Tuple(Float64, Float64))))").get(0);

    public static void serializeData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        switch (column.getDataType()) {
            case Array: {
                SerializerUtils.serializeArrayData(stream, value, column);
                break;
            }
            case Tuple: {
                SerializerUtils.serializeTupleData(stream, value, column);
                break;
            }
            case Map: {
                SerializerUtils.serializeMapData(stream, value, column);
                break;
            }
            case AggregateFunction: {
                SerializerUtils.serializeAggregateFunction(stream, value, column);
                break;
            }
            case Variant: {
                SerializerUtils.serializerVariant(stream, column, value);
                break;
            }
            case Point: {
                value = value instanceof ClickHouseGeoPointValue ? ((ClickHouseGeoPointValue)value).getValue() : value;
                SerializerUtils.serializeTupleData(stream, value, GEO_POINT_TUPLE);
                break;
            }
            case Ring: 
            case LineString: {
                value = value instanceof ClickHouseGeoRingValue ? ((ClickHouseGeoRingValue)value).getValue() : value;
                SerializerUtils.serializeArrayData(stream, value, GEO_RING_ARRAY);
                break;
            }
            case Polygon: 
            case MultiLineString: {
                value = value instanceof ClickHouseGeoPolygonValue ? ((ClickHouseGeoPolygonValue)value).getValue() : value;
                SerializerUtils.serializeArrayData(stream, value, GEO_POLYGON_ARRAY);
                break;
            }
            case MultiPolygon: {
                value = value instanceof ClickHouseGeoMultiPolygonValue ? ((ClickHouseGeoMultiPolygonValue)value).getValue() : value;
                SerializerUtils.serializeArrayData(stream, value, GEO_MULTI_POLYGON_ARRAY);
                break;
            }
            case Dynamic: {
                ClickHouseColumn typeColumn = SerializerUtils.valueToColumnForDynamicType(value);
                SerializerUtils.writeDynamicTypeTag(stream, typeColumn);
                SerializerUtils.serializeData(stream, value, typeColumn);
                break;
            }
            default: {
                SerializerUtils.serializePrimitiveData(stream, value, column);
            }
        }
    }

    private static Map<Class<?>, ClickHouseColumn> getPredefinedTypeColumnsMap() {
        HashMap<Class<double[][][]>, ClickHouseColumn> map = new HashMap<Class<double[][][]>, ClickHouseColumn>();
        map.put(Void.class, ClickHouseColumn.of("v", "Nothing"));
        map.put(Boolean.class, ClickHouseColumn.of("v", "Bool"));
        map.put(Byte.class, ClickHouseColumn.of("v", "Int8"));
        map.put(Short.class, ClickHouseColumn.of("v", "Int16"));
        map.put(Integer.class, ClickHouseColumn.of("v", "Int32"));
        map.put(Long.class, ClickHouseColumn.of("v", "Int64"));
        map.put(BigInteger.class, ClickHouseColumn.of("v", "Int256"));
        map.put(Float.class, ClickHouseColumn.of("v", "Float32"));
        map.put(Double.class, ClickHouseColumn.of("v", "Float64"));
        map.put(UUID.class, ClickHouseColumn.of("v", "UUID"));
        map.put(Inet4Address.class, ClickHouseColumn.of("v", "IPv4"));
        map.put(Inet6Address.class, ClickHouseColumn.of("v", "IPv6"));
        map.put(String.class, ClickHouseColumn.of("v", "String"));
        map.put(LocalDate.class, ClickHouseColumn.of("v", "Date32"));
        map.put(Duration.class, ClickHouseColumn.of("v", "IntervalNanosecond"));
        map.put(Period.class, ClickHouseColumn.of("v", "IntervalDay"));
        map.put(ClickHouseGeoPointValue.class, ClickHouseColumn.of("v", "Point"));
        map.put(ClickHouseGeoRingValue.class, ClickHouseColumn.of("v", "Ring"));
        map.put(ClickHouseGeoPolygonValue.class, ClickHouseColumn.of("v", "Polygon"));
        map.put(ClickHouseGeoMultiPolygonValue.class, ClickHouseColumn.of("v", "MultiPolygon"));
        map.put(boolean[].class, ClickHouseColumn.of("v", "Array(Bool)"));
        map.put(boolean[][].class, ClickHouseColumn.of("v", "Array(Array(Bool))"));
        map.put(boolean[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Bool)))"));
        map.put(byte[].class, ClickHouseColumn.of("v", "Array(Int8)"));
        map.put(byte[][].class, ClickHouseColumn.of("v", "Array(Array(Int8))"));
        map.put(byte[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Int8)))"));
        map.put(short[].class, ClickHouseColumn.of("v", "Array(Int16)"));
        map.put(short[][].class, ClickHouseColumn.of("v", "Array(Array(Int16))"));
        map.put(short[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Int16)))"));
        map.put(int[].class, ClickHouseColumn.of("v", "Array(Int32)"));
        map.put(int[][].class, ClickHouseColumn.of("v", "Array(Array(Int32))"));
        map.put(int[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Int32)))"));
        map.put(long[].class, ClickHouseColumn.of("v", "Array(Int64)"));
        map.put(long[][].class, ClickHouseColumn.of("v", "Array(Array(Int64))"));
        map.put(long[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Int64)))"));
        map.put(float[].class, ClickHouseColumn.of("v", "Array(Float32)"));
        map.put(float[][].class, ClickHouseColumn.of("v", "Array(Array(Float32))"));
        map.put(float[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Float32)))"));
        map.put(double[].class, ClickHouseColumn.of("v", "Array(Float64)"));
        map.put(double[][].class, ClickHouseColumn.of("v", "Array(Array(Float64))"));
        map.put(double[][][].class, ClickHouseColumn.of("v", "Array(Array(Array(Float64)))"));
        return Collections.unmodifiableMap(map);
    }

    public static ClickHouseColumn valueToColumnForDynamicType(Object value) {
        ClickHouseColumn column;
        if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            column = ClickHouseColumn.of("v", "DateTime64(9, " + dt.getZone().getId() + ")");
        } else if (value instanceof LocalDateTime) {
            column = ClickHouseColumn.of("v", "DateTime64(9, " + ZoneId.systemDefault().getId() + ")");
        } else if (value instanceof BigDecimal) {
            int scale;
            String decType;
            BigDecimal d = (BigDecimal)value;
            if (d.precision() > ClickHouseDataType.Decimal128.getMaxScale()) {
                decType = "Decimal256";
                scale = ClickHouseDataType.Decimal256.getMaxScale();
            } else if (d.precision() > ClickHouseDataType.Decimal64.getMaxScale()) {
                decType = "Decimal128";
                scale = ClickHouseDataType.Decimal128.getMaxScale();
            } else if (d.precision() > ClickHouseDataType.Decimal32.getMaxScale()) {
                decType = "Decimal64";
                scale = ClickHouseDataType.Decimal64.getMaxScale();
            } else {
                decType = "Decimal32";
                scale = ClickHouseDataType.Decimal32.getMaxScale();
            }
            column = ClickHouseColumn.of("v", decType + "(" + scale + ")");
        } else if (value instanceof Map) {
            Map map = (Map)value;
            Map.Entry entry = map.entrySet().iterator().next();
            ClickHouseColumn keyInfo = SerializerUtils.valueToColumnForDynamicType(entry.getKey());
            ClickHouseColumn valueInfo = SerializerUtils.valueToColumnForDynamicType(entry.getValue());
            column = ClickHouseColumn.of("v", "Map(" + keyInfo.getOriginalTypeName() + ", " + valueInfo.getOriginalTypeName() + ")");
        } else {
            column = value instanceof Enum ? SerializerUtils.enumValue2Column((Enum)value) : (value instanceof List || value != null && value.getClass().isArray() ? SerializerUtils.listValue2Column(value) : (value instanceof Instant ? ClickHouseColumn.of("v", "Time64(9)") : (value == null ? PREDEFINED_TYPE_COLUMNS.get(Void.class) : PREDEFINED_TYPE_COLUMNS.get(value.getClass()))));
        }
        if (column == null) {
            throw new ClientException("Unable to serialize value of " + value.getClass() + " because not supported yet");
        }
        return column;
    }

    private static ClickHouseColumn listValue2Column(Object value) {
        ClickHouseColumn column = PREDEFINED_TYPE_COLUMNS.get(value.getClass());
        if (column != null) {
            return column;
        }
        if (value instanceof List || value.getClass().isArray()) {
            Stack<Object[]> arrays = new Stack<Object[]>();
            arrays.push(new Object[]{value, 1});
            int maxDepth = 0;
            boolean hasNulls = false;
            ClickHouseColumn arrayBaseColumn = null;
            StringBuilder typeStr = new StringBuilder();
            int insertPos = 0;
            while (!arrays.isEmpty()) {
                boolean isArray;
                Object[] arr = (Object[])arrays.pop();
                int depth = (Integer)arr[1];
                if (depth > maxDepth) {
                    maxDepth = depth;
                    typeStr.insert(insertPos, "Array()");
                    insertPos += 6;
                }
                List list = (isArray = arr[0].getClass().isArray()) ? null : (List)arr[0];
                int len = isArray ? Array.getLength(arr[0]) : list.size();
                for (int i = 0; i < len; ++i) {
                    Object item;
                    Object object = item = isArray ? Array.get(arr[0], i) : list.get(i);
                    if (!hasNulls && item == null) {
                        hasNulls = true;
                        continue;
                    }
                    if (item != null && (item instanceof List || item.getClass().isArray())) {
                        arrays.push(new Object[]{item, depth + 1});
                        continue;
                    }
                    if (arrayBaseColumn != null || item == null || (arrayBaseColumn = PREDEFINED_TYPE_COLUMNS.get(item.getClass())) != null) continue;
                    throw new ClientException("Cannot serialize " + item.getClass() + " as array element");
                }
                if (arrayBaseColumn == null) continue;
                if (hasNulls) {
                    typeStr.insert(insertPos, "Nullable()");
                    insertPos += 9;
                }
                typeStr.insert(insertPos, arrayBaseColumn.getOriginalTypeName());
                break;
            }
            column = ClickHouseColumn.of("v", typeStr.toString());
        } else {
            column = null;
        }
        return column;
    }

    private static ClickHouseColumn enumValue2Column(Enum<?> enumValue) {
        ClickHouseEnum clickHouseEnum = ClickHouseEnum.of(enumValue.getClass());
        return new ClickHouseColumn(clickHouseEnum.size() > 127 ? ClickHouseDataType.Enum16 : ClickHouseDataType.Enum8, "v", "Enum16", false, false, Collections.emptyList(), Collections.emptyList(), clickHouseEnum);
    }

    public static void writeDynamicTypeTag(OutputStream stream, ClickHouseColumn typeColumn) throws IOException {
        ClickHouseDataType dt = typeColumn.getDataType();
        byte binTag = dt.getBinTag();
        if (binTag == -1) {
            throw new ClientException("Type " + dt.name() + " serialization is not supported for Dynamic column");
        }
        if (typeColumn.isNullable()) {
            stream.write(35);
        }
        if (typeColumn.isLowCardinality()) {
            stream.write(38);
        }
        switch (dt) {
            case FixedString: {
                stream.write(binTag);
                SerializerUtils.writeVarInt(stream, typeColumn.getEstimatedLength());
                break;
            }
            case Enum8: 
            case Enum16: {
                stream.write(binTag);
                ClickHouseEnum enumVal = typeColumn.getEnumConstants();
                String[] names = enumVal.getNames();
                int[] values = enumVal.getValues();
                SerializerUtils.writeVarInt(stream, names.length);
                for (int i = 0; i < enumVal.size(); ++i) {
                    BinaryStreamUtils.writeString(stream, names[i]);
                    if (dt == ClickHouseDataType.Enum8) {
                        BinaryStreamUtils.writeInt8(stream, values[i]);
                        continue;
                    }
                    BinaryStreamUtils.writeInt16(stream, values[i]);
                }
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                stream.write(binTag);
                BinaryStreamUtils.writeUnsignedInt8(stream, dt.getMaxPrecision());
                BinaryStreamUtils.writeUnsignedInt8(stream, dt.getMaxScale());
                break;
            }
            case IntervalNanosecond: 
            case IntervalMillisecond: 
            case IntervalSecond: 
            case IntervalMinute: 
            case IntervalHour: 
            case IntervalDay: 
            case IntervalWeek: 
            case IntervalMonth: 
            case IntervalQuarter: 
            case IntervalYear: {
                stream.write(binTag);
                Byte kindTag = ClickHouseDataType.intervalType2Kind.get(dt).getTag();
                if (kindTag == null) {
                    throw new ClientException("BUG! No Interval Mapping to a kind tag");
                }
                stream.write(kindTag.byteValue());
                break;
            }
            case DateTime32: {
                stream.write(binTag);
                BinaryStreamUtils.writeString(stream, typeColumn.getTimeZoneOrDefault(TimeZone.getDefault()).getID());
                break;
            }
            case DateTime64: {
                stream.write(binTag);
                BinaryStreamUtils.writeUnsignedInt8(stream, typeColumn.getScale());
                BinaryStreamUtils.writeString(stream, typeColumn.getTimeZoneOrDefault(TimeZone.getDefault()).getID());
                break;
            }
            case Array: {
                stream.write(binTag);
                ClickHouseColumn arrayElemColumn = typeColumn.getNestedColumns().get(0);
                SerializerUtils.writeDynamicTypeTag(stream, arrayElemColumn);
                break;
            }
            case Map: {
                stream.write(binTag);
                SerializerUtils.writeDynamicTypeTag(stream, typeColumn.getKeyInfo());
                SerializerUtils.writeDynamicTypeTag(stream, typeColumn.getValueInfo());
                break;
            }
            case Tuple: {
                stream.write(31);
                stream.write(32);
                break;
            }
            case Point: 
            case Ring: 
            case Polygon: 
            case MultiPolygon: {
                stream.write(44);
                BinaryStreamUtils.writeString(stream, dt.name());
                break;
            }
            case Variant: {
                stream.write(binTag);
                break;
            }
            case Dynamic: {
                stream.write(binTag);
                break;
            }
            case JSON: {
                stream.write(binTag);
                break;
            }
            case SimpleAggregateFunction: {
                stream.write(binTag);
                break;
            }
            case AggregateFunction: {
                stream.write(binTag);
                break;
            }
            case Time64: {
                stream.write(binTag);
                BinaryStreamUtils.writeUnsignedInt8(stream, dt.getMaxPrecision());
                break;
            }
            default: {
                stream.write(binTag);
            }
        }
    }

    public static void serializeArrayData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (value == null) {
            SerializerUtils.writeVarInt(stream, 0L);
            return;
        }
        boolean isArray = value.getClass().isArray();
        if (value instanceof List || isArray) {
            List list = isArray ? null : (List)value;
            int len = isArray ? Array.getLength(value) : list.size();
            SerializerUtils.writeVarInt(stream, len);
            for (int i = 0; i < len; ++i) {
                Object val;
                Object object = val = isArray ? Array.get(value, i) : list.get(i);
                if (column.getArrayNestedLevel() == 1 && column.getArrayBaseColumn().isNullable()) {
                    if (val == null) {
                        SerializerUtils.writeNull(stream);
                        continue;
                    }
                    SerializerUtils.writeNonNull(stream);
                }
                SerializerUtils.serializeData(stream, val, column.getNestedColumns().get(0));
            }
        }
    }

    private static void serializeTupleData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (value instanceof List) {
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                SerializerUtils.serializeData(stream, values.get(i), column.getNestedColumns().get(i));
            }
        } else if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                SerializerUtils.serializeData(stream, Array.get(value, i), column.getNestedColumns().get(i));
            }
        } else {
            throw new IllegalArgumentException("Cannot serialize " + value + " as a tuple");
        }
    }

    private static void serializeMapData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        Map map = (Map)value;
        SerializerUtils.writeVarInt(stream, map.size());
        map.forEach((key, val) -> {
            try {
                SerializerUtils.serializePrimitiveData(stream, key, Objects.requireNonNull(column.getKeyInfo()));
                SerializerUtils.serializeData(stream, val, Objects.requireNonNull(column.getValueInfo()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void serializePrimitiveData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (value == null && column.isNullable()) {
            BinaryStreamUtils.writeNull(stream);
            return;
        }
        switch (column.getDataType()) {
            case Int8: {
                BinaryStreamUtils.writeInt8(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int16: {
                BinaryStreamUtils.writeInt16(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int32: {
                BinaryStreamUtils.writeInt32(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int64: {
                BinaryStreamUtils.writeInt64(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case Int128: {
                BinaryStreamUtils.writeInt128(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Int256: {
                BinaryStreamUtils.writeInt256(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt8: {
                BinaryStreamUtils.writeUnsignedInt8(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt16: {
                BinaryStreamUtils.writeUnsignedInt16(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt32: {
                BinaryStreamUtils.writeUnsignedInt32(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case UInt64: {
                BinaryStreamUtils.writeUnsignedInt64(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case UInt128: {
                BinaryStreamUtils.writeUnsignedInt128(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt256: {
                BinaryStreamUtils.writeUnsignedInt256(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Float32: {
                BinaryStreamUtils.writeFloat32(stream, ((Float)value).floatValue());
                break;
            }
            case Float64: {
                BinaryStreamUtils.writeFloat64(stream, (Double)value);
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                BinaryStreamUtils.writeDecimal(stream, SerializerUtils.convertToBigDecimal(value), column.getPrecision(), column.getScale());
                break;
            }
            case Bool: {
                BinaryStreamUtils.writeBoolean(stream, (Boolean)value);
                break;
            }
            case String: {
                BinaryStreamUtils.writeString(stream, SerializerUtils.convertToString(value));
                break;
            }
            case FixedString: {
                BinaryStreamUtils.writeFixedString(stream, SerializerUtils.convertToString(value), column.getPrecision());
                break;
            }
            case Date: {
                SerializerUtils.writeDate(stream, value, ZoneId.of("UTC"));
                break;
            }
            case Date32: {
                SerializerUtils.writeDate32(stream, value, ZoneId.of("UTC"));
                break;
            }
            case DateTime: {
                ZoneId zoneId = column.getTimeZone() == null ? ZoneId.of("UTC") : column.getTimeZone().toZoneId();
                SerializerUtils.writeDateTime(stream, value, zoneId);
                break;
            }
            case DateTime64: {
                ZoneId zoneId = column.getTimeZone() == null ? ZoneId.of("UTC") : column.getTimeZone().toZoneId();
                SerializerUtils.writeDateTime64(stream, value, column.getScale(), zoneId);
                break;
            }
            case Time: {
                BinaryStreamUtils.writeInt32(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Time64: {
                SerializerUtils.serializeTime64(stream, value);
                break;
            }
            case UUID: {
                BinaryStreamUtils.writeUuid(stream, (UUID)value);
                break;
            }
            case Enum8: 
            case Enum16: {
                SerializerUtils.serializeEnumData(stream, column, value);
                break;
            }
            case IPv4: {
                BinaryStreamUtils.writeInet4Address(stream, (Inet4Address)value);
                break;
            }
            case IPv6: {
                BinaryStreamUtils.writeInet6Address(stream, (Inet6Address)value);
                break;
            }
            case JSON: {
                SerializerUtils.serializeJSON(stream, value);
                break;
            }
            case IntervalNanosecond: 
            case IntervalMillisecond: 
            case IntervalSecond: 
            case IntervalMinute: 
            case IntervalHour: 
            case IntervalDay: 
            case IntervalWeek: 
            case IntervalMonth: 
            case IntervalQuarter: 
            case IntervalYear: 
            case IntervalMicrosecond: {
                SerializerUtils.serializeInterval(stream, column, value);
                break;
            }
            case Nothing: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + column.getDataType());
            }
        }
    }

    private static void serializeInterval(OutputStream stream, ClickHouseColumn column, Object value) throws IOException {
        long v;
        if (value instanceof Duration) {
            Duration d = (Duration)value;
            switch (column.getDataType()) {
                case IntervalMillisecond: {
                    v = d.toMillis();
                    break;
                }
                case IntervalNanosecond: {
                    v = d.toNanos();
                    break;
                }
                case IntervalMicrosecond: {
                    v = d.toNanos() / 1000L;
                    break;
                }
                case IntervalSecond: {
                    v = d.getSeconds();
                    break;
                }
                case IntervalMinute: {
                    v = d.toMinutes();
                    break;
                }
                case IntervalHour: {
                    v = d.toHours();
                    break;
                }
                case IntervalDay: {
                    v = d.toDays();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot convert Duration to " + column.getDataType());
                }
            }
        } else if (value instanceof Period) {
            Period p = (Period)value;
            switch (column.getDataType()) {
                case IntervalDay: {
                    v = p.toTotalMonths() * 30L + (long)p.getDays();
                    break;
                }
                case IntervalWeek: {
                    v = (p.toTotalMonths() * 30L + (long)p.getDays()) / 7L;
                    break;
                }
                case IntervalMonth: {
                    v = p.toTotalMonths() + (long)(p.getDays() / 30);
                    break;
                }
                case IntervalQuarter: {
                    v = (p.toTotalMonths() + (long)(p.getDays() / 30)) / 3L;
                    break;
                }
                case IntervalYear: {
                    v = (p.toTotalMonths() + (long)(p.getDays() / 30)) / 12L;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot convert Period to " + column.getDataType());
                }
            }
        } else {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + column.getDataType());
        }
        BinaryStreamUtils.writeUnsignedInt64(stream, v);
    }

    private static void serializeTime64(OutputStream stream, Object value) throws IOException {
        if (value instanceof BigInteger) {
            BinaryStreamUtils.writeUnsignedInt64(stream, (BigInteger)value);
        } else if (value instanceof Long) {
            BinaryStreamUtils.writeUnsignedInt64(stream, (Long)value);
        } else if (value instanceof Instant) {
            BinaryStreamUtils.writeUnsignedInt64(stream, BigInteger.valueOf(((Instant)value).getEpochSecond()).shiftLeft(32).add(BigInteger.valueOf(((Instant)value).getNano())));
        } else {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to Time64");
        }
    }

    private static void serializeEnumData(OutputStream stream, ClickHouseColumn column, Object value) throws IOException {
        int enumValue = -1;
        if (value instanceof String) {
            enumValue = column.getEnumConstants().value((String)value);
        } else if (value instanceof Number) {
            enumValue = ((Number)value).intValue();
        } else if (value instanceof Enum) {
            enumValue = ((Enum)value).ordinal();
        } else {
            throw new IllegalArgumentException("Cannot write value of class " + value.getClass() + " into column with Enum type " + column.getOriginalTypeName());
        }
        if (column.getDataType() == ClickHouseDataType.Enum8) {
            BinaryStreamUtils.writeInt8(stream, enumValue);
        } else if (column.getDataType() == ClickHouseDataType.Enum16) {
            BinaryStreamUtils.writeInt16(stream, enumValue);
        } else {
            throw new ClientException("Bug! serializeEnumData() was called for " + column.getDataType());
        }
    }

    private static void serializeJSON(OutputStream stream, Object value) throws IOException {
        if (!(value instanceof String)) {
            throw new UnsupportedOperationException("Serialization of Java object to JSON is not supported yet.");
        }
        BinaryStreamUtils.writeString(stream, (String)value);
    }

    private static void serializerVariant(OutputStream out, ClickHouseColumn column, Object value) throws IOException {
        int typeOrdNum = column.getVariantOrdNum(value);
        if (typeOrdNum == -1) {
            throw new IllegalArgumentException("Cannot write value of class " + value.getClass() + " into column with variant type " + column.getOriginalTypeName());
        }
        BinaryStreamUtils.writeUnsignedInt8(out, typeOrdNum);
        SerializerUtils.serializeData(out, value, column.getNestedColumns().get(typeOrdNum));
    }

    private static void serializeAggregateFunction(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (column.getAggregateFunction() == ClickHouseAggregateFunction.groupBitmap) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot serialize null value for aggregate function: " + (Object)((Object)column.getAggregateFunction()));
            }
            if (!(value instanceof ClickHouseBitmap)) {
                throw new IllegalArgumentException("Cannot serialize value of type " + value.getClass() + " for aggregate function: " + (Object)((Object)column.getAggregateFunction()));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported aggregate function: " + (Object)((Object)column.getAggregateFunction()));
        }
        stream.write(((ClickHouseBitmap)value).toBytes());
    }

    public static Integer convertToInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Integer");
    }

    public static Long convertToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Long");
    }

    public static BigInteger convertToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigInteger");
    }

    public static BigDecimal convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigDecimal");
    }

    public static String convertToString(Object value) {
        return String.valueOf(value);
    }

    public static <T extends Enum<T>> Set<T> parseEnumList(String value, Class<T> enumType) {
        HashSet<T> values = new HashSet<T>();
        StringTokenizer causes = new StringTokenizer(value, ",");
        while (causes.hasMoreTokens()) {
            values.add(Enum.valueOf(enumType, causes.nextToken()));
        }
        return values;
    }

    public static boolean numberToBoolean(Number value) {
        return value.doubleValue() != 0.0;
    }

    public static boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.ZERO) != 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Boolean");
    }

    public static List<?> convertArrayValueToList(Object value) {
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return ((BinaryStreamReader.ArrayValue)value).asList();
        }
        if (value.getClass().isArray()) {
            return Arrays.stream((Object[])value).collect(Collectors.toList());
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " ('" + value.getClass() + "') to list");
    }

    public static POJOFieldDeserializer compilePOJOSetter(Method setterMethod, ClickHouseColumn column) {
        Class<?> dtoClass = setterMethod.getDeclaringClass();
        String pojoSetterClassName = (dtoClass.getName() + setterMethod.getName()).replace('.', '/');
        ClassWriter writer = new ClassWriter(1);
        writer.visit(52, 1, pojoSetterClassName, null, "java/lang/Object", new String[]{POJOFieldDeserializer.class.getName().replace('.', '/')});
        MethodVisitor mv = writer.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = writer.visitMethod(1, "setValue", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Object.class), Type.getType(BinaryStreamReader.class), Type.getType(ClickHouseColumn.class)), null, new String[]{"java/io/IOException"});
        Class<?> targetType = setterMethod.getParameterTypes()[0];
        Class<?> targetPrimitiveType = ClickHouseDataType.toPrimitiveType(targetType);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(dtoClass));
        mv.visitVarInsn(25, 2);
        if (targetType.isPrimitive() && BinaryStreamReader.isReadToPrimitive(column.getDataType())) {
            SerializerUtils.binaryReaderMethodForType(mv, targetPrimitiveType, column.getDataType());
        } else if (targetType.isPrimitive() && column.getDataType() == ClickHouseDataType.UInt64) {
            mv.visitTypeInsn(192, Type.getInternalName(BigInteger.class));
            mv.visitMethodInsn(182, Type.getInternalName(BigInteger.class), targetType.getSimpleName() + "Value", "()" + Type.getDescriptor(targetType), false);
        } else {
            mv.visitVarInsn(25, 3);
            mv.visitLdcInsn(Type.getType(targetType));
            mv.visitMethodInsn(182, Type.getInternalName(BinaryStreamReader.class), "readValue", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(ClickHouseColumn.class), Type.getType(Class.class)), false);
            if (List.class.isAssignableFrom(targetType) && column.getDataType() == ClickHouseDataType.Tuple) {
                mv.visitTypeInsn(192, Type.getInternalName(Object[].class));
                mv.visitMethodInsn(184, Type.getInternalName(Arrays.class), "asList", Type.getMethodDescriptor(Type.getType(List.class), Type.getType(Object[].class)), false);
            } else {
                mv.visitTypeInsn(192, Type.getInternalName(targetType));
            }
        }
        mv.visitMethodInsn(182, Type.getInternalName(dtoClass), setterMethod.getName(), Type.getMethodDescriptor(setterMethod), false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        try {
            DynamicClassLoader loader = new DynamicClassLoader(dtoClass.getClassLoader());
            Class<?> clazz = loader.defineClass(pojoSetterClassName.replace('/', '.'), writer.toByteArray());
            return (POJOFieldDeserializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ClientException("Failed to compile setter for " + setterMethod.getName(), e);
        }
    }

    private static void binaryReaderMethodForType(MethodVisitor mv, Class<?> targetType, ClickHouseDataType dataType) {
        String readerMethod = null;
        String readerMethodReturnType = null;
        int convertOpcode = -1;
        switch (dataType) {
            case Int8: {
                readerMethod = "readByte";
                readerMethodReturnType = Type.getDescriptor(Byte.TYPE);
                break;
            }
            case UInt8: {
                readerMethod = "readUnsignedByte";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            case Int16: {
                readerMethod = "readShortLE";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            case UInt16: {
                readerMethod = "readUnsignedShortLE";
                readerMethodReturnType = Type.getDescriptor(Integer.TYPE);
                convertOpcode = SerializerUtils.intToOpcode(targetType);
                break;
            }
            case Int32: {
                readerMethod = "readIntLE";
                readerMethodReturnType = Type.getDescriptor(Integer.TYPE);
                convertOpcode = SerializerUtils.intToOpcode(targetType);
                break;
            }
            case UInt32: {
                readerMethod = "readUnsignedIntLE";
                readerMethodReturnType = Type.getDescriptor(Long.TYPE);
                convertOpcode = SerializerUtils.longToOpcode(targetType);
                break;
            }
            case Int64: {
                readerMethod = "readLongLE";
                readerMethodReturnType = Type.getDescriptor(Long.TYPE);
                convertOpcode = SerializerUtils.longToOpcode(targetType);
                break;
            }
            case Float32: {
                readerMethod = "readFloatLE";
                readerMethodReturnType = Type.getDescriptor(Float.TYPE);
                convertOpcode = SerializerUtils.floatToOpcode(targetType);
                break;
            }
            case Float64: {
                readerMethod = "readDoubleLE";
                readerMethodReturnType = Type.getDescriptor(Double.TYPE);
                convertOpcode = SerializerUtils.doubleToOpcode(targetType);
                break;
            }
            case Enum8: {
                readerMethod = "readByte";
                readerMethodReturnType = Type.getDescriptor(Byte.TYPE);
                break;
            }
            case Enum16: {
                readerMethod = "readShortLE";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            case Bool: {
                readerMethod = "readByte";
                readerMethodReturnType = Type.getDescriptor(Byte.TYPE);
                break;
            }
            default: {
                throw new ClientException("Column type '" + dataType + "' cannot be set to a primitive type '" + targetType + "'");
            }
        }
        mv.visitMethodInsn(182, Type.getInternalName(BinaryStreamReader.class), readerMethod, "()" + readerMethodReturnType, false);
        if (convertOpcode != -1) {
            mv.visitInsn(convertOpcode);
        }
    }

    private static int intToOpcode(Class<?> targetType) {
        if (targetType == Short.TYPE) {
            return 147;
        }
        if (targetType == Long.TYPE) {
            return 133;
        }
        if (targetType == Byte.TYPE) {
            return 145;
        }
        if (targetType == Character.TYPE) {
            return 146;
        }
        if (targetType == Float.TYPE) {
            return 134;
        }
        if (targetType == Double.TYPE) {
            return 135;
        }
        return -1;
    }

    private static int longToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 136;
        }
        if (targetType == Float.TYPE) {
            return 137;
        }
        if (targetType == Double.TYPE) {
            return 138;
        }
        return -1;
    }

    private static int floatToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 139;
        }
        if (targetType == Long.TYPE) {
            return 140;
        }
        if (targetType == Double.TYPE) {
            return 141;
        }
        return -1;
    }

    private static int doubleToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 142;
        }
        if (targetType == Long.TYPE) {
            return 143;
        }
        if (targetType == Float.TYPE) {
            return 144;
        }
        return -1;
    }

    public static void writeVarInt(OutputStream output, long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            output.write(b);
            if ((value >>= 7) != 0L) continue;
            return;
        }
    }

    public static void writeNull(OutputStream output) throws IOException {
        SerializerUtils.writeBoolean(output, true);
    }

    public static void writeNonNull(OutputStream output) throws IOException {
        SerializerUtils.writeBoolean(output, false);
    }

    public static void writeBoolean(OutputStream output, boolean value) throws IOException {
        output.write(value ? 1 : 0);
    }

    public static void writeDate(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        int epochDays = 0;
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            epochDays = (int)d.atStartOfDay(targetTz).toLocalDate().toEpochDay();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            epochDays = (int)dt.withZoneSameInstant(targetTz).toLocalDate().toEpochDay();
        } else if (value instanceof OffsetDateTime) {
            OffsetDateTime dt = (OffsetDateTime)value;
            epochDays = (int)dt.atZoneSameInstant(targetTz).toLocalDate().toEpochDay();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to Long");
        }
        BinaryStreamUtils.writeUnsignedInt16(output, epochDays);
    }

    public static void writeDate32(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        int epochDays = 0;
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            epochDays = (int)d.atStartOfDay(targetTz).toLocalDate().toEpochDay();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            epochDays = (int)dt.withZoneSameInstant(targetTz).toLocalDate().toEpochDay();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to Long");
        }
        BinaryStreamUtils.writeInt32(output, epochDays);
    }

    public static void writeDateTime32(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        SerializerUtils.writeDateTime(output, value, targetTz);
    }

    public static void writeDateTime(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        long ts;
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ts = dt.atZone(targetTz).toEpochSecond();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            ts = dt.toEpochSecond();
        } else if (value instanceof Timestamp) {
            Timestamp t = (Timestamp)value;
            ts = t.toLocalDateTime().atZone(targetTz).toEpochSecond();
        } else if (value instanceof OffsetDateTime) {
            OffsetDateTime dt = (OffsetDateTime)value;
            ts = dt.toEpochSecond();
        } else if (value instanceof Instant) {
            Instant dt = (Instant)value;
            ts = dt.getEpochSecond();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to DataTime");
        }
        BinaryStreamUtils.writeUnsignedInt32(output, ts);
    }

    public static void writeDateTime64(OutputStream output, Object value, int scale, ZoneId targetTz) throws IOException {
        long nano;
        long ts;
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Invalid scale value '" + scale + "'");
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ZonedDateTime zdt = dt.atZone(targetTz);
            ts = zdt.toEpochSecond();
            nano = zdt.getNano();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            ts = dt.toEpochSecond();
            nano = dt.getNano();
        } else if (value instanceof Timestamp) {
            Timestamp dt = (Timestamp)value;
            ZonedDateTime zdt = dt.toLocalDateTime().atZone(targetTz);
            ts = zdt.toEpochSecond();
            nano = zdt.getNano();
        } else if (value instanceof OffsetDateTime) {
            OffsetDateTime dt = (OffsetDateTime)value;
            ts = dt.toEpochSecond();
            nano = dt.getNano();
        } else if (value instanceof Instant) {
            Instant dt = (Instant)value;
            ts = dt.getEpochSecond();
            nano = dt.getNano();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to DataTime");
        }
        ts *= (long)BinaryStreamReader.BASES[scale];
        if (nano > 0L) {
            ts += nano / (long)BinaryStreamReader.BASES[9 - scale];
        }
        BinaryStreamUtils.writeInt64(output, ts);
    }

    public static class DynamicClassLoader
    extends ClassLoader {
        public DynamicClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class<?> defineClass(String name, byte[] code) throws ClassNotFoundException {
            return super.defineClass(name, code, 0, code.length);
        }
    }
}

