/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.impl;

import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestConformance;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestConnControl;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestContent;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestTargetHost;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestUserAgent;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.RequestValidateHost;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.ResponseConformance;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.ResponseConnControl;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.ResponseContent;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.ResponseDate;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.ResponseServer;
import com.clickhouse.client.internal.org.apache.hc.core5.util.TextUtils;
import com.clickhouse.client.internal.org.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(ResponseConformance.INSTANCE, ResponseDate.INSTANCE, new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "com.clickhouse.client.internal.org.apache.hc.core5", HttpProcessors.class)), ResponseContent.INSTANCE, ResponseConnControl.INSTANCE).addAll(RequestValidateHost.INSTANCE, RequestConformance.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestTargetHost.INSTANCE, RequestContent.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "com.clickhouse.client.internal.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

