/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.internal.JdbcUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;

public class DetachedResultSet
implements ResultSet,
JdbcV2Wrapper {
    private List<Map<String, Object>> records;
    private ListIterator<Map<String, Object>> iterator;
    private ResultSetMetaData metaData;
    private final Calendar defaultCalendar;
    private Map<String, Object> record;
    private boolean wasNull;
    private int row;
    private final int lastRow;
    private boolean closed;
    private Map<String, Integer> columnMap;

    private DetachedResultSet(List<Map<String, Object>> records, ResultSetMetaData metaData, Calendar defaultCalendar) throws SQLException {
        this.records = records;
        this.iterator = records.listIterator();
        this.metaData = metaData;
        this.defaultCalendar = defaultCalendar;
        this.wasNull = false;
        this.row = 0;
        this.lastRow = records.size();
        this.closed = false;
        this.columnMap = new HashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            this.columnMap.put(metaData.getColumnName(i), i);
        }
    }

    public static DetachedResultSet createFromResultSet(ResultSet resultSet, Calendar defaultCalendar, Collection<Consumer<Map<String, Object>>> mutators) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                record.put(metaData.getColumnLabel(i), resultSet.getObject(i));
            }
            for (Consumer<Map<String, Object>> mutator : mutators) {
                mutator.accept(record);
            }
            records.add(record);
        }
        return new DetachedResultSet(records, metaData, defaultCalendar);
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen();
        if (this.iterator.hasNext()) {
            ++this.row;
            this.record = this.iterator.next();
            return true;
        }
        this.row = -1;
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.metaData = null;
        this.record = null;
        this.iterator = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureOpen();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getByte(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.metaData.getColumnLabel(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getBytes(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getAsciiStream(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getUnicodeStream(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, String.class);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.ensureOpen();
        return (Boolean)this.getObjectImpl(columnLabel, Boolean.class, Boolean.FALSE);
    }

    private Number getNumber(String columnLabel) throws SQLException {
        this.ensureOpen();
        return (Number)this.getObjectImpl(columnLabel, Number.class, BigInteger.ZERO);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getNumber(columnLabel).byteValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getNumber(columnLabel).shortValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getNumber(columnLabel).intValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getNumber(columnLabel).longValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getNumber(columnLabel).floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getNumber(columnLabel).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, BigDecimal.class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, byte[].class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getDate(columnLabel, this.defaultCalendar);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getTime(columnLabel, this.defaultCalendar);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getTimestamp(columnLabel, this.defaultCalendar);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, InputStream.class);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, InputStream.class);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.ensureOpen();
        return this.getObject(columnLabel, InputStream.class);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.ensureOpen();
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Object.class);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.ensureOpen();
        Integer index = this.columnMap.get(columnLabel);
        if (index == null) {
            throw new SQLException("Column not found: " + columnLabel, "HY000");
        }
        return index;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Reader.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, BigDecimal.class);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureOpen();
        return this.row == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureOpen();
        return this.row == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureOpen();
        return this.row == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureOpen();
        return this.row == this.lastRow;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen();
        return Math.max(this.row, 0);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw new SQLException("This result set object is of FORWARD ONLY type. Only ResultSet.FETCH_FORWARD is allowed as fetchDirection.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void insertRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.metaData.getColumnLabel(columnIndex), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.getRef(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getBlob(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getClob(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getArray(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        if (map == null) {
            throw new SQLException("map must be not null", "HY000");
        }
        int columnIndex = this.columnMap.getOrDefault(columnLabel, -1);
        if (columnIndex == -1) {
            throw new SQLException("column " + columnLabel + " doesn't exist", "HY000");
        }
        String typeName = this.metaData.getColumnTypeName(columnIndex);
        return this.getObject(columnLabel, map.get(typeName));
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Ref.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Blob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Clob.class);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Array.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(this.metaData.getColumnLabel(columnIndex), cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.ensureOpen();
        try {
            Date date = this.getObject(columnLabel, Date.class);
            if (date != null) {
                Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
                c.clear();
                LocalDate ld = date.toLocalDate();
                c.set(ld.getYear(), ld.getMonthValue() - 1, ld.getDayOfMonth(), 0, 0, 0);
                date = new Date(c.getTimeInMillis());
            }
            return date;
        }
        catch (Exception e) {
            throw new SQLException(String.format("Method: getDate(\"%s\") encountered an exception.", columnLabel), e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(this.metaData.getColumnLabel(columnIndex), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.ensureOpen();
        try {
            Time time = this.getObject(columnLabel, Time.class);
            if (time != null) {
                Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
                c.clear();
                LocalTime ld = time.toLocalTime();
                c.set(1970, 0, 1, ld.getHour(), ld.getMinute(), ld.getSecond());
                time = new Time(c.getTimeInMillis());
            }
            return time;
        }
        catch (Exception e) {
            throw new SQLException(String.format("Method: getTime(\"%s\") encountered an exception.", columnLabel), e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(this.metaData.getColumnLabel(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.ensureOpen();
        try {
            Timestamp timestamp = this.getObject(columnLabel, Timestamp.class);
            if (timestamp != null) {
                Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
                c.clear();
                LocalDateTime ldt = timestamp.toLocalDateTime();
                c.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
                timestamp = new Timestamp(c.getTimeInMillis());
                timestamp.setNanos(ldt.getNano());
                return timestamp;
            }
            return timestamp;
        }
        catch (Exception e) {
            throw new SQLException(String.format("Method: getTimestamp(\"%s\") encountered an exception.", columnLabel), e);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getURL(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, URL.class);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getRowId(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, RowId.class);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.getNClob(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, NClob.class);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.getSQLXML(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, SQLXML.class);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getNString(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, String.class);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getNCharacterStream(this.metaData.getColumnLabel(columnIndex));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Reader.class);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getObject(this.metaData.getColumnLabel(columnIndex), type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.ensureOpen();
        return (T)this.getObjectImpl(columnLabel, type, null);
    }

    private Object getObjectImpl(String columnLabel, Class<?> type, Object nullValue) throws SQLException {
        Object value = this.record.get(columnLabel);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return nullValue;
        }
        return JdbcUtils.convert(value, type);
    }

    private void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed.", "08000");
        }
    }
}

