/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.local;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.map.DatabaseConnectionMap;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionBuilder;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.pipeline.engine.PipelineEnginePlugin;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngineCapabilities;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;

@PipelineEnginePlugin(id="Local", name="Hop local pipeline engine", description="Executes your pipeline locally in a multi-threaded fashion")
public class LocalPipelineEngine
extends Pipeline
implements IPipelineEngine<PipelineMeta> {
    private PipelineEngineCapabilities engineCapabilities = new LocalPipelineEngineCapabilities();
    private ExecutionInfoLocation executionInfoLocation;
    private Timer transformExecutionInfoTimer;
    private Map<String, List<IExecutionDataSamplerStore>> samplerStoresMap;

    public LocalPipelineEngine() {
        this.setDefaultRunConfiguration();
    }

    public LocalPipelineEngine(PipelineMeta pipelineMeta) {
        super(pipelineMeta);
        this.setDefaultRunConfiguration();
    }

    public LocalPipelineEngine(PipelineMeta pipelineMeta, IVariables variables, ILoggingObject parent) {
        super(pipelineMeta, variables, parent);
        this.setDefaultRunConfiguration();
    }

    public <Parent extends IVariables & INamedParameters> LocalPipelineEngine(Parent parent, String name, String filename, IHopMetadataProvider metadataProvider) throws HopException {
        super(parent, name, filename, metadataProvider);
        this.setDefaultRunConfiguration();
    }

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        return new LocalPipelineRunConfiguration();
    }

    private void setDefaultRunConfiguration() {
        this.setPipelineRunConfiguration(new PipelineRunConfiguration("local", "", "", new ArrayList<DescribedVariable>(), this.createDefaultPipelineEngineRunConfiguration(), null, false));
    }

    @Override
    public void prepareExecution() throws HopException {
        if (!(this.pipelineRunConfiguration.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) {
            throw new HopException("A local pipeline execution expects a local pipeline configuration, not an instance of class " + this.pipelineRunConfiguration.getEngineRunConfiguration().getClass().getName());
        }
        LocalPipelineRunConfiguration config = (LocalPipelineRunConfiguration)this.pipelineRunConfiguration.getEngineRunConfiguration();
        int sizeRowsSet = Const.toInt((String)this.resolve(config.getRowSetSize()), (int)10000);
        this.setRowSetSize(sizeRowsSet);
        this.setSafeModeEnabled(config.isSafeModeEnabled());
        this.setSortingTransformsTopologically(config.isSortingTransformsTopologically());
        this.setGatheringMetrics(config.isGatheringMetrics());
        this.setFeedbackShown(config.isFeedbackShown());
        this.setFeedbackSize(Const.toInt((String)this.resolve(config.getFeedbackSize()), (int)50000));
        Object parentExtensionData = this.getParentPipeline();
        if (parentExtensionData == null) {
            parentExtensionData = this.getParentWorkflow();
        }
        Object connectionGroup = null;
        if (parentExtensionData != null) {
            connectionGroup = (String)parentExtensionData.getExtensionDataMap().get("CONNECTION_GROUP");
        }
        if (config.isTransactional() && connectionGroup == null) {
            connectionGroup = this.getPipelineMeta().getName() + " - " + UUID.randomUUID();
            this.addExecutionFinishedListener((T pipeline) -> {
                String group = (String)pipeline.getExtensionDataMap().get("CONNECTION_GROUP");
                List databases = DatabaseConnectionMap.getInstance().getDatabases(group);
                Result result = pipeline.getResult();
                for (Database database : databases) {
                    block13: {
                        try {
                            if (result.getResult() && !result.isStopped() && result.getNrErrors() == 0L) {
                                try {
                                    database.commit(true);
                                    pipeline.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were committed at the end of the pipeline!");
                                    break block13;
                                }
                                catch (HopDatabaseException e) {
                                    throw new HopException("Error committing database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                                }
                            }
                            try {
                                database.rollback(true);
                                pipeline.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were rolled back at the end of the pipeline!");
                            }
                            catch (HopDatabaseException e) {
                                throw new HopException("Error rolling back database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                            }
                        }
                        finally {
                            try {
                                database.closeConnectionOnly();
                                pipeline.getLogChannel().logDebug("Database connection '" + database.getDatabaseMeta().getName() + "' closed successfully!");
                            }
                            catch (HopDatabaseException hde) {
                                pipeline.getLogChannel().logError("Error disconnecting from database - closeConnectionOnly failed:" + Const.CR + hde.getMessage());
                                pipeline.getLogChannel().logError(Const.getStackTracker((Throwable)hde));
                            }
                        }
                    }
                    DatabaseConnectionMap.getInstance().removeConnection(group, null, database);
                }
            });
        }
        if (connectionGroup != null && this.getExtensionDataMap() != null) {
            this.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
        }
        super.prepareExecution();
        this.lookupExecutionInformationLocation();
        this.registerPipelineExecutionInformation();
        this.addTransformExecutionSamplers();
    }

    public void registerPipelineExecutionInformation() throws HopException {
        if (this.executionInfoLocation != null) {
            this.executionInfoLocation.getExecutionInfoLocation().registerExecution(ExecutionBuilder.fromExecutor(this).build());
            for (TransformMetaDataCombi c : this.getTransforms()) {
                this.executionInfoLocation.getExecutionInfoLocation().registerExecution(ExecutionBuilder.fromTransform(this, c.transform).build());
            }
        }
    }

    public void addTransformExecutionSamplers() throws HopException {
        if (this.executionInfoLocation == null) {
            return;
        }
        String profileName = this.resolve(this.pipelineRunConfiguration.getExecutionDataProfileName());
        if (StringUtils.isEmpty((String)profileName)) {
            return;
        }
        ExecutionDataProfile profile = (ExecutionDataProfile)this.metadataProvider.getSerializer(ExecutionDataProfile.class).load(profileName);
        if (profile == null) {
            this.log.logError("Unable to find data profile '" + profileName + "' (non-fatal)");
            return;
        }
        ArrayList<IExecutionDataSampler> samplers = new ArrayList<IExecutionDataSampler>();
        samplers.addAll(profile.getSamplers());
        samplers.addAll(this.dataSamplers);
        if (samplers.isEmpty()) {
            return;
        }
        this.samplerStoresMap = new HashMap<String, List<IExecutionDataSamplerStore>>();
        for (TransformMetaDataCombi combi : this.getTransforms()) {
            ArrayList samplerStores = new ArrayList();
            this.samplerStoresMap.put(combi.transformName, samplerStores);
            for (IExecutionDataSampler sampler : samplers) {
                boolean firstTransform = this.pipelineMeta.findPreviousTransforms(combi.transformMeta).isEmpty();
                boolean lastTransform = this.pipelineMeta.findNextTransforms(combi.transformMeta).isEmpty();
                ExecutionDataSamplerMeta samplerMeta = new ExecutionDataSamplerMeta(combi.transformName, Integer.toString(combi.copy), combi.transform.getLogChannelId(), firstTransform, lastTransform);
                Object samplerStore = sampler.createSamplerStore(samplerMeta);
                IRowMeta inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, combi.transformMeta);
                IRowMeta outputRowMeta = this.getPipelineMeta().getTransformFields((IVariables)this, combi.transformMeta);
                samplerStore.init(this, inputRowMeta, outputRowMeta);
                IRowListener rowListener = samplerStore.createRowListener(sampler);
                samplerStores.add(samplerStore);
                combi.transform.addRowListener(rowListener);
            }
        }
    }

    @Override
    public void startThreads() throws HopException {
        this.startTransformExecutionInfoTimer();
        super.startThreads();
    }

    @Override
    public void waitUntilFinished() {
        super.waitUntilFinished();
    }

    public void startTransformExecutionInfoTimer() throws HopException {
        ExecutionDataProfile dataProfile;
        if (this.executionInfoLocation == null) {
            return;
        }
        String profileName = this.resolve(this.pipelineRunConfiguration.getExecutionDataProfileName());
        if (StringUtils.isNotEmpty((String)profileName)) {
            dataProfile = (ExecutionDataProfile)this.metadataProvider.getSerializer(ExecutionDataProfile.class).load(profileName);
            if (dataProfile == null) {
                this.log.logError("Unable to find data profile '" + profileName + "' (non-fatal)");
            }
        } else {
            dataProfile = null;
        }
        long delay = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingDelay()), (long)2000L);
        long interval = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingInterval()), (long)5000L);
        final IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
        TimerTask sampleTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (dataProfile != null) {
                        ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.fromAllTransformData(LocalPipelineEngine.this, LocalPipelineEngine.this.samplerStoresMap, false);
                        iLocation.registerData(dataBuilder.build());
                    }
                    ExecutionState pipelineState = ExecutionStateBuilder.fromExecutor(LocalPipelineEngine.this, (Integer)-1).build();
                    iLocation.updateExecutionState(pipelineState);
                    for (IEngineComponent component : LocalPipelineEngine.this.getComponents()) {
                        ExecutionState transformState = ExecutionStateBuilder.fromTransform(LocalPipelineEngine.this, component).build();
                        iLocation.updateExecutionState(transformState);
                    }
                }
                catch (Exception e) {
                    LocalPipelineEngine.this.log.logBasic("Warning: unable to register execution info (data and state) at location " + LocalPipelineEngine.this.executionInfoLocation.getName() + "(non-fatal)");
                }
            }
        };
        this.transformExecutionInfoTimer = new Timer();
        this.transformExecutionInfoTimer.schedule(sampleTask, delay, interval);
    }

    public void lookupExecutionInformationLocation() throws HopException {
        String locationName = this.resolve(this.pipelineRunConfiguration.getExecutionInfoLocationName());
        if (StringUtils.isNotEmpty((String)locationName)) {
            ExecutionInfoLocation location = (ExecutionInfoLocation)this.metadataProvider.getSerializer(ExecutionInfoLocation.class).load(locationName);
            if (location != null) {
                this.executionInfoLocation = location;
                this.executionInfoLocation.getExecutionInfoLocation().initialize(this, this.metadataProvider);
            } else {
                this.log.logError("Execution information location '" + locationName + "' could not be found in the metadata");
            }
        }
    }

    @Override
    public void pipelineCompleted() throws HopException {
        this.stopTransformExecutionInfoTimer();
    }

    public void stopTransformExecutionInfoTimer() {
        try {
            if (this.transformExecutionInfoTimer != null) {
                this.transformExecutionInfoTimer.cancel();
            }
            if (this.executionInfoLocation == null) {
                return;
            }
            IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
            String dataProfileName = this.resolve(this.pipelineRunConfiguration.getExecutionDataProfileName());
            if (StringUtils.isNotEmpty((String)dataProfileName)) {
                ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.fromAllTransformData(this, this.samplerStoresMap, true);
                iLocation.registerData(dataBuilder.build());
            }
            ExecutionState executionState = ExecutionStateBuilder.fromExecutor(this, (Integer)-1).build();
            iLocation.updateExecutionState(executionState);
            for (IEngineComponent component : this.getComponents()) {
                ExecutionState transformState = ExecutionStateBuilder.fromTransform(this, component).build();
                iLocation.updateExecutionState(transformState);
            }
            this.executionInfoLocation.getExecutionInfoLocation().close();
        }
        catch (Exception e) {
            this.log.logError("Error handling writing final pipeline state to location (non-fatal)", (Throwable)e);
        }
    }

    @Override
    public PipelineEngineCapabilities getEngineCapabilities() {
        return this.engineCapabilities;
    }

    public void setEngineCapabilities(PipelineEngineCapabilities engineCapabilities) {
        this.engineCapabilities = engineCapabilities;
    }

    @Override
    public String getStatusDescription() {
        return super.getStatus();
    }
}

