/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RegexEvalHelperDialog
extends Dialog {
    private static final Class<?> PKG = RegexEvalMeta.class;
    private final IVariables variables;
    private Shell shell;
    private final PropsUi props;
    private String regexScript;
    private final String regexOptions;
    private final boolean canonicalEqualityFlagSet;
    private StyledTextComp wRegExScript;
    private Text wValue1;
    private Text wValue2;
    private Text wValue3;
    private Text wRegExScriptCompile;
    private List wGroups;
    private Label wlGroups;
    private Text wValueGroup;
    GuiResource guiresource = GuiResource.getInstance();
    private boolean errorDisplayed;

    public RegexEvalHelperDialog(Shell parent, IVariables variables, String regexScript, String regexOptions, boolean canonicalEqualityFlagSet) {
        super(parent, 0);
        this.variables = variables;
        this.props = PropsUi.getInstance();
        this.regexScript = regexScript;
        this.regexOptions = regexOptions;
        this.errorDisplayed = false;
        this.canonicalEqualityFlagSet = canonicalEqualityFlagSet;
    }

    private boolean isCanonicalEqualityFlagSet() {
        return this.canonicalEqualityFlagSet;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(this.guiresource.getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Shell.Label", (String[])new String[0]));
        RegexEvalHelperDialog regexEvalHelperDialog = this;
        int margin = regexEvalHelperDialog.props.getMargin();
        int middle = 30;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        CTabFolder wNoteFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wNoteFolder, (int)4);
        CTabItem wNoteContentTab = new CTabItem(wNoteFolder, 0);
        wNoteContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wNoteContentTab.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.RegExTab.Label", (String[])new String[0]));
        Composite wNoteContentComp = new Composite((Composite)wNoteFolder, 0);
        PropsUi.setLook((Widget)wNoteContentComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteContentComp.setLayout((Layout)fileLayout);
        Label wlRegExScript = new Label(wNoteContentComp, 131072);
        wlRegExScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRegExScript);
        FormData fdlRegExScript = new FormData();
        fdlRegExScript.left = new FormAttachment(0, 0);
        fdlRegExScript.top = new FormAttachment(0, 2 * margin);
        wlRegExScript.setLayoutData((Object)fdlRegExScript);
        this.wRegExScript = new StyledTextComp(this.variables, wNoteContentComp, 19202);
        this.wRegExScript.setText("");
        PropsUi.setLook((Widget)this.wRegExScript, (int)1);
        PropsUi.setLook((Widget)this.wRegExScript);
        FormData fdRegExScript = new FormData();
        fdRegExScript.left = new FormAttachment(0, 0);
        fdRegExScript.top = new FormAttachment((Control)wlRegExScript, 2 * margin);
        fdRegExScript.right = new FormAttachment(100, -2 * margin);
        fdRegExScript.bottom = new FormAttachment(40, -margin);
        this.wRegExScript.setLayoutData((Object)fdRegExScript);
        this.wRegExScriptCompile = new Text(wNoteContentComp, 18946);
        this.wRegExScriptCompile.setText("");
        PropsUi.setLook((Widget)this.wRegExScriptCompile, (int)1);
        FormData fdRegExScriptCompile = new FormData();
        fdRegExScriptCompile.left = new FormAttachment(0, 0);
        fdRegExScriptCompile.top = new FormAttachment((Control)this.wRegExScript, margin);
        fdRegExScriptCompile.right = new FormAttachment(100, 0);
        this.wRegExScriptCompile.setLayoutData((Object)fdRegExScriptCompile);
        this.wRegExScriptCompile.setEditable(false);
        this.wRegExScriptCompile.setFont(this.guiresource.getFontNote());
        Group wValuesGroup = new Group(wNoteContentComp, 32);
        PropsUi.setLook((Widget)wValuesGroup);
        wValuesGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.TestValues.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wValuesGroup.setLayout((Layout)groupLayout);
        Label wlValue1 = new Label((Composite)wValuesGroup, 131072);
        wlValue1.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value1.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue1);
        FormData fdlValue1 = new FormData();
        fdlValue1.left = new FormAttachment(0, 0);
        fdlValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdlValue1.right = new FormAttachment(middle, -margin);
        wlValue1.setLayoutData((Object)fdlValue1);
        this.wValue1 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue1);
        FormData fdValue1 = new FormData();
        fdValue1.left = new FormAttachment(middle, margin);
        fdValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdValue1.right = new FormAttachment(100, -margin);
        this.wValue1.setLayoutData((Object)fdValue1);
        Label wlValue2 = new Label((Composite)wValuesGroup, 131072);
        wlValue2.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value2.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue2);
        FormData fdlValue2 = new FormData();
        fdlValue2.left = new FormAttachment(0, 0);
        fdlValue2.top = new FormAttachment((Control)this.wValue1, margin);
        fdlValue2.right = new FormAttachment(middle, -margin);
        wlValue2.setLayoutData((Object)fdlValue2);
        this.wValue2 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue2);
        FormData fdValue2 = new FormData();
        fdValue2.left = new FormAttachment(middle, margin);
        fdValue2.top = new FormAttachment((Control)this.wValue1, margin);
        fdValue2.right = new FormAttachment(100, -margin);
        this.wValue2.setLayoutData((Object)fdValue2);
        Label wlValue3 = new Label((Composite)wValuesGroup, 131072);
        wlValue3.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value3.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue3);
        FormData fdlValue3 = new FormData();
        fdlValue3.left = new FormAttachment(0, 0);
        fdlValue3.top = new FormAttachment((Control)this.wValue2, margin);
        fdlValue3.right = new FormAttachment(middle, -margin);
        wlValue3.setLayoutData((Object)fdlValue3);
        this.wValue3 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue3);
        FormData fdValue3 = new FormData();
        fdValue3.left = new FormAttachment(middle, margin);
        fdValue3.top = new FormAttachment((Control)this.wValue2, margin);
        fdValue3.right = new FormAttachment(100, -margin);
        this.wValue3.setLayoutData((Object)fdValue3);
        FormData fdValuesGroup = new FormData();
        fdValuesGroup.left = new FormAttachment(0, margin);
        fdValuesGroup.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdValuesGroup.right = new FormAttachment(100, -margin);
        wValuesGroup.setLayoutData((Object)fdValuesGroup);
        Group wCaptureGroups = new Group(wNoteContentComp, 32);
        PropsUi.setLook((Widget)wCaptureGroups);
        wCaptureGroups.setText("Capture");
        FormLayout captureLayout = new FormLayout();
        captureLayout.marginWidth = 10;
        captureLayout.marginHeight = 10;
        wCaptureGroups.setLayout((Layout)captureLayout);
        Label wlValueGroup = new Label((Composite)wCaptureGroups, 131072);
        wlValueGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ValueGroup.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValueGroup);
        FormData fdlValueGroup = new FormData();
        fdlValueGroup.left = new FormAttachment(0, 0);
        fdlValueGroup.top = new FormAttachment((Control)wValuesGroup, margin);
        fdlValueGroup.right = new FormAttachment(middle, -margin);
        wlValueGroup.setLayoutData((Object)fdlValueGroup);
        this.wValueGroup = new Text((Composite)wCaptureGroups, 18436);
        PropsUi.setLook((Widget)this.wValueGroup);
        FormData fdValueGroup = new FormData();
        fdValueGroup.left = new FormAttachment(middle, margin);
        fdValueGroup.top = new FormAttachment((Control)wValuesGroup, margin);
        fdValueGroup.right = new FormAttachment(100, -margin);
        this.wValueGroup.setLayoutData((Object)fdValueGroup);
        this.wlGroups = new Label((Composite)wCaptureGroups, 131072);
        this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.GroupFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlGroups);
        FormData fdlGroups = new FormData();
        fdlGroups.left = new FormAttachment(0, 0);
        fdlGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        fdlGroups.right = new FormAttachment(middle, -margin);
        this.wlGroups.setLayoutData((Object)fdlGroups);
        this.wGroups = new List((Composite)wCaptureGroups, 19204);
        PropsUi.setLook((Widget)this.wValue3);
        FormData fdGroups = new FormData();
        fdGroups.left = new FormAttachment(middle, margin);
        fdGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        fdGroups.right = new FormAttachment(100, -margin);
        fdGroups.bottom = new FormAttachment(100, -margin);
        this.wGroups.setLayoutData((Object)fdGroups);
        FormData fdCaptureGroups = new FormData();
        fdCaptureGroups.left = new FormAttachment(0, margin);
        fdCaptureGroups.top = new FormAttachment((Control)wValuesGroup, margin);
        fdCaptureGroups.right = new FormAttachment(100, -margin);
        fdCaptureGroups.bottom = new FormAttachment(100, -margin);
        wCaptureGroups.setLayoutData((Object)fdCaptureGroups);
        FormData fdNoteContentComp = new FormData();
        fdNoteContentComp.left = new FormAttachment(0, 0);
        fdNoteContentComp.top = new FormAttachment(0, 0);
        fdNoteContentComp.right = new FormAttachment(100, 0);
        fdNoteContentComp.bottom = new FormAttachment(100, 0);
        wNoteContentComp.setLayoutData((Object)fdNoteContentComp);
        wNoteContentComp.layout();
        wNoteContentTab.setControl((Control)wNoteContentComp);
        FormData fdNoteFolder = new FormData();
        fdNoteFolder.left = new FormAttachment(0, 0);
        fdNoteFolder.top = new FormAttachment(0, margin);
        fdNoteFolder.right = new FormAttachment(100, 0);
        fdNoteFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wNoteFolder.setLayoutData((Object)fdNoteFolder);
        this.wValue1.addModifyListener(e -> this.testValue(1, true, null));
        this.wValue2.addModifyListener(e -> this.testValue(2, true, null));
        this.wValue3.addModifyListener(e -> this.testValue(3, true, null));
        this.wValueGroup.addModifyListener(e -> this.testValue(4, true, null));
        this.wRegExScript.addModifyListener(e -> {
            this.errorDisplayed = false;
            this.testValues();
        });
        this.getData();
        wNoteFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.regexScript;
    }

    private void testValues() {
        String realScript = this.variables.resolve(this.wRegExScript.getText());
        for (int i = 1; i < 5; ++i) {
            this.testValue(i, false, realScript);
        }
    }

    private void testValue(int index, boolean testRegEx, String regExString) {
        block17: {
            Text control;
            String realValue;
            String realScript = regExString;
            if (realScript == null) {
                realScript = this.variables.resolve(this.wRegExScript.getText());
            }
            if (Utils.isEmpty((CharSequence)realScript)) {
                if (testRegEx) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Title", (String[])new String[0]));
                    mb.open();
                }
                return;
            }
            switch (index) {
                case 1: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue1.getText()), (String)"");
                    control = this.wValue1;
                    break;
                }
                case 2: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue2.getText()), (String)"");
                    control = this.wValue2;
                    break;
                }
                case 3: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue3.getText()), (String)"");
                    control = this.wValue3;
                    break;
                }
                case 4: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValueGroup.getText()), (String)"");
                    control = this.wValueGroup;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                Pattern p = this.isCanonicalEqualityFlagSet() ? Pattern.compile(this.regexOptions + realScript, 128) : Pattern.compile(this.regexOptions + realScript);
                Matcher m = p.matcher(Const.NVL((String)realValue, (String)""));
                boolean isMatch = m.matches();
                if (isMatch) {
                    control.setBackground(this.guiresource.getColorGreen());
                } else {
                    control.setBackground(this.guiresource.getColorRed());
                }
                if (index == 4) {
                    this.wGroups.removeAll();
                    int nrFields = m.groupCount();
                    int nr = 0;
                    for (int i = 1; i <= nrFields; ++i) {
                        if (m.group(i) == null) {
                            this.wGroups.add("");
                        } else {
                            this.wGroups.add(m.group(i));
                        }
                        ++nr;
                    }
                    this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.FieldsGroup", (Object[])new Object[]{nr}));
                }
                this.wRegExScriptCompile.setForeground(this.guiresource.getColorBlue());
                this.wRegExScriptCompile.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ScriptSuccessfullyCompiled", (String[])new String[0]));
                this.wRegExScriptCompile.setToolTipText("");
            }
            catch (Exception e) {
                if (this.errorDisplayed) break block17;
                this.wRegExScriptCompile.setForeground(this.guiresource.getColorRed());
                this.wRegExScriptCompile.setText(e.getMessage());
                this.wRegExScriptCompile.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ErrorCompiling.Message", (String[])new String[0]) + Const.CR + e);
                this.errorDisplayed = true;
            }
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.regexScript != null) {
            this.wRegExScript.setText(this.regexScript);
        }
    }

    private void cancel() {
        this.dispose();
    }

    private void ok() {
        if (this.wRegExScript.getText() != null) {
            this.regexScript = this.wRegExScript.getText();
        }
        this.dispose();
    }
}

