/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class FixedPrecisionNumeric
extends PassThroughLogicalType<BigDecimal> {
    public static final String IDENTIFIER = "beam:logical_type:fixed_decimal:v1";
    public static final String BASE_IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.DECIMAL.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private static final Schema SCHEMA = Schema.builder().addInt32Field("precision").addInt32Field("scale").build();
    private final int precision;
    private final int scale;

    public static FixedPrecisionNumeric of(int precision, int scale) {
        return new FixedPrecisionNumeric(precision, scale);
    }

    public static FixedPrecisionNumeric of(int scale) {
        return FixedPrecisionNumeric.of(-1, scale);
    }

    public static FixedPrecisionNumeric of(Row row) {
        Preconditions.checkArgument((boolean)row.getSchema().assignableTo(SCHEMA), (String)"Row has an incompatible schema to construct the logical type object: %s", (Object)row.getSchema());
        Integer precision = row.getInt32("precision");
        Integer scale = row.getInt32("scale");
        Preconditions.checkArgument((precision != null && scale != null ? 1 : 0) != 0, (Object)"precision and scale cannot be null for FixedPrecisionNumeric arguments.");
        return FixedPrecisionNumeric.of((Integer)MoreObjects.firstNonNull((Object)precision, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)scale, (Object)0));
    }

    private FixedPrecisionNumeric(int precision, int scale) {
        super(IDENTIFIER, Schema.FieldType.row(SCHEMA), Row.withSchema(SCHEMA).addValues(precision, scale).build(), Schema.FieldType.DECIMAL);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public BigDecimal toInputType(BigDecimal base) {
        if (this.precision != -1) {
            Preconditions.checkArgument((base == null || base.precision() <= this.precision && base.scale() <= this.scale || base.round(new MathContext(this.precision)).compareTo(base) == 0 ? 1 : 0) != 0, (String)"Expected BigDecimal base to be null or have precision <= %s (was %s), scale <= %s (was %s)", (Object)this.precision, (Object)(base == null ? null : Integer.valueOf(base.precision())), (Object)this.scale, base == null ? null : Integer.valueOf(base.scale()));
        }
        return base;
    }
}

