/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class RecomputingSupplier<T> {
    private final Supplier<T> supplier;
    private final AtomicReference<CompletableFuture<T>> cached = new AtomicReference<Object>(null);
    private final AtomicBoolean workInProgress = new AtomicBoolean(false);
    private final ExecutorService executor;

    public RecomputingSupplier(Supplier<T> supplier, ExecutorService executor) {
        this.supplier = supplier;
        this.executor = executor;
    }

    public void recompute() {
        CompletableFuture<T> current = this.cached.get();
        boolean origWip = this.workInProgress.get();
        if (origWip || current != null && !current.isDone()) {
            if (this.cached.get() != current) {
                this.executor.submit(this::recompute);
            }
            return;
        }
        assert (current == null || current.isDone());
        CompletableFuture lazyValue = new CompletableFuture();
        if (this.cached.compareAndSet(current, lazyValue)) {
            this.executor.submit(() -> this.doWork(lazyValue));
        } else {
            this.executor.submit(this::recompute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(CompletableFuture<T> lazyValue) {
        Object value = null;
        Throwable err = null;
        try {
            RecomputingSupplier.sanityCheck(this.workInProgress.compareAndSet(false, true));
            value = this.supplier.get();
        }
        catch (Throwable t) {
            err = t;
        }
        finally {
            RecomputingSupplier.sanityCheck(this.workInProgress.compareAndSet(true, false));
        }
        if (err == null) {
            lazyValue.complete(value);
        } else {
            lazyValue.completeExceptionally(err);
        }
    }

    private static void sanityCheck(boolean check) {
        assert (check) : "At most one task should be executing using this executor";
    }

    public T get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<T> lazyValue = this.cached.get();
        if (lazyValue == null) {
            return null;
        }
        return lazyValue.get(timeout, timeUnit);
    }

    public String toString() {
        return "RecomputingSupplier{supplier=" + this.supplier + ", cached=" + this.cached + ", workInProgress=" + this.workInProgress + ", executor=" + this.executor + '}';
    }
}

