/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSList;
import com.ibm.as400.vaccess.ResourceLoader;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Hashtable;

public class IFSFileDialog
extends Dialog {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Label label1;
    IFSList directoryList;
    private Label label2;
    IFSList fileList;
    private Label label3;
    TextField fileName;
    private Label label4;
    Choice fileType;
    Button open;
    Button cancel;
    private Label currentDirectory;
    TextField status;
    AS400 sys_;
    int state_;
    Hashtable filters_;
    private Listeners listener_ = new Listeners();
    private static String READY_TEXT = ResourceLoader.getPrintText("READY");
    private static String WORKING_TEXT = ResourceLoader.getText("EVT_NAME_WORKING");
    public static final int ACTIVE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;

    public IFSFileDialog(Frame frame, String string, AS400 aS400) {
        super(frame, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.setLayout(gridBagLayout);
        ((Component)this).setBackground(Color.lightGray);
        String string2 = ResourceLoader.getText("IFS_DIRECTORY");
        this.label1 = new Label(string2, 0);
        this.add(this.label1, gridBagLayout, gridBagConstraints, 0, 0, 3, 1);
        this.directoryList = new IFSList();
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 90;
        this.add(this.directoryList, gridBagLayout, gridBagConstraints, 0, 1, 3, 5);
        string2 = ResourceLoader.getText("IFS_FILE");
        this.label2 = new Label(string2, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add(this.label2, gridBagLayout, gridBagConstraints, 3, 0, 3, 1);
        this.fileList = new IFSList();
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 90;
        this.add(this.fileList, gridBagLayout, gridBagConstraints, 3, 1, 3, 5);
        string2 = ResourceLoader.getText("IFS_FILE_NAME");
        this.label3 = new Label(string2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add(this.label3, gridBagLayout, gridBagConstraints, 0, 7, 1, 1);
        this.fileName = new TextField(21);
        this.add(this.fileName, gridBagLayout, gridBagConstraints, 1, 7, 5, 1);
        string2 = ResourceLoader.getPrintText("TYPE");
        this.label4 = new Label(string2);
        this.add(this.label4, gridBagLayout, gridBagConstraints, 0, 8, 1, 1);
        this.fileType = new Choice();
        this.add(this.fileType, gridBagLayout, gridBagConstraints, 1, 8, 5, 1);
        string2 = ResourceLoader.getPrintText("OPEN");
        this.open = new Button(string2);
        gridBagConstraints.ipadx = 20;
        this.add(this.open, gridBagLayout, gridBagConstraints, 6, 0, 3, 1);
        string2 = ResourceLoader.getText("DLG_CANCEL");
        this.cancel = new Button(string2);
        this.add(this.cancel, gridBagLayout, gridBagConstraints, 6, 1, 3, 1);
        this.currentDirectory = new Label("/");
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add(this.currentDirectory, gridBagLayout, gridBagConstraints, 0, 6, 6, 1);
        this.status = new TextField(44);
        this.add(this.status, gridBagLayout, gridBagConstraints, 0, 9, 9, 1);
        this.pack();
        this.status.setEditable(false);
        this.sys_ = aS400;
        this.directoryList.setSystem(this.sys_);
        this.fileList.setSystem(this.sys_);
        this.directoryList.setSort(true);
        this.fileList.setSort(true);
        this.directoryList.setListType(1);
        this.fileList.setListType(2);
        this.filters_ = new Hashtable();
        string2 = ResourceLoader.getText("IFS_ALL_FILES_FILTER");
        this.filters_.put(string2, "*.*");
        this.fileType.addItem(string2);
        this.open.addActionListener(this.listener_);
        this.cancel.addActionListener(this.listener_);
        this.directoryList.addActionListener(this.listener_);
        this.fileList.addActionListener(this.listener_);
        this.fileList.addItemListener(this.listener_);
        this.addWindowListener(this.listener_);
        this.fileType.addItemListener(this.listener_);
        this.label1.addKeyListener(this.listener_);
        this.directoryList.addKeyListener(this.listener_);
        this.label2.addKeyListener(this.listener_);
        this.fileList.addKeyListener(this.listener_);
        this.label3.addKeyListener(this.listener_);
        this.fileName.addKeyListener(this.listener_);
        this.label4.addKeyListener(this.listener_);
        this.fileType.addKeyListener(this.listener_);
        this.open.addKeyListener(this.listener_);
        this.cancel.addKeyListener(this.listener_);
        this.currentDirectory.addKeyListener(this.listener_);
        this.status.addKeyListener(this.listener_);
        this.addKeyListener(this.listener_);
        this.directoryList.addErrorListener(this.listener_);
        this.fileList.addErrorListener(this.listener_);
        this.status.setText(READY_TEXT);
        this.setResizable(false);
        this.state_ = 0;
    }

    protected void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public String getAbsolutePath() {
        if (this.state_ != 2) {
            return this.getDirectory() + "/" + this.getFileName();
        }
        return "";
    }

    public String getCancelButtonText() {
        return this.cancel.getLabel();
    }

    public String getFileName() {
        if (this.state_ != 2) {
            return this.fileName.getText();
        }
        return "";
    }

    public FileFilter getFileFilter() {
        String string = this.fileType.getSelectedItem();
        String string2 = (String)this.filters_.get(string);
        return new FileFilter(string, string2);
    }

    public String getOkButtonText() {
        return this.open.getLabel();
    }

    public String getDirectory() {
        if (this.state_ != 2) {
            return this.directoryList.getPath();
        }
        return "";
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public void setCancelButtonText(String string) {
        this.cancel.setLabel(string);
    }

    public void setFileName(String string) {
        this.fileName.setText(string);
    }

    public void setFileFilter(FileFilter[] fileFilterArray, int n) {
        this.fileType.removeAll();
        this.filters_ = new Hashtable();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            this.fileType.addItem(fileFilterArray[i].getDescription());
            this.filters_.put(fileFilterArray[i].getDescription(), fileFilterArray[i].getPattern());
        }
        this.fileType.select(n);
        this.fileList.setFilter(fileFilterArray[n].getPattern());
    }

    public void setOkButtonText(String string) {
        this.open.setLabel(string);
    }

    public void setDirectory(String string) {
        this.directoryList.setPath(string);
        this.fileList.setPath(string);
    }

    void selectDirList() {
        String string = this.directoryList.getPath();
        String string2 = this.directoryList.getSelectedItem();
        if (string2 == null) {
            return;
        }
        this.directoryList.setEnabled(false);
        this.fileList.setEnabled(false);
        if (string2.compareTo(".") == 0) {
            this.status.setText(WORKING_TEXT);
            try {
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
            }
            catch (Exception exception) {
                this.status.setText(exception.toString());
            }
            this.showCurrentDir(this.fileList.getPath());
        } else if (string2.compareTo("..") == 0) {
            int n = string.lastIndexOf("/");
            String string3 = n != 0 ? string.substring(0, n) : "/";
            try {
                this.directoryList.setPath(string3);
                this.status.setText(WORKING_TEXT);
                this.directoryList.populateList();
                this.fileList.setPath(string3);
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
                this.showCurrentDir(string3);
            }
            catch (Exception exception) {
                this.status.setText(exception.toString());
            }
        } else {
            String string4 = string.compareTo("/") != 0 ? string + "/" + string2 : string + string2;
            try {
                this.directoryList.setPath(string4);
                this.fileList.setPath(string4);
                this.status.setText(WORKING_TEXT);
                this.directoryList.populateList();
                this.fileList.populateList();
                this.status.setText(READY_TEXT);
                this.showCurrentDir(string4);
            }
            catch (Exception exception) {
                this.status.setText(exception.toString());
            }
        }
        this.directoryList.setEnabled(true);
        this.fileList.setEnabled(true);
    }

    public void setVisible() {
        IFSList iFSList = null;
        try {
            iFSList = this.directoryList;
            iFSList.populateList();
            iFSList = this.fileList;
            iFSList.populateList();
            iFSList = this.directoryList;
            this.showCurrentDir(iFSList.getPath());
        }
        catch (Exception exception) {
            String string = null;
            if (iFSList != null) {
                String string2 = ResourceLoader.getText("PROP_NAME_PATH");
                String string3 = ResourceLoader.getText("PROP_NAME_FILTER");
                string = "(" + string2 + "=" + iFSList.getPath() + ", " + string3 + "=" + iFSList.getFilter() + ") ";
            } else {
                string = "";
            }
            this.status.setText(string + exception.toString());
        }
        super.setVisible(true);
    }

    public int showDialog() {
        this.setVisible();
        return this.state_;
    }

    private void showCurrentDir(String string) {
        this.currentDirectory.setText("//" + this.sys_.getSystemName() + string);
    }

    class Listeners
    implements WindowListener,
    ActionListener,
    ItemListener,
    KeyListener,
    ErrorListener,
    Serializable {
        Listeners() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == IFSFileDialog.this.cancel) {
                IFSFileDialog.this.fileName.setText("");
                IFSFileDialog.this.state_ = 2;
                IFSFileDialog.this.dispose();
            }
            if (object == IFSFileDialog.this.open) {
                IFSFileDialog.this.state_ = 1;
                IFSFileDialog.this.dispose();
            }
            if (object == IFSFileDialog.this.directoryList) {
                IFSFileDialog.this.selectDirList();
            }
            if (object == IFSFileDialog.this.fileList) {
                String string = IFSFileDialog.this.fileList.getSelectedItem();
                IFSFileDialog.this.fileName.setText(string);
                IFSFileDialog.this.state_ = 1;
                IFSFileDialog.this.dispose();
            }
        }

        public void errorOccurred(ErrorEvent errorEvent) {
            System.out.println(errorEvent.getException().toString());
            IFSFileDialog.this.status.setText(errorEvent.getException().toString());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == IFSFileDialog.this.fileList) {
                if (itemEvent.getStateChange() == 1) {
                    String string = IFSFileDialog.this.fileList.getSelectedItem();
                    IFSFileDialog.this.fileName.setText(string);
                }
            } else if (itemEvent.getSource() == IFSFileDialog.this.fileType) {
                String string = IFSFileDialog.this.fileType.getSelectedItem();
                IFSFileDialog.this.fileList.setFilter((String)IFSFileDialog.this.filters_.get(string));
                IFSFileDialog.this.status.setText(WORKING_TEXT);
                try {
                    IFSFileDialog.this.fileList.populateList();
                    IFSFileDialog.this.status.setText(READY_TEXT);
                }
                catch (Exception exception) {
                    IFSFileDialog.this.status.setText(exception.toString());
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            block15: {
                if (keyEvent.getKeyCode() == 10) {
                    if (keyEvent.getSource() == IFSFileDialog.this.fileName) {
                        String string = IFSFileDialog.this.fileName.getText();
                        int n = string.lastIndexOf("/");
                        if (n == -1) {
                            IFSFileDialog.this.fileList.setFilter(IFSFileDialog.this.fileName.getText());
                            IFSFileDialog.this.status.setText(WORKING_TEXT);
                            try {
                                IFSFileDialog.this.fileList.populateList();
                                IFSFileDialog.this.status.setText(READY_TEXT);
                            }
                            catch (Exception exception) {
                                IFSFileDialog.this.status.setText(exception.toString());
                            }
                        } else {
                            IFSFile iFSFile = new IFSFile(IFSFileDialog.this.sys_, string);
                            try {
                                if (iFSFile.isDirectory()) {
                                    IFSFileDialog.this.fileList.setPath(string);
                                    IFSFileDialog.this.directoryList.setPath(string);
                                    IFSFileDialog.this.status.setText(WORKING_TEXT);
                                    IFSFileDialog.this.directoryList.populateList();
                                    IFSFileDialog.this.fileList.populateList();
                                    IFSFileDialog.this.status.setText(READY_TEXT);
                                    IFSFileDialog.this.showCurrentDir(string);
                                    break block15;
                                }
                                String string2 = string.substring(0, n);
                                IFSFileDialog.this.directoryList.setPath(string2);
                                IFSFileDialog.this.fileList.setPath(string2);
                                String string3 = string.substring(n + 1);
                                IFSFileDialog.this.fileList.setFilter(string3);
                                IFSFileDialog.this.status.setText(WORKING_TEXT);
                                IFSFileDialog.this.directoryList.populateList();
                                IFSFileDialog.this.fileList.populateList();
                                IFSFileDialog.this.status.setText(READY_TEXT);
                                IFSFileDialog.this.showCurrentDir(string2);
                            }
                            catch (Exception exception) {
                                IFSFileDialog.this.status.setText(exception.toString());
                                exception.printStackTrace();
                            }
                        }
                    } else if (keyEvent.getSource() == IFSFileDialog.this.directoryList) {
                        IFSFileDialog.this.selectDirList();
                    } else if (keyEvent.getSource() == IFSFileDialog.this.cancel) {
                        IFSFileDialog.this.fileName.setText("");
                        IFSFileDialog.this.state_ = 2;
                        IFSFileDialog.this.dispose();
                    } else {
                        String string = IFSFileDialog.this.fileName.getText();
                        if (string != null && string.length() > 0) {
                            IFSFileDialog.this.state_ = 1;
                            IFSFileDialog.this.dispose();
                        }
                    }
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            IFSFileDialog.this.fileName.setText("");
            IFSFileDialog.this.state_ = 2;
            IFSFileDialog.this.dispose();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

