/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.model;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.VCS;
import org.apache.hop.git.model.revision.GitObjectRevision;
import org.apache.hop.git.model.revision.ObjectRevision;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnectionFactory;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;

public class UIGit
extends VCS {
    protected static final Class<?> PKG = UIGit.class;
    private Git git;
    private CredentialsProvider credentialsProvider;

    public String getDirectory() {
        return this.directory;
    }

    @VisibleForTesting
    void setDirectory(String directory) {
        this.directory = directory;
    }

    @VisibleForTesting
    void setGit(Git git) {
        this.git = git;
    }

    public String getAuthorName(String commitId) {
        if (commitId.equals("WORKINGTREE")) {
            StoredConfig config = this.git.getRepository().getConfig();
            return ((UserConfig)config.get(UserConfig.KEY)).getAuthorName() + " <" + ((UserConfig)config.get(UserConfig.KEY)).getAuthorEmail() + ">";
        }
        RevCommit commit = this.resolve(commitId);
        PersonIdent author = commit.getAuthorIdent();
        StringBuilder r = new StringBuilder();
        r.append(author.getName());
        r.append(" <");
        r.append(author.getEmailAddress());
        r.append(">");
        return r.toString();
    }

    public String getCommitMessage(String commitId) {
        if (commitId.equals("WORKINGTREE")) {
            try {
                String mergeMsg = this.git.getRepository().readMergeCommitMsg();
                return mergeMsg == null ? "" : mergeMsg;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        RevCommit commit = this.resolve(commitId);
        return commit.getFullMessage();
    }

    public String getCommitId(String revstr) {
        ObjectId id = null;
        try {
            id = this.git.getRepository().resolve(revstr);
        }
        catch (AmbiguousObjectException | IncorrectObjectTypeException | RevisionSyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (id == null) {
            return null;
        }
        return id.getName();
    }

    public String getParentCommitId(String revstr) {
        return this.getCommitId(revstr + "~");
    }

    public String getBranch() {
        try {
            Ref head = this.git.getRepository().exactRef("HEAD");
            String branch = this.git.getRepository().getBranch();
            if (head.getLeaf().getName().equals("HEAD")) {
                return "HEAD detached at " + branch.substring(0, 7);
            }
            return branch;
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<String> getLocalBranches() {
        return this.getBranches(null);
    }

    public List<String> getBranches() {
        return this.getBranches(ListBranchCommand.ListMode.ALL);
    }

    private List<String> getBranches(ListBranchCommand.ListMode mode) {
        try {
            return this.git.branchList().setListMode(mode).call().stream().filter(ref -> !ref.getName().endsWith("HEAD")).map(ref -> Repository.shortenRefName((String)ref.getName())).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getRemote() {
        try {
            StoredConfig config = this.git.getRepository().getConfig();
            RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
            return ((URIish)remoteConfig.getURIs().iterator().next()).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void addRemote(String value) {
        this.removeRemote();
        try {
            URIish uri = new URIish(value);
            RemoteAddCommand cmd = this.git.remoteAdd();
            cmd.setName("origin");
            cmd.setUri(uri);
            cmd.call();
        }
        catch (URISyntaxException e) {
            if (value.equals("")) {
                this.removeRemote();
            } else {
                this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            }
        }
        catch (GitAPIException e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    public void removeRemote() {
        RemoteRemoveCommand cmd = this.git.remoteRemove();
        cmd.setName("origin");
        try {
            cmd.call();
        }
        catch (GitAPIException e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    public boolean hasRemote() {
        StoredConfig config = this.git.getRepository().getConfig();
        Set remotes = config.getSubsections("remote");
        return remotes.contains("origin");
    }

    public boolean commit(String authorName, String message) throws HopException {
        PersonIdent author = RawParseUtils.parsePersonIdent((String)authorName);
        PersonIdent author2 = new PersonIdent(author.getName(), author.getEmailAddress(), SystemReader.getInstance().getCurrentTime(), SystemReader.getInstance().getTimezone(SystemReader.getInstance().getCurrentTime()));
        try {
            this.git.commit().setAuthor(author2).setMessage(message).call();
            return true;
        }
        catch (Exception e) {
            throw new HopException("Error in git commit", (Throwable)e);
        }
    }

    public List<ObjectRevision> getRevisions() {
        return this.getRevisions(null);
    }

    public List<ObjectRevision> getRevisions(String path) {
        ArrayList<ObjectRevision> revisions = new ArrayList<ObjectRevision>();
        try {
            if (!this.isClean() || this.git.getRepository().getRepositoryState() == RepositoryState.MERGING_RESOLVED) {
                GitObjectRevision rev = new GitObjectRevision("WORKINGTREE", "*", new Date(), " // WORKINGTREE");
                revisions.add(rev);
            }
            LogCommand logCommand = this.git.log();
            if (path != null && !".".equals(path)) {
                logCommand = logCommand.addPath(path);
            }
            Iterable iterable = logCommand.call();
            for (RevCommit commit : iterable) {
                GitObjectRevision rev = new GitObjectRevision(commit.getName(), commit.getAuthorIdent().getName(), commit.getAuthorIdent().getWhen(), commit.getShortMessage());
                revisions.add(rev);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return revisions;
    }

    public List<UIFile> getUnstagedFiles() {
        return this.getUnstagedFiles(null);
    }

    public List<UIFile> getUnstagedFiles(String path) {
        ArrayList<UIFile> files = new ArrayList<UIFile>();
        Status status = null;
        try {
            StatusCommand statusCommand = this.git.status();
            if (path != null && !".".equals(path)) {
                statusCommand = statusCommand.addPath(path);
            }
            status = statusCommand.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return files;
        }
        status.getUntracked().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.ADD, false)));
        status.getModified().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.MODIFY, false)));
        status.getConflicting().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.MODIFY, false)));
        status.getMissing().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.DELETE, false)));
        return files;
    }

    public List<UIFile> getStagedFiles() {
        ArrayList<UIFile> files = new ArrayList<UIFile>();
        Status status = null;
        try {
            status = this.git.status().call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return files;
        }
        status.getAdded().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.ADD, true)));
        status.getChanged().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.MODIFY, true)));
        status.getRemoved().forEach(name -> files.add(new UIFile((String)name, DiffEntry.ChangeType.DELETE, true)));
        return files;
    }

    public List<UIFile> getStagedFiles(String oldCommitId, String newCommitId) {
        ArrayList<UIFile> files = new ArrayList<UIFile>();
        try {
            List diffs = this.getDiffCommand(oldCommitId, newCommitId).setShowNameAndStatusOnly(true).call();
            RenameDetector rd = new RenameDetector(this.git.getRepository());
            rd.addAll((Collection)diffs);
            diffs = rd.compute();
            diffs.forEach(diff -> files.add(new UIFile(diff.getChangeType() == DiffEntry.ChangeType.DELETE ? diff.getOldPath() : diff.getNewPath(), diff.getChangeType(), false)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public boolean hasStagedFiles() {
        if (this.git.getRepository().getRepositoryState() == RepositoryState.SAFE) {
            return !this.getStagedFiles().isEmpty();
        }
        return this.git.getRepository().getRepositoryState().canCommit();
    }

    public void initRepo(String baseDirectory) throws Exception {
        this.git = Git.init().setDirectory(new File(baseDirectory)).call();
        this.directory = baseDirectory;
    }

    public void openRepo(String baseDirectory) throws Exception {
        this.git = Git.open((File)new File(baseDirectory));
        this.directory = baseDirectory;
    }

    public void closeRepo() {
        this.git.close();
        this.git = null;
    }

    public void add(String filePattern) throws HopException {
        try {
            if (filePattern.endsWith(".ours") || filePattern.endsWith(".theirs")) {
                FileUtils.rename((File)new File(this.directory, filePattern), (File)new File(this.directory, FilenameUtils.removeExtension((String)filePattern)), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                filePattern = FilenameUtils.removeExtension((String)filePattern);
                org.apache.commons.io.FileUtils.deleteQuietly((File)new File(this.directory, filePattern + ".ours"));
                org.apache.commons.io.FileUtils.deleteQuietly((File)new File(this.directory, filePattern + ".theirs"));
            }
            this.git.add().addFilepattern(filePattern).call();
        }
        catch (Exception e) {
            throw new HopException("Error adding '" + filePattern + "'to git", (Throwable)e);
        }
    }

    public void rm(String filepattern) {
        try {
            this.git.rm().addFilepattern(filepattern).call();
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    public void reset(String name) {
        try {
            this.git.reset().setRef(name).call();
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    public void resetPath(String path) {
        try {
            this.git.reset().addPath(path).call();
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    @VisibleForTesting
    void resetHard() throws Exception {
        this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    public boolean rollback(String name) {
        if (this.hasUncommittedChanges()) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Git.Dialog.UncommittedChanges.Message", (String[])new String[0]));
            return false;
        }
        String commit = this.resolve("HEAD").getName();
        RevertCommand cmd = this.git.revert();
        for (int i = 0; i < this.getRevisions().size(); ++i) {
            String commitId = this.getRevisions().get(i).getRevisionId();
            cmd.include((AnyObjectId)this.resolve(commitId));
            if (commitId.equals(name)) break;
        }
        try {
            cmd.call();
            this.git.reset().setRef(commit).call();
            return true;
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            return false;
        }
    }

    public boolean pull() throws HopException {
        if (this.hasUncommittedChanges()) {
            throw new HopException("You have uncommitted changes. Please commit work before pulling changes.");
        }
        if (!this.hasRemote()) {
            throw new HopException("There is no remote set up to pull from. Please set this up first.");
        }
        try {
            ((FetchCommand)this.git.fetch().setCredentialsProvider(this.credentialsProvider)).call();
            return this.mergeBranch("origin/" + this.getBranch(), MergeStrategy.RECURSIVE.getName());
        }
        catch (TransportException e) {
            if (e.getMessage().contains("Authentication is required but no CredentialsProvider has been registered") || e.getMessage().contains("not authorized")) {
                if (this.promptUsernamePassword()) {
                    return this.pull();
                }
            }
            throw new HopException("There was an error doing a git pull", (Throwable)e);
        }
        catch (Exception e) {
            throw new HopException("There was an error doing a git pull", (Throwable)e);
        }
        return false;
    }

    public boolean push() throws HopException {
        return this.push("default");
    }

    public boolean push(String type) throws HopException {
        if (!this.hasRemote()) {
            throw new HopException("There is no remote set up to push to. Please set this up.");
        }
        String name = null;
        switch (type) {
            case "branch": {
                List<String> names = this.getLocalBranches();
                EnterSelectionDialog esd = this.getEnterSelectionDialog(names.toArray(new String[names.size()]), "Select Branch", "Select the branch to push...");
                name = esd.open();
                if (name != null) break;
                return false;
            }
            case "tag": {
                List<String> names = this.getTags();
                EnterSelectionDialog esd = this.getEnterSelectionDialog(names.toArray(new String[names.size()]), "Select Tag", "Select the tag to push...");
                name = esd.open();
                if (name != null) break;
                return false;
            }
        }
        try {
            name = name == null ? null : this.getExpandedName(name, type);
            PushCommand cmd = this.git.push();
            cmd.setCredentialsProvider(this.credentialsProvider);
            if (name != null) {
                cmd.setRefSpecs(new RefSpec[]{new RefSpec(name)});
            }
            Iterable resultIterable = cmd.call();
            this.processPushResult(resultIterable);
            return true;
        }
        catch (TransportException e) {
            if (e.getMessage().contains("Authentication is required but no CredentialsProvider has been registered") || e.getMessage().contains("not authorized")) {
                if (this.promptUsernamePassword()) {
                    return this.push(type);
                }
            }
            throw new HopException("There was an error doing a git push", (Throwable)e);
        }
        catch (Exception e) {
            throw new HopException("There was an error doing a git push", (Throwable)e);
        }
        return false;
    }

    private void processPushResult(Iterable<PushResult> resultIterable) throws Exception {
        resultIterable.forEach(result -> {
            StringBuilder sb = new StringBuilder();
            result.getRemoteUpdates().stream().filter(update -> update.getStatus() != RemoteRefUpdate.Status.OK).filter(update -> update.getStatus() != RemoteRefUpdate.Status.UP_TO_DATE).forEach(update -> sb.append(result.getURI().toString() + "\n" + update.getSrcRef() + "\n" + update.getStatus().toString() + (String)(update.getMessage() == null ? "" : "\n" + update.getMessage()) + "\n\n"));
            if (sb.length() == 0) {
                this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
            } else {
                this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), sb.toString());
            }
        });
    }

    public String diff(String oldCommitId, String newCommitId) throws Exception {
        return this.diff(oldCommitId, newCommitId, null);
    }

    public String diff(String oldCommitId, String newCommitId, String file) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getDiffCommand(oldCommitId, newCommitId).setOutputStream((OutputStream)out).setPathFilter((TreeFilter)(file == null ? TreeFilter.ALL : PathFilter.create((String)file))).call();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public InputStream open(String file, String commitId) throws HopException {
        ObjectStream objectStream;
        if (commitId.equals("WORKINGTREE")) {
            String baseDirectory = this.getDirectory();
            String filePath = baseDirectory + Const.FILE_SEPARATOR + file;
            try {
                return HopVfs.getInputStream((String)filePath);
            }
            catch (HopFileException e) {
                throw new HopException("Unable to find working tree file '" + filePath + "'", (Throwable)e);
            }
        }
        RevCommit commit = this.resolve(commitId);
        RevTree tree = commit.getTree();
        TreeWalk tw = new TreeWalk(this.git.getRepository());
        try {
            tw.addTree((AnyObjectId)tree);
            tw.setFilter((TreeFilter)PathFilter.create((String)file));
            tw.setRecursive(true);
            tw.next();
            ObjectLoader loader = this.git.getRepository().open((AnyObjectId)tw.getObjectId(0));
            objectStream = loader.openStream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MissingObjectException e) {
                throw new HopException("Unable to find file '" + file + "' for commit ID '" + commitId, (Throwable)e);
            }
            catch (IncorrectObjectTypeException e) {
                throw new HopException("Incorrect object type error for file '" + file + "' for commit ID '" + commitId, (Throwable)e);
            }
            catch (CorruptObjectException e) {
                throw new HopException("Corrupt object error for file '" + file + "' for commit ID '" + commitId, (Throwable)e);
            }
            catch (IOException e) {
                throw new HopException("Error reading git file '" + file + "' for commit ID '" + commitId, (Throwable)e);
            }
        }
        tw.close();
        return objectStream;
    }

    public boolean cloneRepo(String directory, String uri) {
        CloneCommand cmd = Git.cloneRepository();
        cmd.setDirectory(new File(directory));
        cmd.setURI(uri);
        cmd.setCredentialsProvider(this.credentialsProvider);
        try {
            Git gitClone = cmd.call();
            gitClone.close();
            return true;
        }
        catch (Exception e) {
            if (e instanceof TransportException && (e.getMessage().contains("Authentication is required but no CredentialsProvider has been registered") || e.getMessage().contains("not authorized"))) {
                if (this.promptUsernamePassword()) {
                    return this.cloneRepo(directory, uri);
                }
            } else {
                this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            }
            return false;
        }
    }

    public void checkout(String name) {
        try {
            this.git.checkout().setName(name).call();
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
    }

    public void checkoutBranch(String name) {
        this.checkout(name);
    }

    public void checkoutTag(String name) {
        this.checkout(name);
    }

    public void revertPath(String path) throws HopException {
        try {
            Status status = this.git.status().addPath(path).call();
            if (status.getUntracked().size() != 0 || status.getAdded().size() != 0) {
                this.resetPath(path);
                org.apache.commons.io.FileUtils.deleteQuietly((File)new File(this.directory, path));
            }
            this.git.add().addFilepattern(path).call();
            this.git.checkout().setStartPoint("HEAD").addPath(path).call();
            org.apache.commons.io.FileUtils.deleteQuietly((File)new File(this.directory, path + ".ours"));
            org.apache.commons.io.FileUtils.deleteQuietly((File)new File(this.directory, path + ".theirs"));
        }
        catch (Exception e) {
            throw new HopException("Git: error reverting path '" + path + "'", (Throwable)e);
        }
    }

    public List<String> getRevertPathFiles(String path) throws HopException {
        try {
            HashSet files = new HashSet();
            StatusCommand statusCommand = this.git.status();
            if (path != null && !".".equals(path)) {
                statusCommand = statusCommand.addPath(path);
            }
            Status status = statusCommand.call();
            files.addAll(status.getUntracked());
            files.addAll(status.getAdded());
            files.addAll(status.getMissing());
            files.addAll(status.getChanged());
            files.addAll(status.getUncommittedChanges());
            return new ArrayList<String>(files);
        }
        catch (Exception e) {
            throw new HopException("Git: error reverting path files for '" + path + "'", (Throwable)e);
        }
    }

    public boolean createBranch(String value) {
        try {
            this.git.branchCreate().setName(value).call();
            this.checkoutBranch(this.getExpandedName(value, "branch"));
            return true;
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            return false;
        }
    }

    public boolean deleteBranch(String name, boolean force) {
        try {
            this.git.branchDelete().setBranchNames(new String[]{this.getExpandedName(name, "branch")}).setForce(force).call();
            return true;
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            return false;
        }
    }

    private boolean mergeBranch(String value, String mergeStrategy) throws HopException {
        try {
            ObjectId obj = this.git.getRepository().resolve(value);
            MergeResult result = this.git.merge().include((AnyObjectId)obj).setStrategy(MergeStrategy.get((String)mergeStrategy)).call();
            if (result.getMergeStatus().isSuccessful()) {
                return true;
            }
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), result.getMergeStatus().toString());
            if (result.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
                Map conflicts = result.getConflicts();
                for (String path : conflicts.keySet()) {
                    this.checkout(path, "HEAD", ".ours");
                    this.checkout(path, this.getExpandedName(value, "branch"), ".theirs");
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException("Error merging branch '" + value + "' with strategy '" + mergeStrategy + "'", (Throwable)e);
        }
    }

    private boolean hasUncommittedChanges() {
        try {
            return this.git.status().call().hasUncommittedChanges();
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void checkout(String path, String commitId, String postfix) throws HopException {
        InputStream stream = this.open(path, commitId);
        File file = new File(this.directory + Const.FILE_SEPARATOR + path + postfix);
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            stream.close();
        }
        catch (IOException e) {
            throw new HopException("Error checking out file '" + path + "' for commit ID '" + commitId + "' and postfix " + postfix, (Throwable)e);
        }
    }

    private DiffCommand getDiffCommand(String oldCommitId, String newCommitId) throws Exception {
        return this.git.diff().setOldTree(this.getTreeIterator(oldCommitId)).setNewTree(this.getTreeIterator(newCommitId));
    }

    private AbstractTreeIterator getTreeIterator(String commitId) throws Exception {
        if (commitId == null) {
            return new EmptyTreeIterator();
        }
        if (commitId.equals("WORKINGTREE")) {
            return new FileTreeIterator(this.git.getRepository());
        }
        if (commitId.equals("INDEX")) {
            return new DirCacheIterator(this.git.getRepository().readDirCache());
        }
        ObjectId id = this.git.getRepository().resolve(commitId);
        if (id == null) {
            return new EmptyTreeIterator();
        }
        CanonicalTreeParser treeIterator = new CanonicalTreeParser();
        try (RevWalk rw = new RevWalk(this.git.getRepository());){
            RevTree tree = rw.parseTree((AnyObjectId)id);
            try (ObjectReader reader = this.git.getRepository().newObjectReader();){
                treeIterator.reset(reader, (AnyObjectId)tree.getId());
            }
        }
        return treeIterator;
    }

    public String getShortenedName(String name, String type) {
        if (name.length() == 40) {
            return name.substring(0, 7);
        }
        return Repository.shortenRefName((String)name);
    }

    public boolean isClean() {
        try {
            return this.git.status().call().isClean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getTags() {
        try {
            return this.git.tagList().call().stream().map(ref -> Repository.shortenRefName((String)ref.getName())).collect(Collectors.toList());
        }
        catch (GitAPIException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean createTag(String name) {
        try {
            this.git.tag().setName(name).call();
            return true;
        }
        catch (Exception e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            return false;
        }
    }

    public boolean deleteTag(String name) {
        try {
            this.git.tagDelete().setTags(new String[]{this.getExpandedName(name, "tag")}).call();
            return true;
        }
        catch (GitAPIException e) {
            this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
            return false;
        }
    }

    public String getExpandedName(String name, String type) {
        switch (type) {
            case "tag": {
                return "refs/tags/" + name;
            }
            case "branch": {
                try {
                    return this.git.getRepository().findRef("refs/heads/" + name).getName();
                }
                catch (Exception e) {
                    try {
                        return this.git.getRepository().findRef("refs/remotes/" + name).getName();
                    }
                    catch (Exception e1) {
                        this.showMessageBox(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
                    }
                }
            }
        }
        return this.getCommitId(name);
    }

    @Override
    public void setCredential(String username, String password) {
        this.credentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
    }

    public RevCommit resolve(String commitId) {
        block11: {
            RevCommit revCommit;
            ObjectId id = null;
            try {
                id = this.git.getRepository().resolve(commitId);
            }
            catch (AmbiguousObjectException | IncorrectObjectTypeException | RevisionSyntaxException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            RevWalk rw = new RevWalk(this.git.getRepository());
            try {
                RevCommit commit;
                RevObject obj = rw.parseAny((AnyObjectId)id);
                revCommit = commit = (RevCommit)obj;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (MissingObjectException e) {
                    e.printStackTrace();
                    break block11;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            rw.close();
            return revCommit;
        }
        return null;
    }

    @VisibleForTesting
    EnterSelectionDialog getEnterSelectionDialog(String[] choices, String shellText, String message) {
        return new EnterSelectionDialog(HopGui.getInstance().getShell(), choices, shellText, message);
    }

    public Set<String> getIgnored(String path) {
        try {
            StatusCommand statusCommand = this.git.status();
            if (path != null && !".".equals(path)) {
                statusCommand = statusCommand.addPath(path);
            }
            Status status = statusCommand.call();
            return status.getIgnoredNotInIndex();
        }
        catch (GitAPIException e) {
            LogChannel.UI.logError("Error getting list of files ignored by git", (Throwable)e);
            return new HashSet<String>();
        }
    }

    public Git getGit() {
        return this.git;
    }

    static {
        HttpTransport.setConnectionFactory((HttpConnectionFactory)new HttpClientConnectionFactory());
    }
}

