/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula.function;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transforms.formula.function.FunctionDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FunctionLib {
    private List<FunctionDescription> functions = new ArrayList<FunctionDescription>();

    public FunctionLib(String filename) throws HopXmlException {
        Document document = XmlHandler.loadXmlFile((InputStream)this.getClass().getResourceAsStream(filename));
        Node functionsNode = XmlHandler.getSubNode((Node)document, (String)"libformula-functions");
        int nrFunctions = XmlHandler.countNodes((Node)functionsNode, (String)"function");
        for (int i = 0; i < nrFunctions; ++i) {
            Node functionNode = XmlHandler.getSubNodeByNr((Node)functionsNode, (String)"function", (int)i);
            this.functions.add(new FunctionDescription(functionNode));
        }
    }

    public List<FunctionDescription> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<FunctionDescription> functions) {
        this.functions = functions;
    }

    public String[] getFunctionNames() {
        Object[] names = new String[this.functions.size()];
        for (int i = 0; i < this.functions.size(); ++i) {
            names[i] = this.functions.get(i).getName();
        }
        Arrays.sort(names);
        return names;
    }

    public String[] getFunctionCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (FunctionDescription function : this.functions) {
            String category = function.getCategory();
            if (categories.contains(category)) continue;
            categories.add(category);
        }
        Collections.sort(categories);
        return categories.toArray(new String[categories.size()]);
    }

    public String[] getFunctionsForACategory(String category) {
        ArrayList<String> names = new ArrayList<String>();
        for (FunctionDescription function : this.functions) {
            if (!function.getCategory().equalsIgnoreCase(category)) continue;
            names.add(function.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public FunctionDescription getFunctionDescription(String functionName) {
        for (FunctionDescription function : this.functions) {
            if (!function.getName().equalsIgnoreCase(functionName)) continue;
            return function;
        }
        return null;
    }
}

