/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.analyticquery;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQuery;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQueryData;
import org.apache.hop.pipeline.transforms.analyticquery.GroupField;
import org.apache.hop.pipeline.transforms.analyticquery.QueryField;

@Transform(id="AnalyticQuery", image="analyticquery.svg", name="i18n::AnalyticQuery.Name", description="i18n::AnalyticQuery.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", keywords={"i18n::AnalyticQueryMeta.keyword"}, documentationUrl="/pipeline/transforms/analyticquery.html")
public class AnalyticQueryMeta
extends BaseTransformMeta<AnalyticQuery, AnalyticQueryData> {
    private static final Class<?> PKG = AnalyticQuery.class;
    @HopMetadataProperty(groupKey="group", key="field", injectionGroupKey="group")
    private List<GroupField> groupFields = new ArrayList<GroupField>();
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<QueryField> queryFields = new ArrayList<QueryField>();

    public void getFields(IRowMeta r, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMeta fields = new RowMeta();
        fields.addRowMeta(r);
        for (QueryField queryField : this.queryFields) {
            int indexOfSubject = r.indexOfValue(queryField.getSubjectField());
            if (indexOfSubject > -1) {
                IValueMeta vmi = r.getValueMeta(indexOfSubject).clone();
                vmi.setOrigin(origin);
                vmi.setName(queryField.getAggregateField());
                fields.addValueMeta(vmi);
                continue;
            }
            StringBuilder sbFieldNames = new StringBuilder();
            String[] fieldNames = r.getFieldNames();
            for (int j = 0; j < fieldNames.length; ++j) {
                sbFieldNames.append("[").append(fieldNames[j]).append("]").append(j < fieldNames.length - 1 ? ", " : "");
            }
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.Exception.SubjectFieldNotFound", (String[])new String[]{this.getParentTransformMeta().getName(), queryField.getSubjectField(), sbFieldNames.toString()}));
        }
        r.clear();
        r.addRowMeta((IRowMeta)fields);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public List<GroupField> getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(List<GroupField> groupFields) {
        this.groupFields = groupFields;
    }

    public List<QueryField> getQueryFields() {
        return this.queryFields;
    }

    public void setQueryFields(List<QueryField> queryFields) {
        this.queryFields = queryFields;
    }
}

