/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointMarkImpl
implements UnboundedSource.CheckpointMark {
    private final Logger logger = LoggerFactory.getLogger(CheckpointMarkImpl.class);
    final Offset offset;
    private final Optional<Supplier<BlockingCommitter>> committer;

    CheckpointMarkImpl(Offset offset, Supplier<BlockingCommitter> committer) {
        this.offset = offset;
        this.committer = Optional.of(committer);
    }

    private CheckpointMarkImpl(Offset offset) {
        this.offset = offset;
        this.committer = Optional.empty();
    }

    static Coder<CheckpointMarkImpl> coder() {
        return new AtomicCoder<CheckpointMarkImpl>(){

            public void encode(CheckpointMarkImpl value, OutputStream outStream) throws IOException {
                VarLongCoder.of().encode(Long.valueOf(value.offset.value()), outStream);
            }

            public CheckpointMarkImpl decode(InputStream inStream) throws IOException {
                return new CheckpointMarkImpl(Offset.of((long)VarLongCoder.of().decode(inStream)));
            }
        };
    }

    public void finalizeCheckpoint() {
        try {
            Preconditions.checkState((boolean)this.committer.isPresent());
            this.committer.get().get().commitOffset(this.offset);
        }
        catch (Exception e) {
            this.logger.warn("Failed to finalize checkpoint.", (Throwable)e);
        }
    }
}

