/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.MessageSystemAttributeName;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.BucketingFunction;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.EvictingQueue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqsUnboundedReader
extends UnboundedSource.UnboundedReader<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(SqsUnboundedReader.class);
    static final String REQUEST_TIME = "requestTimeMsSinceEpoch";
    public static final int MAX_NUMBER_OF_MESSAGES = 10;
    private static final int BATCH_OPERATION_MAX_RETIRES = 5;
    private static final Duration PROCESSING_TIMEOUT = Duration.standardMinutes((long)2L);
    private static final int VISIBILITY_EXTENSION_PCT = 50;
    private static final int VISIBILITY_SAFETY_PCT = 20;
    private static final Duration VISIBILITY_TOO_LATE = Duration.standardSeconds((long)2L);
    private static final int DELETE_BATCH_SIZE = 10;
    private static final int MAX_IN_FLIGHT = 20000;
    private static final int MAX_AVG_BYTE_MESSAGES = 20;
    private static final Duration SAMPLE_PERIOD = Duration.standardMinutes((long)1L);
    private static final Duration SAMPLE_UPDATE = Duration.standardSeconds((long)5L);
    private static final Duration LOG_PERIOD = Duration.standardSeconds((long)30L);
    private static final int MIN_WATERMARK_MESSAGES = 10;
    private static final int MIN_WATERMARK_SPREAD = 2;
    private static final Combine.BinaryCombineLongFn MIN = Min.ofLongs();
    private static final Combine.BinaryCombineLongFn MAX = Max.ofLongs();
    private static final Combine.BinaryCombineLongFn SUM = Sum.ofLongs();
    private final SqsUnboundedSource source;
    private AtomicBoolean active = new AtomicBoolean(true);
    private AmazonSQS sqsClient = null;
    private Message current;
    final Queue<Message> messagesNotYetRead;
    private Set<String> safeToDeleteIds;
    private long visibilityTimeoutMs;
    private long notYetReadBytes;
    private EvictingQueue<Integer> recentMessageBytes;
    private BucketingFunction minUnreadTimestampMsSinceEpoch;
    private MovingFunction minReadTimestampMsSinceEpoch;
    private MovingFunction numEmptyReceives;
    private final LinkedHashMap<String, InFlightState> inFlight;
    private final Queue<List<String>> deletedIds;
    private long lastReceivedMsSinceEpoch;
    private long lastWatermarkMsSinceEpoch;
    private long lastLogTimestampMsSinceEpoch;
    private long numReceived;
    private MovingFunction numReceivedRecently;
    private MovingFunction numExtendedDeadlines;
    private MovingFunction numLateDeadlines;
    private MovingFunction numDeleted;
    private MovingFunction numExpired;
    private MovingFunction numReleased;
    private MovingFunction numReadBytes;
    private MovingFunction minReceivedTimestampMsSinceEpoch;
    private MovingFunction maxReceivedTimestampMsSinceEpoch;
    private MovingFunction minWatermarkMsSinceEpoch;
    private MovingFunction maxWatermarkMsSinceEpoch;
    private MovingFunction numLateMessages;
    AtomicInteger numInFlightCheckpoints;
    private int maxInFlightCheckpoints;

    private static MovingFunction newFun(Combine.BinaryCombineLongFn function) {
        return new MovingFunction(SAMPLE_PERIOD.getMillis(), SAMPLE_UPDATE.getMillis(), 2, 10, function);
    }

    public SqsUnboundedReader(SqsUnboundedSource source, SqsCheckpointMark sqsCheckpointMark) throws IOException {
        this.source = source;
        this.messagesNotYetRead = new ArrayDeque<Message>();
        this.safeToDeleteIds = new HashSet<String>();
        this.inFlight = new LinkedHashMap();
        this.deletedIds = new ConcurrentLinkedQueue<List<String>>();
        this.visibilityTimeoutMs = -1L;
        this.notYetReadBytes = 0L;
        this.recentMessageBytes = EvictingQueue.create((int)20);
        this.minUnreadTimestampMsSinceEpoch = new BucketingFunction(SAMPLE_UPDATE.getMillis(), 2, 10, MIN);
        this.minReadTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.numEmptyReceives = SqsUnboundedReader.newFun(SUM);
        this.lastReceivedMsSinceEpoch = -1L;
        this.lastWatermarkMsSinceEpoch = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.current = null;
        this.lastLogTimestampMsSinceEpoch = -1L;
        this.numReceived = 0L;
        this.numReceivedRecently = SqsUnboundedReader.newFun(SUM);
        this.numExtendedDeadlines = SqsUnboundedReader.newFun(SUM);
        this.numLateDeadlines = SqsUnboundedReader.newFun(SUM);
        this.numDeleted = SqsUnboundedReader.newFun(SUM);
        this.numExpired = SqsUnboundedReader.newFun(SUM);
        this.numReleased = SqsUnboundedReader.newFun(SUM);
        this.numReadBytes = SqsUnboundedReader.newFun(SUM);
        this.minReceivedTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.maxReceivedTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MAX);
        this.minWatermarkMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.maxWatermarkMsSinceEpoch = SqsUnboundedReader.newFun(MAX);
        this.numLateMessages = SqsUnboundedReader.newFun(SUM);
        this.numInFlightCheckpoints = new AtomicInteger();
        this.maxInFlightCheckpoints = 0;
        if (sqsCheckpointMark != null) {
            long nowMsSinceEpoch = this.now();
            this.initClient();
            this.extendBatch(nowMsSinceEpoch, sqsCheckpointMark.notYetReadReceipts, 0);
            this.numReleased.add(nowMsSinceEpoch, (long)sqsCheckpointMark.notYetReadReceipts.size());
        }
    }

    public Instant getWatermark() {
        long nowMsSinceEpoch = this.now();
        long readMin = this.minReadTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        long unreadMin = this.minUnreadTimestampMsSinceEpoch.get();
        if (readMin == Long.MAX_VALUE && unreadMin == Long.MAX_VALUE && this.numEmptyReceives.get(nowMsSinceEpoch) > 0L && nowMsSinceEpoch > this.lastReceivedMsSinceEpoch + SAMPLE_PERIOD.getMillis()) {
            this.lastWatermarkMsSinceEpoch = nowMsSinceEpoch;
        } else if (this.minReadTimestampMsSinceEpoch.isSignificant() || this.minUnreadTimestampMsSinceEpoch.isSignificant()) {
            this.lastWatermarkMsSinceEpoch = Math.min(readMin, unreadMin);
        }
        this.minWatermarkMsSinceEpoch.add(nowMsSinceEpoch, this.lastWatermarkMsSinceEpoch);
        this.maxWatermarkMsSinceEpoch.add(nowMsSinceEpoch, this.lastWatermarkMsSinceEpoch);
        return new Instant(this.lastWatermarkMsSinceEpoch);
    }

    public Message getCurrent() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public Instant getCurrentTimestamp() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.getTimestamp(this.current);
    }

    public byte[] getCurrentRecordId() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.getMessageId().getBytes(StandardCharsets.UTF_8);
    }

    public UnboundedSource.CheckpointMark getCheckpointMark() {
        int cur = this.numInFlightCheckpoints.incrementAndGet();
        this.maxInFlightCheckpoints = Math.max(this.maxInFlightCheckpoints, cur);
        ArrayList snapshotSafeToDeleteIds = Lists.newArrayList(this.safeToDeleteIds);
        ArrayList<String> snapshotNotYetReadReceipts = new ArrayList<String>(this.messagesNotYetRead.size());
        for (Message message : this.messagesNotYetRead) {
            snapshotNotYetReadReceipts.add(message.getReceiptHandle());
        }
        return new SqsCheckpointMark(this, snapshotSafeToDeleteIds, snapshotNotYetReadReceipts);
    }

    public SqsUnboundedSource getCurrentSource() {
        return this.source;
    }

    public long getTotalBacklogBytes() {
        long avgBytes = this.avgMessageBytes();
        List<String> requestAttributes = Collections.singletonList(QueueAttributeName.ApproximateNumberOfMessages.toString());
        Map queueAttributes = this.sqsClient.getQueueAttributes(this.source.getRead().queueUrl(), requestAttributes).getAttributes();
        long numMessages = Long.parseLong((String)queueAttributes.get(QueueAttributeName.ApproximateNumberOfMessages.toString()));
        if (avgBytes == -1L && numMessages > 0L) {
            return -1L;
        }
        return numMessages * avgBytes;
    }

    public boolean start() throws IOException {
        this.initClient();
        this.visibilityTimeoutMs = (long)Integer.parseInt((String)this.sqsClient.getQueueAttributes(new GetQueueAttributesRequest(this.source.getRead().queueUrl()).withAttributeNames(new String[]{"VisibilityTimeout"})).getAttributes().get("VisibilityTimeout")) * 1000L;
        return this.advance();
    }

    private void initClient() {
        if (this.sqsClient == null) {
            this.sqsClient = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(this.source.getSqsConfiguration().getClientConfiguration())).withCredentials(this.source.getSqsConfiguration().getAwsCredentialsProvider())).withRegion(this.source.getSqsConfiguration().getAwsRegion())).build();
        }
    }

    public boolean advance() throws IOException {
        this.stats();
        if (this.current != null) {
            this.minUnreadTimestampMsSinceEpoch.remove(this.getRequestTimeMsSinceEpoch(this.current).longValue());
            this.current = null;
        }
        this.retire();
        this.extend();
        if (this.messagesNotYetRead.isEmpty()) {
            this.pull();
        }
        this.current = this.messagesNotYetRead.poll();
        if (this.current == null) {
            return false;
        }
        this.notYetReadBytes -= (long)this.current.getBody().getBytes(StandardCharsets.UTF_8).length;
        Preconditions.checkState((this.notYetReadBytes >= 0L ? 1 : 0) != 0);
        long nowMsSinceEpoch = this.now();
        this.numReadBytes.add(nowMsSinceEpoch, (long)this.current.getBody().getBytes(StandardCharsets.UTF_8).length);
        this.recentMessageBytes.add((Object)this.current.getBody().getBytes(StandardCharsets.UTF_8).length);
        this.minReadTimestampMsSinceEpoch.add(nowMsSinceEpoch, this.getCurrentTimestamp().getMillis());
        if (this.getCurrentTimestamp().getMillis() < this.lastWatermarkMsSinceEpoch) {
            this.numLateMessages.add(nowMsSinceEpoch, 1L);
        }
        this.safeToDeleteIds.add(this.current.getMessageId());
        return true;
    }

    public void close() throws IOException {
        this.active.set(false);
        this.maybeCloseClient();
    }

    void maybeCloseClient() throws IOException {
        if (!this.active.get() && this.numInFlightCheckpoints.get() == 0 && this.sqsClient != null) {
            this.sqsClient.shutdown();
        }
    }

    void delete(List<String> messageIds) throws IOException {
        AtomicInteger counter = new AtomicInteger();
        for (List<String> messageList : messageIds.stream().collect(Collectors.groupingBy(x -> counter.getAndIncrement() / 10)).values()) {
            this.deleteBatch(messageList);
        }
    }

    private void deleteBatch(List<String> messageIds) throws IOException {
        int retries = 0;
        List<Object> errorMessages = new ArrayList();
        Map<String, String> pendingReceipts = IntStream.range(0, messageIds.size()).boxed().filter(i -> this.inFlight.containsKey(messageIds.get((int)i))).collect(Collectors.toMap(Object::toString, i -> this.inFlight.get(messageIds.get((int)i.intValue())).receiptHandle));
        while (!pendingReceipts.isEmpty()) {
            if (retries >= 5) {
                throw new IOException("Failed to delete " + pendingReceipts.size() + " messages after " + retries + " retries: " + String.join((CharSequence)", ", errorMessages));
            }
            List entries = pendingReceipts.entrySet().stream().map(r -> new DeleteMessageBatchRequestEntry((String)r.getKey(), (String)r.getValue())).collect(Collectors.toList());
            DeleteMessageBatchResult result = this.sqsClient.deleteMessageBatch(this.source.getRead().queueUrl(), entries);
            Set retryErrors = result.getFailed().stream().filter(e -> !e.getCode().equals("ReceiptHandleIsInvalid")).collect(Collectors.toSet());
            pendingReceipts.keySet().retainAll(retryErrors.stream().map(BatchResultErrorEntry::getId).collect(Collectors.toSet()));
            errorMessages = retryErrors.stream().map(BatchResultErrorEntry::getMessage).collect(Collectors.toList());
            ++retries;
        }
        this.deletedIds.add(messageIds);
    }

    private void retire() {
        long nowMsSinceEpoch = this.now();
        List<String> ackIds;
        block0: while ((ackIds = this.deletedIds.poll()) != null) {
            this.numDeleted.add(nowMsSinceEpoch, (long)ackIds.size());
            Iterator<String> iterator = ackIds.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String ackId = iterator.next();
                this.inFlight.remove(ackId);
                this.safeToDeleteIds.remove(ackId);
            }
            break;
        }
        return;
    }

    private void pull() {
        if (this.inFlight.size() >= 20000) {
            return;
        }
        long requestTimeMsSinceEpoch = this.now();
        long deadlineMsSinceEpoch = requestTimeMsSinceEpoch + this.visibilityTimeoutMs;
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.source.getRead().queueUrl());
        receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(10));
        receiveMessageRequest.setAttributeNames(Arrays.asList(MessageSystemAttributeName.SentTimestamp.toString()));
        ReceiveMessageResult receiveMessageResult = this.sqsClient.receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResult.getMessages();
        if (messages == null || messages.isEmpty()) {
            this.numEmptyReceives.add(requestTimeMsSinceEpoch, 1L);
            return;
        }
        this.lastReceivedMsSinceEpoch = requestTimeMsSinceEpoch;
        for (Message message : messages) {
            MessageAttributeValue reqTime = new MessageAttributeValue().withStringValue(Long.toString(requestTimeMsSinceEpoch));
            message.setMessageAttributes((Map)ImmutableMap.of((Object)REQUEST_TIME, (Object)reqTime));
            this.messagesNotYetRead.add(message);
            this.notYetReadBytes += (long)message.getBody().getBytes(StandardCharsets.UTF_8).length;
            this.inFlight.put(message.getMessageId(), new InFlightState(message.getReceiptHandle(), requestTimeMsSinceEpoch, deadlineMsSinceEpoch));
            ++this.numReceived;
            this.numReceivedRecently.add(requestTimeMsSinceEpoch, 1L);
            long timestampMillis = this.getTimestamp(message).getMillis();
            this.minReceivedTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, timestampMillis);
            this.maxReceivedTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, timestampMillis);
            this.minUnreadTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, timestampMillis);
        }
    }

    long now() {
        return System.currentTimeMillis();
    }

    private void extend() throws IOException {
        while (true) {
            long nowMsSinceEpoch = this.now();
            ArrayList<String> assumeExpired = new ArrayList<String>();
            ArrayList<String> toBeExtended = new ArrayList<String>();
            ArrayList<String> toBeExpired = new ArrayList<String>();
            for (Map.Entry<String, InFlightState> entry : this.inFlight.entrySet()) {
                if (entry.getValue().visibilityDeadlineMsSinceEpoch - this.visibilityTimeoutMs * 20L / 100L > nowMsSinceEpoch) break;
                if (entry.getValue().visibilityDeadlineMsSinceEpoch - VISIBILITY_TOO_LATE.getMillis() < nowMsSinceEpoch) {
                    assumeExpired.add(entry.getKey());
                    continue;
                }
                if (entry.getValue().requestTimeMsSinceEpoch + PROCESSING_TIMEOUT.getMillis() < nowMsSinceEpoch) {
                    toBeExpired.add(entry.getKey());
                    continue;
                }
                toBeExtended.add(entry.getKey());
                if (toBeExtended.size() < 10) continue;
                break;
            }
            if (assumeExpired.isEmpty() && toBeExtended.isEmpty() && toBeExpired.isEmpty()) {
                return;
            }
            if (!assumeExpired.isEmpty()) {
                this.numLateDeadlines.add(nowMsSinceEpoch, (long)assumeExpired.size());
                for (String messageId : assumeExpired) {
                    this.inFlight.remove(messageId);
                }
            }
            if (!toBeExpired.isEmpty()) {
                this.numExpired.add(nowMsSinceEpoch, (long)toBeExpired.size());
                for (String messageId : toBeExpired) {
                    this.inFlight.remove(messageId);
                }
            }
            if (toBeExtended.isEmpty()) continue;
            long extensionMs = (int)(this.visibilityTimeoutMs * 50L / 100L);
            long newDeadlineMsSinceEpoch = nowMsSinceEpoch + extensionMs;
            for (String messageId : toBeExtended) {
                String receiptHandle = this.inFlight.get((Object)messageId).receiptHandle;
                InFlightState state = (InFlightState)this.inFlight.remove(messageId);
                this.inFlight.put(messageId, new InFlightState(receiptHandle, state.requestTimeMsSinceEpoch, newDeadlineMsSinceEpoch));
            }
            List<String> receiptHandles = toBeExtended.stream().map(this.inFlight::get).filter(Objects::nonNull).map(m -> m.receiptHandle).collect(Collectors.toList());
            this.extendBatch(nowMsSinceEpoch, receiptHandles, (int)(extensionMs / 1000L));
        }
    }

    void extendBatch(long nowMsSinceEpoch, List<String> receiptHandles, int extensionSec) throws IOException {
        int retries = 0;
        int numMessages = receiptHandles.size();
        Map<String, String> pendingReceipts = IntStream.range(0, receiptHandles.size()).boxed().collect(Collectors.toMap(Object::toString, receiptHandles::get));
        List<Object> errorMessages = new ArrayList();
        while (!pendingReceipts.isEmpty()) {
            if (retries >= 5) {
                throw new IOException("Failed to extend visibility timeout for " + pendingReceipts.size() + " messages after " + retries + " retries: " + String.join((CharSequence)", ", errorMessages));
            }
            List entries = pendingReceipts.entrySet().stream().map(r -> new ChangeMessageVisibilityBatchRequestEntry((String)r.getKey(), (String)r.getValue()).withVisibilityTimeout(Integer.valueOf(extensionSec))).collect(Collectors.toList());
            ChangeMessageVisibilityBatchResult result = this.sqsClient.changeMessageVisibilityBatch(this.source.getRead().queueUrl(), entries);
            Set retryErrors = result.getFailed().stream().filter(e -> !e.getCode().equals("ReceiptHandleIsInvalid")).collect(Collectors.toSet());
            pendingReceipts.keySet().retainAll(retryErrors.stream().map(BatchResultErrorEntry::getId).collect(Collectors.toSet()));
            errorMessages = retryErrors.stream().map(BatchResultErrorEntry::getMessage).collect(Collectors.toList());
            ++retries;
        }
        this.numExtendedDeadlines.add(nowMsSinceEpoch, (long)numMessages);
    }

    private void stats() {
        long nowMsSinceEpoch = this.now();
        if (this.lastLogTimestampMsSinceEpoch < 0L) {
            this.lastLogTimestampMsSinceEpoch = nowMsSinceEpoch;
            return;
        }
        long deltaMs = nowMsSinceEpoch - this.lastLogTimestampMsSinceEpoch;
        if (deltaMs < LOG_PERIOD.getMillis()) {
            return;
        }
        String messageSkew = "unknown";
        long minTimestamp = this.minReceivedTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        long maxTimestamp = this.maxReceivedTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        if (minTimestamp < Long.MAX_VALUE && maxTimestamp > Long.MIN_VALUE) {
            messageSkew = maxTimestamp - minTimestamp + "ms";
        }
        String watermarkSkew = "unknown";
        long minWatermark = this.minWatermarkMsSinceEpoch.get(nowMsSinceEpoch);
        long maxWatermark = this.maxWatermarkMsSinceEpoch.get(nowMsSinceEpoch);
        if (minWatermark < Long.MAX_VALUE && maxWatermark > Long.MIN_VALUE) {
            watermarkSkew = maxWatermark - minWatermark + "ms";
        }
        String oldestInFlight = "no";
        String oldestAckId = (String)Iterables.getFirst(this.inFlight.keySet(), null);
        if (oldestAckId != null) {
            oldestInFlight = nowMsSinceEpoch - this.inFlight.get((Object)oldestAckId).requestTimeMsSinceEpoch + "ms";
        }
        LOG.debug("SQS {} has {} received messages, {} current unread messages, {} current unread bytes, {} current in-flight msgs, {} oldest in-flight, {} current in-flight checkpoints, {} max in-flight checkpoints, {} bytes in backlog, {}B/s recent read, {} recent received, {} recent extended, {} recent late extended, {} recent deleted, {} recent released, {} recent expired, {} recent message timestamp skew, {} recent watermark skew, {} recent late messages, {} last reported watermark", new Object[]{this.source.getRead().queueUrl(), this.numReceived, this.messagesNotYetRead.size(), this.notYetReadBytes, this.inFlight.size(), oldestInFlight, this.numInFlightCheckpoints.get(), this.maxInFlightCheckpoints, this.getTotalBacklogBytes(), this.numReadBytes.get(nowMsSinceEpoch) / (SAMPLE_PERIOD.getMillis() / 1000L), this.numReceivedRecently.get(nowMsSinceEpoch), this.numExtendedDeadlines.get(nowMsSinceEpoch), this.numLateDeadlines.get(nowMsSinceEpoch), this.numDeleted.get(nowMsSinceEpoch), this.numReleased.get(nowMsSinceEpoch), this.numExpired.get(nowMsSinceEpoch), messageSkew, watermarkSkew, this.numLateMessages.get(nowMsSinceEpoch), new Instant(this.lastWatermarkMsSinceEpoch)});
        this.lastLogTimestampMsSinceEpoch = nowMsSinceEpoch;
    }

    private long avgMessageBytes() {
        if (!this.recentMessageBytes.isEmpty()) {
            return (long)this.recentMessageBytes.stream().mapToDouble(s -> s.intValue()).average().getAsDouble();
        }
        return -1L;
    }

    private Instant getTimestamp(Message message) {
        return new Instant(Long.parseLong((String)message.getAttributes().get(MessageSystemAttributeName.SentTimestamp.toString())));
    }

    private Long getRequestTimeMsSinceEpoch(Message message) {
        return Long.parseLong(((MessageAttributeValue)message.getMessageAttributes().get(REQUEST_TIME)).getStringValue());
    }

    private static class InFlightState {
        String receiptHandle;
        long requestTimeMsSinceEpoch;
        long visibilityDeadlineMsSinceEpoch;

        public InFlightState(String receiptHandle, long requestTimeMsSinceEpoch, long visibilityDeadlineMsSinceEpoch) {
            this.receiptHandle = receiptHandle;
            this.requestTimeMsSinceEpoch = requestTimeMsSinceEpoch;
            this.visibilityDeadlineMsSinceEpoch = visibilityDeadlineMsSinceEpoch;
        }
    }
}

