/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws.sqs.SqsConfiguration;
import org.apache.beam.sdk.io.aws.sqs.SqsIO;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqsUnboundedSource
extends UnboundedSource<Message, SqsCheckpointMark> {
    private final SqsIO.Read read;
    private final SqsConfiguration sqsConfiguration;
    private final Coder<Message> outputCoder;

    public SqsUnboundedSource(SqsIO.Read read, SqsConfiguration sqsConfiguration, Coder<Message> outputCoder) {
        this.read = read;
        this.sqsConfiguration = sqsConfiguration;
        this.outputCoder = outputCoder;
    }

    public List<SqsUnboundedSource> split(int desiredNumSplits, PipelineOptions options) {
        ArrayList<SqsUnboundedSource> sources = new ArrayList<SqsUnboundedSource>();
        for (int i = 0; i < Math.max(1, desiredNumSplits); ++i) {
            sources.add(new SqsUnboundedSource(this.read, this.sqsConfiguration, this.outputCoder));
        }
        return sources;
    }

    public UnboundedSource.UnboundedReader<Message> createReader(PipelineOptions options, @Nullable SqsCheckpointMark checkpointMark) {
        try {
            return new SqsUnboundedReader(this, checkpointMark);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to subscribe to " + this.read.queueUrl() + ": ", e);
        }
    }

    public Coder<SqsCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SqsCheckpointMark.class);
    }

    public Coder<Message> getOutputCoder() {
        return this.outputCoder;
    }

    public SqsIO.Read getRead() {
        return this.read;
    }

    SqsConfiguration getSqsConfiguration() {
        return this.sqsConfiguration;
    }

    public boolean requiresDeduping() {
        return true;
    }
}

