/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

public class EncodedValueComparator
extends TypeComparator<byte[]> {
    private transient byte[] encodedReferenceKey;
    private final boolean ascending;

    public EncodedValueComparator(boolean ascending) {
        this.ascending = ascending;
    }

    public int hash(byte[] record) {
        return Arrays.hashCode(record);
    }

    public void setReference(byte[] toCompare) {
        this.encodedReferenceKey = toCompare;
    }

    public boolean equalToReference(byte[] candidate) {
        if (this.encodedReferenceKey.length != candidate.length) {
            return false;
        }
        int len = candidate.length;
        for (int i = 0; i < len; ++i) {
            if (this.encodedReferenceKey[i] == candidate[i]) continue;
            return false;
        }
        return true;
    }

    public int compareToReference(TypeComparator<byte[]> other) {
        EncodedValueComparator otherEncodedValueComparator = (EncodedValueComparator)other;
        int len = Math.min(this.encodedReferenceKey.length, otherEncodedValueComparator.encodedReferenceKey.length);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b1 = this.encodedReferenceKey[i];
            byte b2 = otherEncodedValueComparator.encodedReferenceKey[i];
            int n = b1 < b2 ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? -result : result;
        }
        int result = this.encodedReferenceKey.length - otherEncodedValueComparator.encodedReferenceKey.length;
        return this.ascending ? -result : result;
    }

    public int compare(byte[] first, byte[] second) {
        int len = Math.min(first.length, second.length);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b1 = first[i];
            byte b2 = second[i];
            int n = b1 < b2 ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        int result = first.length - second.length;
        return this.ascending ? result : -result;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int lengthFirst = firstSource.readInt();
        int lengthSecond = secondSource.readInt();
        int len = Math.min(lengthFirst, lengthSecond);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b2;
            byte b1 = firstSource.readByte();
            int n = b1 < (b2 = secondSource.readByte()) ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        int result = lengthFirst - lengthSecond;
        return this.ascending ? result : -result;
    }

    public boolean supportsNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    public void putNormalizedKey(byte[] record, MemorySegment target, int offset, int numBytes) {
        int limit = offset + numBytes;
        target.put(offset, record, 0, Math.min(numBytes, record.length));
        offset += record.length;
        while (offset < limit) {
            target.put(offset++, (byte)0);
        }
    }

    public void writeWithKeyNormalization(byte[] record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] readWithKeyDenormalization(byte[] reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean invertNormalizedKey() {
        return !this.ascending;
    }

    public TypeComparator<byte[]> duplicate() {
        return new EncodedValueComparator(this.ascending);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return new TypeComparator[]{this.duplicate()};
    }
}

