/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.InputStream;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.sasinput.SasInputField;
import org.apache.hop.pipeline.transforms.sasinput.SasInputMeta;
import org.apache.hop.pipeline.transforms.sasinput.SasUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SasInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SasInputMeta.class;
    private CCombo wAccField;
    private final SasInputMeta input;
    private boolean backupChanged;
    private TableView wFields;

    public SasInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (SasInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlAccField = new Label((Composite)this.shell, 131072);
        wlAccField.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.AcceptField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAccField);
        FormData fdlAccField = new FormData();
        fdlAccField.top = new FormAttachment((Control)lastControl, margin);
        fdlAccField.left = new FormAttachment(0, 0);
        fdlAccField.right = new FormAttachment(middle, -margin);
        wlAccField.setLayoutData((Object)fdlAccField);
        this.wAccField = new CCombo((Composite)this.shell, 18436);
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"SASInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccField);
        FormData fdAccField = new FormData();
        fdAccField.top = new FormAttachment((Control)lastControl, margin);
        fdAccField.left = new FormAttachment(middle, 0);
        fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)fdAccField);
        lastControl = this.wAccField;
        try {
            IRowMeta fields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            this.wAccField.setItems(fields.getFieldNames());
        }
        catch (Exception e2) {
            LogChannel.GENERAL.logError("Couldn't get input fields for transform '" + this.transformMeta + "'", (Throwable)e2);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(100, 0);
        wlFields.setLayoutData((Object)fdlFields);
        lastControl = wlFields;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Rename", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Mask", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.TrimType", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wAccField.setText(Const.NVL((String)this.input.getAcceptingField(), (String)""));
        for (int i = 0; i < this.input.getOutputFields().size(); ++i) {
            SasInputField field = this.input.getOutputFields().get(i);
            TableItem item = new TableItem(this.wFields.table, 0);
            int colnr = 1;
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getRename(), (String)""));
            item.setText(colnr++, ValueMetaFactory.getValueMetaName((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getConversionMask(), (String)""));
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGroupingSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getTrimTypeDesc(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    public void getInfo(SasInputMeta meta) throws HopTransformException {
        meta.setAcceptingField(this.wAccField.getText());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        meta.getOutputFields().clear();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int colnr = 1;
            SasInputField field = new SasInputField();
            field.setName(item.getText(colnr++));
            field.setRename(item.getText(colnr++));
            if (Utils.isEmpty((CharSequence)field.getRename())) {
                field.setRename(field.getName());
            }
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(colnr++)));
            field.setConversionMask(item.getText(colnr++));
            field.setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setDecimalSymbol(item.getText(colnr++));
            field.setGroupingSymbol(item.getText(colnr++));
            field.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(colnr++)));
            meta.getOutputFields().add(field);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        try {
            this.transformName = this.wTransformName.getText();
            this.getInfo(this.input);
        }
        catch (HopTransformException e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(e.toString());
            mb.setText(BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    public void get() {
        block11: {
            try {
                String filename = BaseDialog.presentFileDialog((Shell)this.shell, (String[])new String[]{"*.sas7bdat;*.SAS7BDAT", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"SASInputDialog.FileType.SAS7BAT", (String[])new String[0]) + ", " + BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
                if (filename == null) break block11;
                String realFilename = this.variables.resolve(filename);
                try (InputStream inputStream = HopVfs.getInputStream((String)realFilename);){
                    SasFileReaderImpl sasFileReader = new SasFileReaderImpl(inputStream);
                    SasFileProperties fileProperties = sasFileReader.getSasFileProperties();
                    List columns = sasFileReader.getColumns();
                    for (int c = 0; c < columns.size(); ++c) {
                        Column column = (Column)columns.get(c);
                        ColumnFormat format = column.getFormat();
                        int length = format.getWidth() == 0 ? -1 : format.getWidth();
                        int precision = format.getPrecision() == 0 ? -1 : format.getWidth();
                        TableItem item = new TableItem(this.wFields.table, 0);
                        int colNr = 1;
                        item.setText(colNr++, Const.NVL((String)column.getName(), (String)""));
                        item.setText(colNr++, "");
                        item.setText(colNr++, SasUtil.getHopDataTypeDesc(column.getType()));
                        item.setText(colNr++, "");
                        item.setText(colNr++, length < 0 ? "" : Integer.toString(length));
                        item.setText(colNr++, precision < 0 ? "" : Integer.toString(precision));
                        item.setText(colNr++, "");
                        item.setText(colNr++, "");
                        item.setText(colNr++, "");
                    }
                }
                catch (Exception e) {
                    throw new HopException("Error reading from file: " + realFilename);
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error reading information from file", e);
            }
        }
    }
}

