/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public class UnownedInputStream
extends FilterInputStream {
    public UnownedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream delegate) {
        super(delegate);
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call close().");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj instanceof UnownedInputStream && ((UnownedInputStream)obj).in.equals(this.in);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.in.hashCode();
    }

    @Override
    public void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call mark().");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call reset().");
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(UnownedInputStream.class).add("in", (Object)this.in).toString();
    }
}

