/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUtils;
import org.apache.beam.sdk.values.RowUtils;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.sdk.values.RowWithStorage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class Row
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;

    Row(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        this.schema = schema;
    }

    public abstract <T> T getValue(@UnknownKeyFor @NonNull @Initialized int var1);

    public abstract @UnknownKeyFor @NonNull @Initialized int getFieldCount();

    public abstract @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized Object> getValues();

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> getBaseValues() {
        return IntStream.range(0, this.getFieldCount()).mapToObj(i -> this.getBaseValue(i)).collect(Collectors.toList());
    }

    public <T> T getValue(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getValue(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Byte getByte(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getByte(this.getSchema().indexOf(fieldName));
    }

    public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getBytes(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getBytes(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Short getInt16(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getInt16(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getInt32(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getInt32(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Long getInt64(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getInt64(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized BigDecimal getDecimal(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getDecimal(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Float getFloat(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getFloat(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Double getDouble(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getDouble(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized String getString(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getString(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized ReadableDateTime getDateTime(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getDateTime(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Boolean getBoolean(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getBoolean(this.getSchema().indexOf(fieldName));
    }

    public <T> @Nullable @UnknownKeyFor @Initialized Collection<T> getArray(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getArray(this.getSchema().indexOf(fieldName));
    }

    public <T> @Nullable @UnknownKeyFor @Initialized Iterable<T> getIterable(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getIterable(this.getSchema().indexOf(fieldName));
    }

    public <T1, T2> @Nullable @UnknownKeyFor @Initialized Map<T1, T2> getMap(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getMap(this.getSchema().indexOf(fieldName));
    }

    public <T> T getLogicalTypeValue(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return this.getLogicalTypeValue(this.getSchema().indexOf(fieldName), clazz);
    }

    public <T> T getBaseValue(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return this.getBaseValue(this.getSchema().indexOf(fieldName), clazz);
    }

    public @Nullable @UnknownKeyFor @Initialized Object getBaseValue(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getBaseValue(fieldName, Object.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Row getRow(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.getRow(this.getSchema().indexOf(fieldName));
    }

    public @Nullable @UnknownKeyFor @Initialized Byte getByte(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Byte)this.getValue(idx);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getBytes(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (byte[])this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Short getInt16(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Short)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getInt32(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Integer)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Float getFloat(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Float)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Double getDouble(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Double)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Long getInt64(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Long)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized String getString(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (String)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized ReadableDateTime getDateTime(@UnknownKeyFor @NonNull @Initialized int idx) {
        ReadableInstant instant = (ReadableInstant)this.getValue(idx);
        return instant == null ? null : new DateTime((Object)instant).withZone(instant.getZone());
    }

    public @Nullable @UnknownKeyFor @Initialized BigDecimal getDecimal(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (BigDecimal)this.getValue(idx);
    }

    public @Nullable @UnknownKeyFor @Initialized Boolean getBoolean(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Boolean)this.getValue(idx);
    }

    public <T> @Nullable @UnknownKeyFor @Initialized Collection<T> getArray(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Collection)this.getValue(idx);
    }

    public <T> @Nullable @UnknownKeyFor @Initialized Iterable<T> getIterable(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Iterable)this.getValue(idx);
    }

    public <T1, T2> @Nullable @UnknownKeyFor @Initialized Map<T1, T2> getMap(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Map)this.getValue(idx);
    }

    public <T> T getLogicalTypeValue(@UnknownKeyFor @NonNull @Initialized int idx, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return this.getValue(idx);
    }

    public <T> T getBaseValue(@UnknownKeyFor @NonNull @Initialized int idx, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Object value = this.getValue(idx);
        Schema.FieldType fieldType = this.getSchema().getField(idx).getType();
        if (fieldType.getTypeName().isLogicalType() && value != null) {
            while (fieldType.getTypeName().isLogicalType()) {
                Schema.LogicalType<?, ?> logicalType = fieldType.getLogicalType();
                value = logicalType.toBaseType(value);
                fieldType = fieldType.getLogicalType().getBaseType();
            }
        }
        return value;
    }

    public @Nullable @UnknownKeyFor @Initialized Object getBaseValue(@UnknownKeyFor @NonNull @Initialized int idx) {
        return this.getBaseValue(idx, Object.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Row getRow(@UnknownKeyFor @NonNull @Initialized int idx) {
        return (Row)this.getValue(idx);
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return this.schema;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (!Objects.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (Equals.deepEquals(this.getValue(i), other.getValue(i), this.getSchema().getField(i).getType())) continue;
            return false;
        }
        return true;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int h = 1;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            h = 31 * h + Equals.deepHashCode(this.getValue(i), this.getSchema().getField(i).getType());
        }
        return h;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.toString(true);
    }

    public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized boolean includeFieldNames) {
        StringBuilder builder = new StringBuilder();
        builder.append("Row: ");
        builder.append(System.lineSeparator());
        for (int i = 0; i < this.getSchema().getFieldCount(); ++i) {
            Schema.Field field = this.getSchema().getField(i);
            if (includeFieldNames) {
                builder.append(field.getName() + ":");
            }
            builder.append(this.toString(field.getType(), this.getValue(i), includeFieldNames));
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean includeFieldNames) {
        if (value == null) {
            return "<null>";
        }
        StringBuilder builder = new StringBuilder();
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                builder.append("[");
                for (Object element : (Iterable)value) {
                    builder.append(this.toString(fieldType.getCollectionElementType(), element, includeFieldNames));
                    builder.append(", ");
                }
                builder.append("]");
                break;
            }
            case MAP: {
                builder.append("{");
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    builder.append("(");
                    builder.append(this.toString(fieldType.getMapKeyType(), entry.getKey(), includeFieldNames));
                    builder.append(", ");
                    builder.append(this.toString(fieldType.getMapValueType(), entry.getValue(), includeFieldNames));
                    builder.append("), ");
                }
                builder.append("}");
                break;
            }
            case BYTES: {
                builder.append(Arrays.toString((byte[])value));
                break;
            }
            case ROW: {
                builder.append(((Row)value).toString(includeFieldNames));
                break;
            }
            default: {
                builder.append(value);
            }
        }
        return builder.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new Builder(schema);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueBuilder fromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        return new FieldValueBuilder(row.getSchema(), row);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Collector<T, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Row> toRow(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return Collector.of(() -> new ArrayList(schema.getFieldCount()), List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, values -> Row.withSchema(schema).addValues((List<Object>)values).build(), new Collector.Characteristics[0]);
    }

    public static @UnknownKeyFor @NonNull @Initialized Row nullRow(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return Row.withSchema(schema).addValues(Collections.nCopies(schema.getFieldCount(), null)).build();
    }

    public static class Builder {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values = Lists.newArrayList();
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        Builder(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return this.schema;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldName, value);
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized Integer fieldId, @UnknownKeyFor @NonNull @Initialized Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldId, value);
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldAccessDescriptor, value);
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValues(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> values) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValues(values);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addValue(@Nullable @UnknownKeyFor @Initialized Object values) {
            this.values.add(values);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addValues(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values) {
            this.values.addAll(values);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addValues(Object ... values) {
            return this.addValues(Arrays.asList(values));
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Builder addArray(@UnknownKeyFor @NonNull @Initialized Collection<T> values) {
            this.values.add(values);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addArray(Object ... values) {
            this.addArray(Arrays.asList(values));
            return this;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Builder addIterable(@UnknownKeyFor @NonNull @Initialized Iterable<T> values) {
            this.values.add(values);
            return this;
        }

        @Internal
        public @UnknownKeyFor @NonNull @Initialized Row attachValues(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> attachedValues) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new RowWithStorage(this.schema, attachedValues);
        }

        public @UnknownKeyFor @NonNull @Initialized Row attachValues(Object ... values) {
            return this.attachValues(Arrays.asList(values));
        }

        public @UnknownKeyFor @NonNull @Initialized int nextFieldId() {
            return this.values.size();
        }

        @Internal
        public @UnknownKeyFor @NonNull @Initialized Row withFieldValueGetters(@UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> fieldValueGetterFactory, @UnknownKeyFor @NonNull @Initialized Object getterTarget) {
            Preconditions.checkState((getterTarget != null ? 1 : 0) != 0, (Object)"getters require withGetterTarget.");
            return new RowWithGetters(this.schema, fieldValueGetterFactory, getterTarget);
        }

        public @UnknownKeyFor @NonNull @Initialized Row build() {
            RowUtils.FieldOverrides fieldOverrides;
            Preconditions.checkNotNull((Object)this.schema);
            if (!this.values.isEmpty() && this.values.size() != this.schema.getFieldCount()) {
                throw new IllegalArgumentException("Row expected " + this.schema.getFieldCount() + String.format(" fields (%s).", this.schema.getFields().stream().map(Object::toString).collect(Collectors.joining(", "))) + " initialized with " + this.values.size() + " fields.");
            }
            if (!this.values.isEmpty() && !(fieldOverrides = new RowUtils.FieldOverrides(this.schema, this.values)).isEmpty()) {
                return (Row)new RowUtils.RowFieldMatcher().match(new RowUtils.CapturingRowCases(this.schema, fieldOverrides), Schema.FieldType.row(this.schema), new RowUtils.RowPosition(FieldAccessDescriptor.create()), null);
            }
            return new RowWithStorage(this.schema, Collections.emptyList());
        }
    }

    public static class FieldValueBuilder {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @Nullable @UnknownKeyFor @Initialized Row sourceRow;
        private final @UnknownKeyFor @NonNull @Initialized RowUtils.FieldOverrides fieldOverrides;

        private FieldValueBuilder(@UnknownKeyFor @NonNull @Initialized Schema schema, @Nullable @UnknownKeyFor @Initialized Row sourceRow) {
            this.schema = schema;
            this.sourceRow = sourceRow;
            this.fieldOverrides = new RowUtils.FieldOverrides(schema);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return this.schema;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Object value) {
            return this.withFieldValue(FieldAccessDescriptor.withFieldNames(fieldName), value);
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized Integer fieldId, @UnknownKeyFor @NonNull @Initialized Object value) {
            return this.withFieldValue(FieldAccessDescriptor.withFieldIds(fieldId), value);
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValue(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            FieldAccessDescriptor fieldAccess = fieldAccessDescriptor.resolve(this.getSchema());
            Preconditions.checkArgument((boolean)fieldAccess.referencesSingleField(), (Object)"");
            this.fieldOverrides.addOverride(fieldAccess, new RowUtils.FieldOverride(value));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldValues(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> values) {
            values.entrySet().stream().forEach(e -> this.fieldOverrides.addOverride(FieldAccessDescriptor.withFieldNames((String)e.getKey()).resolve(this.getSchema()), new RowUtils.FieldOverride(e.getValue())));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldValueBuilder withFieldAccessDescriptors(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Object> values) {
            values.entrySet().stream().forEach(e -> this.fieldOverrides.addOverride((FieldAccessDescriptor)e.getKey(), new RowUtils.FieldOverride(e.getValue())));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Row build() {
            Row row = (Row)new RowUtils.RowFieldMatcher().match(new RowUtils.CapturingRowCases(this.getSchema(), this.fieldOverrides), Schema.FieldType.row(this.getSchema()), new RowUtils.RowPosition(FieldAccessDescriptor.create()), this.sourceRow);
            return row;
        }
    }

    public static class Equals {
        public static @UnknownKeyFor @NonNull @Initialized boolean deepEquals(@UnknownKeyFor @NonNull @Initialized Object a, @UnknownKeyFor @NonNull @Initialized Object b, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            if (a == null || b == null) {
                return a == b;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                Schema.LogicalType<?, ?> logicalType = fieldType.getLogicalType();
                return Equals.deepEquals(SchemaUtils.toLogicalBaseType(logicalType, a), SchemaUtils.toLogicalBaseType(logicalType, b), logicalType.getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.equals((byte[])a, (byte[])b);
            }
            if (fieldType.getTypeName() == Schema.TypeName.ARRAY) {
                return Equals.deepEqualsForCollection((Collection)a, (Collection)b, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.ITERABLE) {
                return Equals.deepEqualsForIterable((Iterable)a, (Iterable)b, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepEqualsForMap((Map)a, (Map)b, fieldType.getMapValueType());
            }
            return Objects.equals(a, b);
        }

        public static @UnknownKeyFor @NonNull @Initialized int deepHashCode(@UnknownKeyFor @NonNull @Initialized Object a, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            if (a == null) {
                return 0;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                return Equals.deepHashCode(a, fieldType.getLogicalType().getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.hashCode((byte[])a);
            }
            if (fieldType.getTypeName().isCollectionType()) {
                return Equals.deepHashCodeForIterable((Iterable)a, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepHashCodeForMap((Map)a, fieldType.getMapKeyType(), fieldType.getMapValueType());
            }
            return Objects.hashCode(a);
        }

        static <K, V> @UnknownKeyFor @NonNull @Initialized boolean deepEqualsForMap(@UnknownKeyFor @NonNull @Initialized Map<K, V> a, @UnknownKeyFor @NonNull @Initialized Map<K, V> b, @UnknownKeyFor @NonNull @Initialized Schema.FieldType valueType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : a.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                V otherValue = b.get(key);
                if (!(value == null ? otherValue != null || !b.containsKey(key) : !Equals.deepEquals(value, otherValue, valueType))) continue;
                return false;
            }
            return true;
        }

        static @UnknownKeyFor @NonNull @Initialized int deepHashCodeForMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> a, @UnknownKeyFor @NonNull @Initialized Schema.FieldType keyType, @UnknownKeyFor @NonNull @Initialized Schema.FieldType valueType) {
            int h = 0;
            for (Map.Entry<Object, Object> e : a.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                h += Equals.deepHashCode(key, keyType) ^ Equals.deepHashCode(value, valueType);
            }
            return h;
        }

        static @UnknownKeyFor @NonNull @Initialized boolean deepEqualsForCollection(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> a, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> b, @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            return Equals.deepEqualsForIterable(a, b, elementType);
        }

        static @UnknownKeyFor @NonNull @Initialized boolean deepEqualsForIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> a, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> b, @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType) {
            if (a == b) {
                return true;
            }
            Iterator<Object> bIter = b.iterator();
            for (Object currentA : a) {
                if (!bIter.hasNext()) {
                    return false;
                }
                if (Equals.deepEquals(currentA, bIter.next(), elementType)) continue;
                return false;
            }
            return !bIter.hasNext();
        }

        static @UnknownKeyFor @NonNull @Initialized int deepHashCodeForIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> a, @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType) {
            int h = 1;
            for (Object o : a) {
                h = 31 * h + Equals.deepHashCode(o, elementType);
            }
            return h;
        }
    }
}

