/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.reflect.ClassTag;

public class BoundedDatasetFactory {
    private BoundedDatasetFactory() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> createDatasetFromRows(@UnknownKeyFor @NonNull @Initialized SparkSession session, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> encoder) {
        Params<T> params = new Params<T>(encoder, options, session.sparkContext().defaultParallelism());
        BeamTable<T> table = new BeamTable<T>(source, params);
        DataSourceV2Relation logicalPlan = DataSourceV2Relation.create(table, (Option)Option.empty(), (Option)Option.empty());
        return Dataset.ofRows((SparkSession)session, (LogicalPlan)logicalPlan).as(encoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> createDatasetFromRDD(@UnknownKeyFor @NonNull @Initialized SparkSession session, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> encoder) {
        Params<T> params = new Params<T>(encoder, options, session.sparkContext().defaultParallelism());
        BoundedRDD<T> rdd = new BoundedRDD<T>(session.sparkContext(), source, params);
        return session.createDataset(rdd, encoder);
    }

    private static class Params<@UnknownKeyFor T>
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> encoder;
        final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options;
        final @UnknownKeyFor @NonNull @Initialized int numPartitions;

        Params(@UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> encoder, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized int numPartitions) {
            Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be greater than zero.");
            this.encoder = encoder;
            this.options = options;
            this.numPartitions = numPartitions;
        }
    }

    private static class SourcePartitionIterator<@UnknownKeyFor T>
    extends AbstractIterator<WindowedValue<T>>
    implements Closeable {
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> reader;
        @UnknownKeyFor @NonNull @Initialized boolean started = false;

        public SourcePartitionIterator(@UnknownKeyFor @NonNull @Initialized SourcePartition<T> partition, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
            try {
                this.reader = partition.source.createReader(params.options.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create reader from a BoundedSource.", e);
            }
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.reader != null) {
                this.endOfData();
                try {
                    this.reader.close();
                }
                finally {
                    this.reader = null;
                }
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized WindowedValue<T> computeNext() {
            try {
                if (this.started ? this.reader.advance() : this.start()) {
                    return WindowedValue.timestampedValueInGlobalWindow((Object)this.reader.getCurrent(), (Instant)this.reader.getCurrentTimestamp());
                }
                this.close();
                return (WindowedValue)this.endOfData();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to start or advance reader.", e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.started = true;
            return this.reader.start();
        }
    }

    private static class SourcePartition<@UnknownKeyFor T>
    implements Partition,
    InputPartition {
        final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;
        final @UnknownKeyFor @NonNull @Initialized int index;

        SourcePartition(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized IntSupplier idxSupplier) {
            this.source = source;
            this.index = idxSupplier.getAsInt();
        }

        static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SourcePartition<T>> partitionsOf(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
            try {
                PipelineOptions options = params.options.get();
                long desiredSize = source.getEstimatedSizeBytes(options) / (long)params.numPartitions;
                List split = source.split(desiredSize, options);
                IntSupplier idxSupplier = new AtomicInteger(0)::getAndIncrement;
                return split.stream().map(s -> new SourcePartition(s, idxSupplier)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException("Error splitting BoundedSource " + source.getClass().getCanonicalName(), e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized int index() {
            return this.index;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.index;
        }
    }

    private static class BeamTable<@UnknownKeyFor T>
    implements Table,
    SupportsRead {
        final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;
        final @UnknownKeyFor @NonNull @Initialized Params<T> params;

        BeamTable(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
            this.source = source;
            this.params = params;
        }

        public @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getEncoder() {
            return this.params.encoder;
        }

        public @UnknownKeyFor @NonNull @Initialized ScanBuilder newScanBuilder(@UnknownKeyFor @NonNull @Initialized CaseInsensitiveStringMap ignored) {
            return () -> new Scan(){

                public @UnknownKeyFor @NonNull @Initialized StructType readSchema() {
                    return params.encoder.schema();
                }

                public @UnknownKeyFor @NonNull @Initialized Batch toBatch() {
                    return new BeamBatch(source, params);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized String name() {
            return "BeamSource<" + this.source.getClass().getName() + ">";
        }

        public @UnknownKeyFor @NonNull @Initialized StructType schema() {
            return this.params.encoder.schema();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TableCapability> capabilities() {
            return ImmutableSet.of((Object)TableCapability.BATCH_READ);
        }

        private static class BeamPartitionReader<@UnknownKeyFor T>
        implements PartitionReader<InternalRow> {
            final @UnknownKeyFor @NonNull @Initialized SourcePartitionIterator<T> iterator;
            final // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ExpressionEncoder.Serializer<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> serializer;
            @javax.annotation.Nullable
            transient @UnknownKeyFor @Nullable @Initialized InternalRow next;

            BeamPartitionReader(@UnknownKeyFor @NonNull @Initialized SourcePartition<T> partition, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
                this.iterator = new SourcePartitionIterator<T>(partition, params);
                this.serializer = ((ExpressionEncoder)params.encoder).createSerializer();
            }

            public @UnknownKeyFor @NonNull @Initialized boolean next() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.iterator.hasNext()) {
                    this.next = this.serializer.apply((Object)((WindowedValue)this.iterator.next()));
                    return true;
                }
                return false;
            }

            public @UnknownKeyFor @NonNull @Initialized InternalRow get() {
                if (this.next == null) {
                    throw new IllegalStateException("Next not available");
                }
                return this.next;
            }

            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.next = null;
                this.iterator.close();
            }
        }

        private static class BeamBatch<@UnknownKeyFor T>
        implements Batch,
        Serializable {
            final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;
            final @UnknownKeyFor @NonNull @Initialized Params<T> params;

            private BeamBatch(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
                this.source = source;
                this.params = params;
            }

            public @UnknownKeyFor @NonNull @Initialized InputPartition @UnknownKeyFor @NonNull @Initialized [] planInputPartitions() {
                return SourcePartition.partitionsOf(this.source, this.params).toArray(new InputPartition[0]);
            }

            public @UnknownKeyFor @NonNull @Initialized PartitionReaderFactory createReaderFactory() {
                return (PartitionReaderFactory & Serializable)p -> new BeamPartitionReader((SourcePartition)p, this.params);
            }
        }
    }

    private static class BoundedRDD<@UnknownKeyFor T>
    extends RDD<WindowedValue<T>> {
        final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;
        final @UnknownKeyFor @NonNull @Initialized Params<T> params;

        public BoundedRDD(@UnknownKeyFor @NonNull @Initialized SparkContext sc, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized Params<T> params) {
            super(sc, ScalaInterop.emptyList(), ClassTag.apply(WindowedValue.class));
            this.source = source;
            this.params = params;
        }

        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> compute(@UnknownKeyFor @NonNull @Initialized Partition split, @UnknownKeyFor @NonNull @Initialized TaskContext context) {
            return new InterruptibleIterator(context, JavaConverters.asScalaIterator(new SourcePartitionIterator<T>((SourcePartition)split, this.params)));
        }

        public @UnknownKeyFor @NonNull @Initialized Partition @UnknownKeyFor @NonNull @Initialized [] getPartitions() {
            return SourcePartition.partitionsOf(this.source, this.params).toArray(new Partition[0]);
        }
    }
}

