/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.CombineGloballyTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.CombineGroupedValuesTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.CombinePerKeyTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.FlattenTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.GroupByKeyTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ImpulseTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ParDoTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ReadSourceTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ReshuffleTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.WindowAssignTranslatorBatch;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class PipelineTranslatorBatch
extends PipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @UnknownKeyFor @NonNull @Initialized TransformTranslator> TRANSFORM_TRANSLATORS = new HashMap<Class<? extends PTransform>, TransformTranslator>();

    @Override
    protected <InT extends PInput, OutT extends POutput, TransformT extends PTransform<InT, OutT>> @Nullable @UnknownKeyFor @Initialized TransformTranslator<InT, OutT, TransformT> getTransformTranslator(TransformT transform) {
        return TRANSFORM_TRANSLATORS.get(transform.getClass());
    }

    static {
        TRANSFORM_TRANSLATORS.put(Impulse.class, new ImpulseTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Combine.PerKey.class, new CombinePerKeyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Combine.Globally.class, new CombineGloballyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Combine.GroupedValues.class, new CombineGroupedValuesTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(GroupByKey.class, new GroupByKeyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Reshuffle.class, new ReshuffleTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Reshuffle.ViaRandomKey.class, new ReshuffleTranslatorBatch.ViaRandomKey());
        TRANSFORM_TRANSLATORS.put(Flatten.PCollections.class, new FlattenTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Window.Assign.class, new WindowAssignTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(ParDo.MultiOutput.class, new ParDoTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(SplittableParDo.PrimitiveBoundedRead.class, new ReadSourceTranslatorBatch());
    }
}

