/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputReader;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputTransformControl;
import org.apache.hop.pipeline.transforms.fileinput.text.BOMDetector;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputData;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputUtils;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileLine;
import org.apache.hop.ui.pipeline.transform.common.TextFileLineUtil;

public class TextFileInputReader
implements IBaseFileInputReader {
    private static final int BUFFER_SIZE_INPUT_STREAM = 8192;
    private final IBaseFileInputTransformControl transform;
    private final TextFileInputMeta meta;
    private final TextFileInputData data;
    private final ILogChannel log;
    private final CompressionInputStream in;
    private final InputStreamReader isr;
    protected long lineInFile;
    private boolean first;
    protected long lineNumberInFile;

    public TextFileInputReader(IBaseFileInputTransformControl transform, TextFileInputMeta meta, TextFileInputData data, FileObject file, ILogChannel log) throws Exception {
        this.transform = transform;
        this.meta = meta;
        this.data = data;
        this.log = log;
        ICompressionProvider provider = CompressionProviderFactory.getInstance().getCompressionProviderByName(meta.content.fileCompression);
        if (log.isDetailed()) {
            log.logDetailed("This is a compressed file being handled by the " + provider.getName() + " provider");
        }
        this.in = provider.createInputStream(HopVfs.getInputStream((FileObject)file));
        this.in.nextEntry();
        BufferedInputStream inStream = new BufferedInputStream((InputStream)this.in, 8192);
        BOMDetector bom = new BOMDetector(inStream);
        this.isr = bom.bomExist() ? new InputStreamReader((InputStream)inStream, bom.getCharset()) : (meta.getEncoding() != null && meta.getEncoding().length() > 0 ? new InputStreamReader((InputStream)inStream, meta.getEncoding()) : new InputStreamReader(inStream));
        String encoding = this.isr.getEncoding();
        data.encodingType = EncodingType.guessEncodingType((String)encoding);
        this.readInitial();
    }

    protected void readInitial() throws Exception {
        int i;
        this.data.doneWithHeader = !this.meta.content.header;
        this.data.doneReading = false;
        int bufferSize = 1;
        bufferSize += this.meta.content.header ? this.meta.content.nrHeaderLines : 0;
        bufferSize += this.meta.content.layoutPaged ? this.meta.content.nrLinesPerPage * (Math.max(0, this.meta.content.nrWraps) + 1) : Math.max(0, this.meta.content.nrWraps);
        bufferSize += this.meta.content.footer ? this.meta.content.nrFooterLines : 0;
        if (this.meta.content.layoutPaged) {
            for (i = 0; i < this.meta.content.nrLinesDocHeader; ++i) {
                TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)this.isr, (EncodingType)this.data.encodingType, (int)this.data.fileFormatType, (StringBuilder)this.data.lineStringBuilder);
                ++this.lineNumberInFile;
            }
        }
        for (i = 0; i < bufferSize && !this.data.doneReading; ++i) {
            boolean wasNotFiltered = this.tryToReadLine(!this.meta.content.header || i >= this.meta.content.nrHeaderLines);
            if (wasNotFiltered) continue;
            ++bufferSize;
        }
        this.data.headerLinesRead = 0;
        this.data.footerLinesRead = 0;
        this.data.pageLinesRead = 0;
    }

    public boolean readRow() throws HopException {
        String extra;
        int i;
        Object[] r = null;
        boolean retval = true;
        boolean putrow = false;
        if (!this.data.doneReading) {
            int repeats = 1;
            if (this.meta.content.lineWrapped) {
                int n = repeats = this.meta.content.nrWraps > 0 ? this.meta.content.nrWraps : repeats;
            }
            if (!this.data.doneWithHeader && this.data.headerLinesRead == 0) {
                repeats += this.meta.content.nrHeaderLines + 1;
            }
            for (i = 0; i < repeats && !this.data.doneReading; ++i) {
                if (this.tryToReadLine(true)) continue;
                ++repeats;
            }
        }
        if (this.data.lineBuffer.isEmpty()) {
            return false;
        }
        TextFileLine textLine = this.data.lineBuffer.get(0);
        this.transform.incrementLinesInput();
        this.data.lineBuffer.remove(0);
        if (this.meta.content.layoutPaged) {
            if (!this.data.doneWithHeader && this.data.pageLinesRead == 0) {
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel("P-HEADER (" + this.data.headerLinesRead + ") : " + textLine.line);
                }
                ++this.data.headerLinesRead;
                if (this.data.headerLinesRead >= this.meta.content.nrHeaderLines) {
                    this.data.doneWithHeader = true;
                }
            } else if (this.data.pageLinesRead < this.meta.content.nrLinesPerPage) {
                if (this.meta.content.lineWrapped) {
                    for (i = 0; i < this.meta.content.nrWraps; ++i) {
                        extra = "";
                        if (this.data.lineBuffer.size() > 0) {
                            extra = this.data.lineBuffer.get((int)0).line;
                            this.data.lineBuffer.remove(0);
                        }
                        textLine.line = textLine.line + extra;
                    }
                }
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel("P-DATA: " + textLine.line);
                }
                ++this.data.pageLinesRead;
                ++this.lineInFile;
                long useNumber = this.meta.content.rowNumberByFile ? this.lineInFile : this.transform.getLinesWritten() + 1L;
                r = TextFileInputUtils.convertLineToRow(this.log, textLine, this.meta, this.data.currentPassThruFieldsRow, this.data.nrPassThruFields, this.data.outputRowMeta, this.data.convertRowMeta, this.data.filename, useNumber, this.data.separator, this.data.enclosure, this.data.escapeCharacter, this.data.dataErrorLineHandler, this.meta.additionalOutputFields, this.data.shortFilename, this.data.path, this.data.hidden, this.data.lastModificationDateTime, this.data.uriName, this.data.rootUriName, this.data.extension, this.data.size);
                if (r != null) {
                    putrow = true;
                }
                if (!this.meta.content.footer && this.data.pageLinesRead == this.meta.content.nrLinesPerPage) {
                    this.data.doneWithHeader = false;
                    this.data.headerLinesRead = 0;
                    this.data.pageLinesRead = 0;
                    this.data.footerLinesRead = 0;
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel("RESTART PAGE");
                    }
                }
            } else {
                if (this.meta.content.footer && this.data.footerLinesRead < this.meta.content.nrFooterLines) {
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel("P-FOOTER: " + textLine.line);
                    }
                    ++this.data.footerLinesRead;
                }
                if (!this.meta.content.footer || this.data.footerLinesRead >= this.meta.content.nrFooterLines) {
                    this.data.doneWithHeader = false;
                    this.data.headerLinesRead = 0;
                    this.data.pageLinesRead = 0;
                    this.data.footerLinesRead = 0;
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel("RESTART PAGE");
                    }
                }
            }
        } else if (!this.data.doneWithHeader) {
            ++this.data.headerLinesRead;
            if (this.data.headerLinesRead >= this.meta.content.nrHeaderLines) {
                this.data.doneWithHeader = true;
            }
        } else if (this.data.doneReading && this.meta.content.footer && this.data.lineBuffer.size() < this.meta.content.nrFooterLines) {
            this.data.lineBuffer.clear();
        } else {
            if (this.meta.content.lineWrapped) {
                for (i = 0; i < this.meta.content.nrWraps; ++i) {
                    extra = "";
                    if (this.data.lineBuffer.size() > 0) {
                        extra = this.data.lineBuffer.get((int)0).line;
                        this.data.lineBuffer.remove(0);
                    } else {
                        this.tryToReadLine(true);
                        if (!this.data.lineBuffer.isEmpty()) {
                            extra = this.data.lineBuffer.remove((int)0).line;
                        }
                    }
                    textLine.line = textLine.line + extra;
                }
            }
            if (this.data.filePlayList.isProcessingNeeded(textLine.file, textLine.lineNumber, "NO_PARTS")) {
                ++this.lineInFile;
                long useNumber = this.meta.content.rowNumberByFile ? this.lineInFile : this.transform.getLinesWritten() + 1L;
                r = TextFileInputUtils.convertLineToRow(this.log, textLine, this.meta, this.data.currentPassThruFieldsRow, this.data.nrPassThruFields, this.data.outputRowMeta, this.data.convertRowMeta, this.data.filename, useNumber, this.data.separator, this.data.enclosure, this.data.escapeCharacter, this.data.dataErrorLineHandler, this.meta.additionalOutputFields, this.data.shortFilename, this.data.path, this.data.hidden, this.data.lastModificationDateTime, this.data.uriName, this.data.rootUriName, this.data.extension, this.data.size);
                if (r != null) {
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel("Found data row: " + this.data.outputRowMeta.getString(r));
                    }
                    putrow = true;
                }
            } else {
                putrow = false;
            }
        }
        if (putrow && r != null) {
            if (this.data.nr_repeats > 0) {
                if (this.data.previousRow == null) {
                    this.data.previousRow = this.data.outputRowMeta.cloneRow(r);
                } else {
                    for (i = 0; i < this.meta.inputFields.length; ++i) {
                        if (!this.meta.inputFields[i].isRepeated()) continue;
                        if (r[i] == null) {
                            r[i] = this.data.previousRow[i];
                            continue;
                        }
                        this.data.previousRow[i] = r[i];
                    }
                }
            }
            if (this.log.isRowLevel()) {
                this.log.logRowlevel("Putting row: " + this.data.outputRowMeta.getString(r));
            }
            this.transform.putRow(this.data.outputRowMeta, r);
            if (this.transform.getLinesInput() >= this.meta.content.rowLimit && this.meta.content.rowLimit > 0L) {
                this.close();
                return false;
            }
        }
        if (this.transform.checkFeedback(this.transform.getLinesInput()) && this.log.isBasic()) {
            this.log.logBasic("linenr " + this.transform.getLinesInput());
        }
        return retval;
    }

    public void close() {
        try {
            if (this.data.filename != null) {
                this.data.lineBuffer.clear();
                this.transform.incrementLinesUpdated();
                if (this.in != null) {
                    BaseTransform.closeQuietly((Closeable)this.in);
                }
                this.isr.close();
                this.data.filename = null;
                if (this.data.file != null) {
                    try {
                        this.data.file.close();
                        this.data.file = null;
                    }
                    catch (Exception e) {
                        this.log.logError("Error closing file", (Throwable)e);
                    }
                    this.data.file = null;
                }
            }
            this.data.dataErrorLineHandler.close();
        }
        catch (Exception e) {
            String errorMsg = "Couldn't close file : " + this.data.file.getName().getFriendlyURI() + " --> " + e.toString();
            this.log.logError(errorMsg);
            if (this.transform.failAfterBadFile(errorMsg)) {
                this.transform.stopAll();
            }
            this.transform.setErrors(this.transform.getErrors() + 1L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tryToReadLine(boolean applyFilter) throws HopFileException {
        String line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)this.isr, (EncodingType)this.data.encodingType, (int)this.data.fileFormatType, (StringBuilder)this.data.lineStringBuilder);
        if (line != null) {
            if (applyFilter) {
                boolean isFilterLastLine = false;
                boolean filterOK = this.checkFilterRow(line, isFilterLastLine);
                if (!filterOK) return false;
                this.data.lineBuffer.add(new TextFileLine(line, this.lineNumberInFile++, this.data.file));
                return true;
            } else {
                if (this.meta.content.noEmptyLines && line.length() == 0) return true;
                this.data.lineBuffer.add(new TextFileLine(line, this.lineNumberInFile++, this.data.file));
            }
            return true;
        } else {
            this.data.doneReading = true;
        }
        return true;
    }

    private boolean checkFilterRow(String line, boolean isFilterLastLine) {
        boolean filterOK = true;
        if (this.meta.content.noEmptyLines && line.length() == 0) {
            filterOK = false;
        } else {
            filterOK = this.data.filterProcessor.doFilters(line);
            if (!filterOK && this.data.filterProcessor.isStopProcessing()) {
                this.data.doneReading = true;
            }
        }
        return filterOK;
    }
}

